/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.reader;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONAwareEx;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONStreamAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONStreamAwareEx;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONStyle;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.reader.ArrayWriter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.reader.BeansWriter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.reader.BeansWriterASM;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.reader.BeansWriterASMRemap;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.reader.JsonWriterI;

public class JsonWriter {
    private ConcurrentHashMap<Class<?>, JsonWriterI<?>> data = new ConcurrentHashMap();
    private LinkedList<WriterByInterface> writerInterfaces = new LinkedList();
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E e2, Appendable appendable, JSONStyle jSONStyle) throws IOException {
            e2.writeJSONString(appendable);
        }
    };
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareExWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E e2, Appendable appendable, JSONStyle jSONStyle) throws IOException {
            e2.writeJSONString(appendable, jSONStyle);
        }
    };
    public static final JsonWriterI<JSONAwareEx> JSONJSONAwareExWriter = new JsonWriterI<JSONAwareEx>(){

        @Override
        public <E extends JSONAwareEx> void writeJSONString(E e2, Appendable appendable, JSONStyle jSONStyle) throws IOException {
            appendable.append(e2.toJSONString(jSONStyle));
        }
    };
    public static final JsonWriterI<JSONAware> JSONJSONAwareWriter = new JsonWriterI<JSONAware>(){

        @Override
        public <E extends JSONAware> void writeJSONString(E e2, Appendable appendable, JSONStyle jSONStyle) throws IOException {
            appendable.append(e2.toJSONString());
        }
    };
    public static final JsonWriterI<Iterable<? extends Object>> JSONIterableWriter = new JsonWriterI<Iterable<? extends Object>>(){

        @Override
        public <E extends Iterable<? extends Object>> void writeJSONString(E e2, Appendable appendable, JSONStyle jSONStyle) throws IOException {
            boolean bl2 = true;
            jSONStyle.arrayStart(appendable);
            for (Object object : e2) {
                if (bl2) {
                    bl2 = false;
                    jSONStyle.arrayfirstObject(appendable);
                } else {
                    jSONStyle.arrayNextElm(appendable);
                }
                if (object == null) {
                    appendable.append("null");
                } else {
                    JSONValue.writeJSONString(object, appendable, jSONStyle);
                }
                jSONStyle.arrayObjectEnd(appendable);
            }
            jSONStyle.arrayStop(appendable);
        }
    };
    public static final JsonWriterI<Enum<?>> EnumWriter = new JsonWriterI<Enum<?>>(){

        @Override
        public <E extends Enum<?>> void writeJSONString(E e2, Appendable appendable, JSONStyle jSONStyle) throws IOException {
            String string = e2.name();
            jSONStyle.writeString(appendable, string);
        }
    };
    public static final JsonWriterI<Map<String, ? extends Object>> JSONMapWriter = new JsonWriterI<Map<String, ? extends Object>>(){

        @Override
        public <E extends Map<String, ? extends Object>> void writeJSONString(E e2, Appendable appendable, JSONStyle jSONStyle) throws IOException {
            boolean bl2 = true;
            jSONStyle.objectStart(appendable);
            for (Map.Entry<String, ? extends Object> entry : e2.entrySet()) {
                Object object = entry.getValue();
                if (object == null && jSONStyle.ignoreNull()) continue;
                if (bl2) {
                    jSONStyle.objectFirstStart(appendable);
                    bl2 = false;
                } else {
                    jSONStyle.objectNext(appendable);
                }
                JsonWriter.writeJSONKV(entry.getKey().toString(), object, appendable, jSONStyle);
            }
            jSONStyle.objectStop(appendable);
        }
    };
    public static final JsonWriterI<Object> beansWriterASM = new BeansWriterASM();
    public static final JsonWriterI<Object> beansWriter = new BeansWriter();
    public static final JsonWriterI<Object> arrayWriter = new ArrayWriter();
    public static final JsonWriterI<Object> toStringWriter = new JsonWriterI<Object>(){

        @Override
        public void writeJSONString(Object object, Appendable appendable, JSONStyle jSONStyle) throws IOException {
            appendable.append(object.toString());
        }
    };

    public JsonWriter() {
        this.init();
    }

    public <T> void remapField(Class<T> clazz, String string, String string2) {
        JsonWriterI jsonWriterI = this.getWrite(clazz);
        if (!(jsonWriterI instanceof BeansWriterASMRemap)) {
            jsonWriterI = new BeansWriterASMRemap();
            this.registerWriter(jsonWriterI, clazz);
        }
        ((BeansWriterASMRemap)jsonWriterI).renameField(string, string2);
    }

    public JsonWriterI getWriterByInterface(Class<?> clazz) {
        for (WriterByInterface writerByInterface : this.writerInterfaces) {
            if (!writerByInterface._interface.isAssignableFrom(clazz)) continue;
            return writerByInterface._writer;
        }
        return null;
    }

    public JsonWriterI getWrite(Class clazz) {
        return this.data.get(clazz);
    }

    public void init() {
        this.registerWriter(new JsonWriterI<String>(){

            @Override
            public void writeJSONString(String string, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                jSONStyle.writeString(appendable, string);
            }
        }, String.class);
        this.registerWriter(new JsonWriterI<Double>(){

            @Override
            public void writeJSONString(Double d2, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                if (d2.isInfinite()) {
                    appendable.append("null");
                } else {
                    appendable.append(d2.toString());
                }
            }
        }, Double.class);
        this.registerWriter(new JsonWriterI<Date>(){

            @Override
            public void writeJSONString(Date date, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                appendable.append('\"');
                JSONValue.escape(date.toString(), appendable, jSONStyle);
                appendable.append('\"');
            }
        }, Date.class);
        this.registerWriter(new JsonWriterI<Float>(){

            @Override
            public void writeJSONString(Float f2, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                if (f2.isInfinite()) {
                    appendable.append("null");
                } else {
                    appendable.append(f2.toString());
                }
            }
        }, Float.class);
        this.registerWriter(toStringWriter, Integer.class, Long.class, Byte.class, Short.class, BigInteger.class, BigDecimal.class);
        this.registerWriter(toStringWriter, Boolean.class);
        this.registerWriter(new JsonWriterI<int[]>(){

            @Override
            public void writeJSONString(int[] nArray, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                boolean bl2 = false;
                jSONStyle.arrayStart(appendable);
                for (int n2 : nArray) {
                    if (bl2) {
                        jSONStyle.objectNext(appendable);
                    } else {
                        bl2 = true;
                    }
                    appendable.append(Integer.toString(n2));
                }
                jSONStyle.arrayStop(appendable);
            }
        }, int[].class);
        this.registerWriter(new JsonWriterI<short[]>(){

            @Override
            public void writeJSONString(short[] sArray, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                boolean bl2 = false;
                jSONStyle.arrayStart(appendable);
                for (short s2 : sArray) {
                    if (bl2) {
                        jSONStyle.objectNext(appendable);
                    } else {
                        bl2 = true;
                    }
                    appendable.append(Short.toString(s2));
                }
                jSONStyle.arrayStop(appendable);
            }
        }, short[].class);
        this.registerWriter(new JsonWriterI<long[]>(){

            @Override
            public void writeJSONString(long[] lArray, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                boolean bl2 = false;
                jSONStyle.arrayStart(appendable);
                for (long l2 : lArray) {
                    if (bl2) {
                        jSONStyle.objectNext(appendable);
                    } else {
                        bl2 = true;
                    }
                    appendable.append(Long.toString(l2));
                }
                jSONStyle.arrayStop(appendable);
            }
        }, long[].class);
        this.registerWriter(new JsonWriterI<float[]>(){

            @Override
            public void writeJSONString(float[] fArray, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                boolean bl2 = false;
                jSONStyle.arrayStart(appendable);
                for (float f2 : fArray) {
                    if (bl2) {
                        jSONStyle.objectNext(appendable);
                    } else {
                        bl2 = true;
                    }
                    appendable.append(Float.toString(f2));
                }
                jSONStyle.arrayStop(appendable);
            }
        }, float[].class);
        this.registerWriter(new JsonWriterI<double[]>(){

            @Override
            public void writeJSONString(double[] dArray, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                boolean bl2 = false;
                jSONStyle.arrayStart(appendable);
                for (double d2 : dArray) {
                    if (bl2) {
                        jSONStyle.objectNext(appendable);
                    } else {
                        bl2 = true;
                    }
                    appendable.append(Double.toString(d2));
                }
                jSONStyle.arrayStop(appendable);
            }
        }, double[].class);
        this.registerWriter(new JsonWriterI<boolean[]>(){

            @Override
            public void writeJSONString(boolean[] blArray, Appendable appendable, JSONStyle jSONStyle) throws IOException {
                boolean bl2 = false;
                jSONStyle.arrayStart(appendable);
                for (boolean bl3 : blArray) {
                    if (bl2) {
                        jSONStyle.objectNext(appendable);
                    } else {
                        bl2 = true;
                    }
                    appendable.append(Boolean.toString(bl3));
                }
                jSONStyle.arrayStop(appendable);
            }
        }, boolean[].class);
        this.registerWriterInterface(JSONStreamAwareEx.class, JSONStreamAwareExWriter);
        this.registerWriterInterface(JSONStreamAware.class, JSONStreamAwareWriter);
        this.registerWriterInterface(JSONAwareEx.class, JSONJSONAwareExWriter);
        this.registerWriterInterface(JSONAware.class, JSONJSONAwareWriter);
        this.registerWriterInterface(Map.class, JSONMapWriter);
        this.registerWriterInterface(Iterable.class, JSONIterableWriter);
        this.registerWriterInterface(Enum.class, EnumWriter);
        this.registerWriterInterface(Number.class, toStringWriter);
    }

    public void addInterfaceWriterFirst(Class<?> clazz, JsonWriterI<?> jsonWriterI) {
        this.registerWriterInterfaceFirst(clazz, jsonWriterI);
    }

    public void addInterfaceWriterLast(Class<?> clazz, JsonWriterI<?> jsonWriterI) {
        this.registerWriterInterfaceLast(clazz, jsonWriterI);
    }

    public void registerWriterInterfaceLast(Class<?> clazz, JsonWriterI<?> jsonWriterI) {
        this.writerInterfaces.addLast(new WriterByInterface(clazz, jsonWriterI));
    }

    public void registerWriterInterfaceFirst(Class<?> clazz, JsonWriterI<?> jsonWriterI) {
        this.writerInterfaces.addFirst(new WriterByInterface(clazz, jsonWriterI));
    }

    public void registerWriterInterface(Class<?> clazz, JsonWriterI<?> jsonWriterI) {
        this.registerWriterInterfaceLast(clazz, jsonWriterI);
    }

    public <T> void registerWriter(JsonWriterI<T> jsonWriterI, Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.data.put(clazz, jsonWriterI);
        }
    }

    public static void writeJSONKV(String string, Object object, Appendable appendable, JSONStyle jSONStyle) throws IOException {
        if (string == null) {
            appendable.append("null");
        } else if (!jSONStyle.mustProtectKey(string)) {
            appendable.append(string);
        } else {
            appendable.append('\"');
            JSONValue.escape(string, appendable, jSONStyle);
            appendable.append('\"');
        }
        jSONStyle.objectEndOfKey(appendable);
        if (object instanceof String) {
            jSONStyle.writeString(appendable, (String)object);
        } else {
            JSONValue.writeJSONString(object, appendable, jSONStyle);
        }
        jSONStyle.objectElmStop(appendable);
    }

    static class WriterByInterface {
        public Class<?> _interface;
        public JsonWriterI<?> _writer;

        public WriterByInterface(Class<?> clazz, JsonWriterI<?> jsonWriterI) {
            this._interface = clazz;
            this._writer = jsonWriterI;
        }
    }
}

