/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CipherHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CompositeKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.HMAC;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.LegacyConcatKDF;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.utils.ConstantTimeUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESCBC {
    public static final int IV_BIT_LENGTH = 128;

    public static byte[] generateIV(SecureRandom secureRandom) {
        byte[] byArray = new byte[ByteUtils.byteLength(128)];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    private static Cipher createAESCBCCipher(SecretKey secretKey, boolean bl2, byte[] byArray, Provider provider) throws JOSEException {
        Cipher cipher;
        try {
            cipher = CipherHelper.getInstance("AES/CBC/PKCS5Padding", provider);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            if (bl2) {
                cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            } else {
                cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            }
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
        return cipher;
    }

    public static byte[] encrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2, Provider provider) throws JOSEException {
        Cipher cipher = AESCBC.createAESCBCCipher(secretKey, true, byArray, provider);
        try {
            return cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
    }

    public static AuthenticatedCipherText encryptAuthenticated(SecretKey secretKey, byte[] byArray, byte[] byArray2, byte[] byArray3, Provider provider, Provider provider2) throws JOSEException {
        CompositeKey compositeKey = new CompositeKey(secretKey);
        byte[] byArray4 = AESCBC.encrypt(compositeKey.getAESKey(), byArray, byArray2, provider);
        byte[] byArray5 = AAD.computeLength(byArray3);
        int n2 = byArray3.length + byArray.length + byArray4.length + byArray5.length;
        byte[] byArray6 = ByteBuffer.allocate(n2).put(byArray3).put(byArray).put(byArray4).put(byArray5).array();
        byte[] byArray7 = HMAC.compute(compositeKey.getMACKey(), byArray6, provider2);
        byte[] byArray8 = Arrays.copyOf(byArray7, compositeKey.getTruncatedMACByteLength());
        return new AuthenticatedCipherText(byArray4, byArray8);
    }

    public static AuthenticatedCipherText encryptWithConcatKDF(JWEHeader jWEHeader, SecretKey secretKey, Base64URL base64URL, byte[] byArray, byte[] byArray2, Provider provider, Provider provider2) throws JOSEException {
        byte[] byArray3 = null;
        if (jWEHeader.getCustomParam("epu") instanceof String) {
            byArray3 = new Base64URL((String)jWEHeader.getCustomParam("epu")).decode();
        }
        byte[] byArray4 = null;
        if (jWEHeader.getCustomParam("epv") instanceof String) {
            byArray4 = new Base64URL((String)jWEHeader.getCustomParam("epv")).decode();
        }
        SecretKey secretKey2 = LegacyConcatKDF.generateCEK(secretKey, jWEHeader.getEncryptionMethod(), byArray3, byArray4);
        byte[] byArray5 = AESCBC.encrypt(secretKey2, byArray, byArray2, provider);
        SecretKey secretKey3 = LegacyConcatKDF.generateCIK(secretKey, jWEHeader.getEncryptionMethod(), byArray3, byArray4);
        String string = jWEHeader.toBase64URL() + "." + base64URL + "." + Base64URL.encode(byArray) + "." + Base64URL.encode(byArray5);
        byte[] byArray6 = HMAC.compute(secretKey3, string.getBytes(StandardCharset.UTF_8), provider2);
        return new AuthenticatedCipherText(byArray5, byArray6);
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2, Provider provider) throws JOSEException {
        Cipher cipher = AESCBC.createAESCBCCipher(secretKey, false, byArray, provider);
        try {
            return cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
    }

    public static byte[] decryptAuthenticated(SecretKey secretKey, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, Provider provider, Provider provider2) throws JOSEException {
        CompositeKey compositeKey = new CompositeKey(secretKey);
        byte[] byArray5 = AAD.computeLength(byArray3);
        int n2 = byArray3.length + byArray.length + byArray2.length + byArray5.length;
        byte[] byArray6 = ByteBuffer.allocate(n2).put(byArray3).put(byArray).put(byArray2).put(byArray5).array();
        byte[] byArray7 = HMAC.compute(compositeKey.getMACKey(), byArray6, provider2);
        byte[] byArray8 = Arrays.copyOf(byArray7, compositeKey.getTruncatedMACByteLength());
        if (!ConstantTimeUtils.areEqual(byArray8, byArray4)) {
            throw new JOSEException("MAC check failed");
        }
        return AESCBC.decrypt(compositeKey.getAESKey(), byArray, byArray2, provider);
    }

    public static byte[] decryptWithConcatKDF(JWEHeader jWEHeader, SecretKey secretKey, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Provider provider, Provider provider2) throws JOSEException {
        byte[] byArray = null;
        if (jWEHeader.getCustomParam("epu") instanceof String) {
            byArray = new Base64URL((String)jWEHeader.getCustomParam("epu")).decode();
        }
        byte[] byArray2 = null;
        if (jWEHeader.getCustomParam("epv") instanceof String) {
            byArray2 = new Base64URL((String)jWEHeader.getCustomParam("epv")).decode();
        }
        SecretKey secretKey2 = LegacyConcatKDF.generateCIK(secretKey, jWEHeader.getEncryptionMethod(), byArray, byArray2);
        String string = jWEHeader.toBase64URL().toString() + "." + base64URL.toString() + "." + base64URL2.toString() + "." + base64URL3.toString();
        byte[] byArray3 = HMAC.compute(secretKey2, string.getBytes(StandardCharset.UTF_8), provider2);
        if (!ConstantTimeUtils.areEqual(base64URL4.decode(), byArray3)) {
            throw new JOSEException("MAC check failed");
        }
        SecretKey secretKey3 = LegacyConcatKDF.generateCEK(secretKey, jWEHeader.getEncryptionMethod(), byArray, byArray2);
        return AESCBC.decrypt(secretKey3, base64URL2.decode(), base64URL3.decode(), provider);
    }

    private AESCBC() {
    }
}

