/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.ECDSASigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.Ed25519Signer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.MACSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.RSASSASigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.BaseJWSProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jca.JCAContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetKeyPair;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetSequenceKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.RSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.produce.JWSSignerFactory;

public class DefaultJWSSignerFactory
implements JWSSignerFactory {
    private final JCAContext jcaContext = new JCAContext();
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;

    @Override
    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    @Override
    public JCAContext getJCAContext() {
        return this.jcaContext;
    }

    @Override
    public JWSSigner createJWSSigner(JWK jWK) throws JOSEException {
        BaseJWSProvider baseJWSProvider;
        if (!jWK.isPrivate()) {
            throw JWKException.expectedPrivate();
        }
        if (jWK.getKeyUse() != null && !KeyUse.SIGNATURE.equals(jWK.getKeyUse())) {
            throw new JWKException("The JWK use must be sig (signature) or unspecified");
        }
        if (jWK instanceof OctetSequenceKey) {
            baseJWSProvider = new MACSigner((OctetSequenceKey)jWK);
        } else if (jWK instanceof RSAKey) {
            baseJWSProvider = new RSASSASigner((RSAKey)jWK);
        } else if (jWK instanceof ECKey) {
            baseJWSProvider = new ECDSASigner((ECKey)jWK);
        } else if (jWK instanceof OctetKeyPair) {
            baseJWSProvider = new Ed25519Signer((OctetKeyPair)jWK);
        } else {
            throw new JOSEException("Unsupported JWK type: " + jWK);
        }
        ((JCAContext)baseJWSProvider.getJCAContext()).setSecureRandom(this.jcaContext.getSecureRandom());
        ((JCAContext)baseJWSProvider.getJCAContext()).setProvider(this.jcaContext.getProvider());
        return baseJWSProvider;
    }

    @Override
    public JWSSigner createJWSSigner(JWK jWK, JWSAlgorithm jWSAlgorithm) throws JOSEException {
        BaseJWSProvider baseJWSProvider;
        if (!jWK.isPrivate()) {
            throw JWKException.expectedPrivate();
        }
        if (jWK.getKeyUse() != null && !KeyUse.SIGNATURE.equals(jWK.getKeyUse())) {
            throw new JWKException("The JWK use must be sig (signature) or unspecified");
        }
        if (MACSigner.SUPPORTED_ALGORITHMS.contains(jWSAlgorithm)) {
            if (!(jWK instanceof OctetSequenceKey)) {
                throw JWKException.expectedClass(OctetSequenceKey.class);
            }
            baseJWSProvider = new MACSigner((OctetSequenceKey)jWK);
        } else if (RSASSASigner.SUPPORTED_ALGORITHMS.contains(jWSAlgorithm)) {
            if (!(jWK instanceof RSAKey)) {
                throw JWKException.expectedClass(RSAKey.class);
            }
            baseJWSProvider = new RSASSASigner((RSAKey)jWK);
        } else if (ECDSASigner.SUPPORTED_ALGORITHMS.contains(jWSAlgorithm)) {
            if (!(jWK instanceof ECKey)) {
                throw JWKException.expectedClass(ECKey.class);
            }
            baseJWSProvider = new ECDSASigner((ECKey)jWK);
        } else if (Ed25519Signer.SUPPORTED_ALGORITHMS.contains(jWSAlgorithm)) {
            if (!(jWK instanceof OctetKeyPair)) {
                throw JWKException.expectedClass(OctetKeyPair.class);
            }
            baseJWSProvider = new Ed25519Signer((OctetKeyPair)jWK);
        } else {
            throw new JOSEException("Unsupported JWS algorithm: " + jWSAlgorithm);
        }
        ((JCAContext)baseJWSProvider.getJCAContext()).setSecureRandom(this.jcaContext.getSecureRandom());
        ((JCAContext)baseJWSProvider.getJCAContext()).setProvider(this.jcaContext.getProvider());
        return baseJWSProvider;
    }

    static {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(MACSigner.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(RSASSASigner.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(ECDSASigner.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(Ed25519Signer.SUPPORTED_ALGORITHMS);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(linkedHashSet);
    }
}

