/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESKW;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PBKDF2;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PRFParams;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PasswordBasedCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PasswordBasedEncrypter
extends PasswordBasedCryptoProvider
implements JWEEncrypter {
    public static final int MIN_SALT_LENGTH = 8;
    private final int saltLength;
    public static final int MIN_RECOMMENDED_ITERATION_COUNT = 1000;
    private final int iterationCount;

    public PasswordBasedEncrypter(byte[] byArray, int n2, int n3) {
        super(byArray);
        if (n2 < 8) {
            throw new IllegalArgumentException("The minimum salt length (p2s) is 8 bytes");
        }
        this.saltLength = n2;
        if (n3 < 1000) {
            throw new IllegalArgumentException("The minimum recommended iteration count (p2c) is 1000");
        }
        this.iterationCount = n3;
    }

    public PasswordBasedEncrypter(String string, int n2, int n3) {
        this(string.getBytes(StandardCharset.UTF_8), n2, n3);
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        byte[] byArray2 = new byte[this.saltLength];
        this.getJCAContext().getSecureRandom().nextBytes(byArray2);
        byte[] byArray3 = PBKDF2.formatSalt(jWEAlgorithm, byArray2);
        PRFParams pRFParams = PRFParams.resolve(jWEAlgorithm, this.getJCAContext().getMACProvider());
        SecretKey secretKey = PBKDF2.deriveKey(this.getPassword(), byArray3, this.iterationCount, pRFParams);
        JWEHeader jWEHeader2 = new JWEHeader.Builder(jWEHeader).pbes2Salt(Base64URL.encode(byArray2)).pbes2Count(this.iterationCount).build();
        SecretKey secretKey2 = ContentCryptoProvider.generateCEK(encryptionMethod, this.getJCAContext().getSecureRandom());
        Base64URL base64URL = Base64URL.encode(AESKW.wrapCEK(secretKey2, secretKey, this.getJCAContext().getKeyEncryptionProvider()));
        return ContentCryptoProvider.encrypt(jWEHeader2, byArray, secretKey2, base64URL, this.getJCAContext());
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }
}

