/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CriticalHeaderParamsAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESKW;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PBKDF2;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PRFParams;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PasswordBasedCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PasswordBasedDecrypter
extends PasswordBasedCryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public PasswordBasedDecrypter(byte[] byArray) {
        super(byArray);
    }

    public PasswordBasedDecrypter(String string) {
        super(string.getBytes(StandardCharset.UTF_8));
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        if (base64URL == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (base64URL2 == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (base64URL4 == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        if (jWEHeader.getPBES2Salt() == null) {
            throw new JOSEException("Missing JWE p2s header parameter");
        }
        byte[] byArray = jWEHeader.getPBES2Salt().decode();
        if (jWEHeader.getPBES2Count() < 1) {
            throw new JOSEException("Missing JWE p2c header parameter");
        }
        int n2 = jWEHeader.getPBES2Count();
        this.critPolicy.ensureHeaderPasses(jWEHeader);
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        byte[] byArray2 = PBKDF2.formatSalt(jWEAlgorithm, byArray);
        PRFParams pRFParams = PRFParams.resolve(jWEAlgorithm, this.getJCAContext().getMACProvider());
        SecretKey secretKey = PBKDF2.deriveKey(this.getPassword(), byArray2, n2, pRFParams);
        SecretKey secretKey2 = AESKW.unwrapCEK(secretKey, base64URL.decode(), this.getJCAContext().getKeyEncryptionProvider());
        return ContentCryptoProvider.decrypt(jWEHeader, base64URL, base64URL2, base64URL3, base64URL4, secretKey2, this.getJCAContext());
    }
}

