/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.net.URI;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CommonSEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Header;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.X509CertChainUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class JWSHeader
extends CommonSEHeader {
    private static final long serialVersionUID = 1L;
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final boolean b64;

    public JWSHeader(JWSAlgorithm jWSAlgorithm) {
        this(jWSAlgorithm, null, null, null, null, null, null, null, null, null, null, true, null, null);
    }

    @Deprecated
    public JWSHeader(JWSAlgorithm jWSAlgorithm, JOSEObjectType jOSEObjectType, String string, Set<String> set, URI uRI, JWK jWK, URI uRI2, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, String string2, Map<String, Object> map, Base64URL base64URL3) {
        this(jWSAlgorithm, jOSEObjectType, string, set, uRI, jWK, uRI2, base64URL, base64URL2, list, string2, true, map, base64URL3);
    }

    public JWSHeader(JWSAlgorithm jWSAlgorithm, JOSEObjectType jOSEObjectType, String string, Set<String> set, URI uRI, JWK jWK, URI uRI2, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, String string2, boolean bl2, Map<String, Object> map, Base64URL base64URL3) {
        super(jWSAlgorithm, jOSEObjectType, string, set, uRI, jWK, uRI2, base64URL, base64URL2, list, string2, map, base64URL3);
        if (jWSAlgorithm.getName().equals(Algorithm.NONE.getName())) {
            throw new IllegalArgumentException("The JWS algorithm \"alg\" cannot be \"none\"");
        }
        this.b64 = bl2;
    }

    public JWSHeader(JWSHeader jWSHeader) {
        this(jWSHeader.getAlgorithm(), jWSHeader.getType(), jWSHeader.getContentType(), jWSHeader.getCriticalParams(), jWSHeader.getJWKURL(), jWSHeader.getJWK(), jWSHeader.getX509CertURL(), jWSHeader.getX509CertThumbprint(), jWSHeader.getX509CertSHA256Thumbprint(), jWSHeader.getX509CertChain(), jWSHeader.getKeyID(), jWSHeader.isBase64URLEncodePayload(), jWSHeader.getCustomParams(), jWSHeader.getParsedBase64URL());
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    @Override
    public JWSAlgorithm getAlgorithm() {
        return (JWSAlgorithm)super.getAlgorithm();
    }

    public boolean isBase64URLEncodePayload() {
        return this.b64;
    }

    @Override
    public Set<String> getIncludedParams() {
        Set<String> set = super.getIncludedParams();
        if (!this.isBase64URLEncodePayload()) {
            set.add("b64");
        }
        return set;
    }

    @Override
    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = super.toJSONObject();
        if (!this.isBase64URLEncodePayload()) {
            map.put("b64", false);
        }
        return map;
    }

    public static JWSHeader parse(Map<String, Object> map) throws ParseException {
        return JWSHeader.parse(map, null);
    }

    public static JWSHeader parse(Map<String, Object> map, Base64URL base64URL) throws ParseException {
        Algorithm algorithm = Header.parseAlgorithm(map);
        if (!(algorithm instanceof JWSAlgorithm)) {
            throw new ParseException("Not a JWS header", 0);
        }
        Builder builder = new Builder((JWSAlgorithm)algorithm).parsedBase64URL(base64URL);
        for (String string : map.keySet()) {
            List<String> list;
            if ("alg".equals(string)) continue;
            if ("typ".equals(string)) {
                list = JSONObjectUtils.getString(map, string);
                if (list == null) continue;
                builder = builder.type(new JOSEObjectType((String)((Object)list)));
                continue;
            }
            if ("cty".equals(string)) {
                builder = builder.contentType(JSONObjectUtils.getString(map, string));
                continue;
            }
            if ("crit".equals(string)) {
                list = JSONObjectUtils.getStringList(map, string);
                if (list == null) continue;
                builder = builder.criticalParams(new HashSet<String>(list));
                continue;
            }
            if ("jku".equals(string)) {
                builder = builder.jwkURL(JSONObjectUtils.getURI(map, string));
                continue;
            }
            if ("jwk".equals(string)) {
                builder = builder.jwk(CommonSEHeader.parsePublicJWK(JSONObjectUtils.getJSONObject(map, string)));
                continue;
            }
            if ("x5u".equals(string)) {
                builder = builder.x509CertURL(JSONObjectUtils.getURI(map, string));
                continue;
            }
            if ("x5t".equals(string)) {
                builder = builder.x509CertThumbprint(Base64URL.from(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("x5t#S256".equals(string)) {
                builder = builder.x509CertSHA256Thumbprint(Base64URL.from(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("x5c".equals(string)) {
                builder = builder.x509CertChain(X509CertChainUtils.toBase64List(JSONObjectUtils.getJSONArray(map, string)));
                continue;
            }
            if ("kid".equals(string)) {
                builder = builder.keyID(JSONObjectUtils.getString(map, string));
                continue;
            }
            if ("b64".equals(string)) {
                builder = builder.base64URLEncodePayload(JSONObjectUtils.getBoolean(map, string));
                continue;
            }
            builder = builder.customParam(string, map.get(string));
        }
        return builder.build();
    }

    public static JWSHeader parse(String string) throws ParseException {
        return JWSHeader.parse(string, null);
    }

    public static JWSHeader parse(String string, Base64URL base64URL) throws ParseException {
        return JWSHeader.parse(JSONObjectUtils.parse(string, 20000), base64URL);
    }

    public static JWSHeader parse(Base64URL base64URL) throws ParseException {
        return JWSHeader.parse(base64URL.decodeToString(), base64URL);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("alg");
        hashSet.add("jku");
        hashSet.add("jwk");
        hashSet.add("x5u");
        hashSet.add("x5t");
        hashSet.add("x5t#S256");
        hashSet.add("x5c");
        hashSet.add("kid");
        hashSet.add("typ");
        hashSet.add("cty");
        hashSet.add("crit");
        hashSet.add("b64");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public static class Builder {
        private final JWSAlgorithm alg;
        private JOSEObjectType typ;
        private String cty;
        private Set<String> crit;
        private URI jku;
        private JWK jwk;
        private URI x5u;
        @Deprecated
        private Base64URL x5t;
        private Base64URL x5t256;
        private List<Base64> x5c;
        private String kid;
        private boolean b64 = true;
        private Map<String, Object> customParams;
        private Base64URL parsedBase64URL;

        public Builder(JWSAlgorithm jWSAlgorithm) {
            if (jWSAlgorithm.getName().equals(Algorithm.NONE.getName())) {
                throw new IllegalArgumentException("The JWS algorithm \"alg\" cannot be \"none\"");
            }
            this.alg = jWSAlgorithm;
        }

        public Builder(JWSHeader jWSHeader) {
            this(jWSHeader.getAlgorithm());
            this.typ = jWSHeader.getType();
            this.cty = jWSHeader.getContentType();
            this.crit = jWSHeader.getCriticalParams();
            this.jku = jWSHeader.getJWKURL();
            this.jwk = jWSHeader.getJWK();
            this.x5u = jWSHeader.getX509CertURL();
            this.x5t = jWSHeader.getX509CertThumbprint();
            this.x5t256 = jWSHeader.getX509CertSHA256Thumbprint();
            this.x5c = jWSHeader.getX509CertChain();
            this.kid = jWSHeader.getKeyID();
            this.b64 = jWSHeader.isBase64URLEncodePayload();
            this.customParams = jWSHeader.getCustomParams();
        }

        public Builder type(JOSEObjectType jOSEObjectType) {
            this.typ = jOSEObjectType;
            return this;
        }

        public Builder contentType(String string) {
            this.cty = string;
            return this;
        }

        public Builder criticalParams(Set<String> set) {
            this.crit = set;
            return this;
        }

        public Builder jwkURL(URI uRI) {
            this.jku = uRI;
            return this;
        }

        public Builder jwk(JWK jWK) {
            if (jWK != null && jWK.isPrivate()) {
                throw new IllegalArgumentException("The JWK must be public");
            }
            this.jwk = jWK;
            return this;
        }

        public Builder x509CertURL(URI uRI) {
            this.x5u = uRI;
            return this;
        }

        @Deprecated
        public Builder x509CertThumbprint(Base64URL base64URL) {
            this.x5t = base64URL;
            return this;
        }

        public Builder x509CertSHA256Thumbprint(Base64URL base64URL) {
            this.x5t256 = base64URL;
            return this;
        }

        public Builder x509CertChain(List<Base64> list) {
            this.x5c = list;
            return this;
        }

        public Builder keyID(String string) {
            this.kid = string;
            return this;
        }

        public Builder base64URLEncodePayload(boolean bl2) {
            this.b64 = bl2;
            return this;
        }

        public Builder customParam(String string, Object object) {
            if (JWSHeader.getRegisteredParameterNames().contains(string)) {
                throw new IllegalArgumentException("The parameter name \"" + string + "\" matches a registered name");
            }
            if (this.customParams == null) {
                this.customParams = new HashMap<String, Object>();
            }
            this.customParams.put(string, object);
            return this;
        }

        public Builder customParams(Map<String, Object> map) {
            this.customParams = map;
            return this;
        }

        public Builder parsedBase64URL(Base64URL base64URL) {
            this.parsedBase64URL = base64URL;
            return this;
        }

        public JWSHeader build() {
            return new JWSHeader(this.alg, this.typ, this.cty, this.crit, this.jku, this.jwk, this.x5u, this.x5t, this.x5t256, this.x5c, this.kid, this.b64, this.customParams, this.parsedBase64URL);
        }
    }
}

