/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ThrottlingCache {
    static final int MAX_THROTTLING_TIME_SEC = 3600;
    static int DEFAULT_THROTTLING_TIME_SEC = 120;
    static final int CACHE_SIZE_LIMIT_TO_TRIGGER_EXPIRED_ENTITIES_REMOVAL = 100;
    static Map<String, Long> requestsToThrottle = new ConcurrentHashMap<String, Long>();

    ThrottlingCache() {
    }

    static void set(String string, Long l2) {
        ThrottlingCache.removeInvalidCacheEntities();
        requestsToThrottle.put(string, l2);
    }

    static long retryInMs(String string) {
        ThrottlingCache.removeInvalidCacheEntities();
        if (requestsToThrottle.containsKey(string)) {
            long l2 = requestsToThrottle.get(string);
            long l3 = System.currentTimeMillis();
            if (ThrottlingCache.isCacheEntryValid(l3, l2)) {
                return l2 - l3;
            }
            requestsToThrottle.remove(string);
        }
        return 0L;
    }

    private static boolean isCacheEntryValid(long l2, long l3) {
        return l2 < l3 && l2 >= l3 - 3600000L;
    }

    private static void removeInvalidCacheEntities() {
        long l2 = System.currentTimeMillis();
        if (requestsToThrottle.size() > 100) {
            requestsToThrottle.values().removeIf(l3 -> !ThrottlingCache.isCacheEntryValid(l3, l2));
        }
    }

    static void clear() {
        requestsToThrottle.clear();
    }
}

