/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.NonNull;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCode;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;

public class DeviceCodeFlowParameters
implements IAcquireTokenParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private Consumer<DeviceCode> deviceCodeConsumer;
    private ClaimsRequest claims;
    private Map<String, String> extraHttpHeaders;
    private String tenant;

    private static DeviceCodeFlowParametersBuilder builder() {
        return new DeviceCodeFlowParametersBuilder();
    }

    public static DeviceCodeFlowParametersBuilder builder(Set<String> set, Consumer<DeviceCode> consumer) {
        ParameterValidationUtils.validateNotNull("scopes", set);
        return DeviceCodeFlowParameters.builder().scopes(set).deviceCodeConsumer(consumer);
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    public Consumer<DeviceCode> deviceCodeConsumer() {
        return this.deviceCodeConsumer;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    @Override
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    private DeviceCodeFlowParameters(@NonNull Set<String> set, @NonNull Consumer<DeviceCode> consumer, ClaimsRequest claimsRequest, Map<String, String> map, String string) {
        if (set == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("deviceCodeConsumer is marked @NonNull but is null");
        }
        this.scopes = set;
        this.deviceCodeConsumer = consumer;
        this.claims = claimsRequest;
        this.extraHttpHeaders = map;
        this.tenant = string;
    }

    public static class DeviceCodeFlowParametersBuilder {
        private Set<String> scopes;
        private Consumer<DeviceCode> deviceCodeConsumer;
        private ClaimsRequest claims;
        private Map<String, String> extraHttpHeaders;
        private String tenant;

        DeviceCodeFlowParametersBuilder() {
        }

        public DeviceCodeFlowParametersBuilder scopes(Set<String> set) {
            this.scopes = set;
            return this;
        }

        public DeviceCodeFlowParametersBuilder deviceCodeConsumer(Consumer<DeviceCode> consumer) {
            this.deviceCodeConsumer = consumer;
            return this;
        }

        public DeviceCodeFlowParametersBuilder claims(ClaimsRequest claimsRequest) {
            this.claims = claimsRequest;
            return this;
        }

        public DeviceCodeFlowParametersBuilder extraHttpHeaders(Map<String, String> map) {
            this.extraHttpHeaders = map;
            return this;
        }

        public DeviceCodeFlowParametersBuilder tenant(String string) {
            this.tenant = string;
            return this;
        }

        public DeviceCodeFlowParameters build() {
            return new DeviceCodeFlowParameters(this.scopes, this.deviceCodeConsumer, this.claims, this.extraHttpHeaders, this.tenant);
        }

        public String toString() {
            return "DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder(scopes=" + this.scopes + ", deviceCodeConsumer=" + this.deviceCodeConsumer + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", tenant=" + this.tenant + ")";
        }
    }
}

