/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientAssertion;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCertificate;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientSecret;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.CustomJWTAuthentication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientCredential;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JwtHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OnBehalfOfParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OnBehalfOfRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

public class ConfidentialClientApplication
extends AbstractClientApplicationBase
implements IConfidentialClientApplication {
    private ClientAuthentication clientAuthentication;
    private CustomJWTAuthentication customJWTAuthentication;
    private boolean clientCertAuthentication = false;
    private ClientCertificate clientCertificate;
    private boolean sendX5c;

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(ClientCredentialParameters clientCredentialParameters) {
        ParameterValidationUtils.validateNotNull("parameters", clientCredentialParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_FOR_CLIENT, clientCredentialParameters);
        ClientCredentialRequest clientCredentialRequest = new ClientCredentialRequest(clientCredentialParameters, this, requestContext);
        return this.executeRequest(clientCredentialRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(OnBehalfOfParameters onBehalfOfParameters) {
        ParameterValidationUtils.validateNotNull("parameters", onBehalfOfParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_ON_BEHALF_OF, onBehalfOfParameters);
        OnBehalfOfRequest onBehalfOfRequest = new OnBehalfOfRequest(onBehalfOfParameters, this, requestContext);
        return this.executeRequest(onBehalfOfRequest);
    }

    private ConfidentialClientApplication(Builder builder) {
        super(builder);
        this.sendX5c = builder.sendX5c;
        this.log = LoggerFactory.getLogger(ConfidentialClientApplication.class);
        this.initClientAuthentication(builder.clientCredential);
    }

    private void initClientAuthentication(IClientCredential iClientCredential) {
        ParameterValidationUtils.validateNotNull("clientCredential", iClientCredential);
        if (iClientCredential instanceof ClientSecret) {
            this.clientAuthentication = new ClientSecretPost(new ClientID(this.clientId()), new Secret(((ClientSecret)iClientCredential).clientSecret()));
        } else if (iClientCredential instanceof ClientCertificate) {
            this.clientCertAuthentication = true;
            this.clientCertificate = (ClientCertificate)iClientCredential;
            this.clientAuthentication = this.buildValidClientCertificateAuthority();
        } else if (iClientCredential instanceof ClientAssertion) {
            this.clientAuthentication = this.createClientAuthFromClientAssertion((ClientAssertion)iClientCredential);
        } else {
            throw new IllegalArgumentException("Unsupported client credential");
        }
    }

    @Override
    protected ClientAuthentication clientAuthentication() {
        if (this.clientCertAuthentication) {
            Date date = new Date(System.currentTimeMillis());
            Date date2 = ((PrivateKeyJWT)this.clientAuthentication).getJWTAuthenticationClaimsSet().getExpirationTime();
            if (date2.before(date)) {
                this.clientAuthentication = this.buildValidClientCertificateAuthority();
            }
        }
        return this.clientAuthentication;
    }

    private ClientAuthentication buildValidClientCertificateAuthority() {
        ClientAssertion clientAssertion = JwtHelper.buildJwt(this.clientId(), this.clientCertificate, this.authenticationAuthority.selfSignedJwtAudience(), this.sendX5c);
        return this.createClientAuthFromClientAssertion(clientAssertion);
    }

    protected ClientAuthentication createClientAuthFromClientAssertion(ClientAssertion clientAssertion) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        try {
            hashMap.put("client_assertion_type", Collections.singletonList("urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            hashMap.put("client_assertion", Collections.singletonList(clientAssertion.assertion()));
            return PrivateKeyJWT.parse(hashMap);
        }
        catch (ParseException parseException) {
            if (parseException.getMessage().contains("Issuer and subject in client JWT assertion must designate the same client identifier")) {
                return new CustomJWTAuthentication(ClientAuthenticationMethod.PRIVATE_KEY_JWT, clientAssertion, new ClientID(this.clientId()));
            }
            throw new MsalClientException(parseException);
        }
    }

    public static Builder builder(String string, IClientCredential iClientCredential) {
        return new Builder(string, iClientCredential);
    }

    @Override
    public boolean sendX5c() {
        return this.sendX5c;
    }

    public static class Builder
    extends AbstractClientApplicationBase.Builder<Builder> {
        private IClientCredential clientCredential;
        private boolean sendX5c = true;

        private Builder(String string, IClientCredential iClientCredential) {
            super(string);
            this.clientCredential = iClientCredential;
        }

        public Builder sendX5c(boolean bl2) {
            this.sendX5c = bl2;
            return this.self();
        }

        @Override
        public ConfidentialClientApplication build() {
            return new ConfidentialClientApplication(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

