/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientCredential;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;

public class ClientCredentialParameters
implements IAcquireTokenParameters {
    @NonNull
    private Set<String> scopes;
    private Boolean skipCache;
    private ClaimsRequest claims;
    private Map<String, String> extraHttpHeaders;
    private String tenant;
    private IClientCredential clientCredential;

    private static ClientCredentialParametersBuilder builder() {
        return new ClientCredentialParametersBuilder();
    }

    public static ClientCredentialParametersBuilder builder(Set<String> set) {
        ParameterValidationUtils.validateNotNull("scopes", set);
        return ClientCredentialParameters.builder().scopes(set);
    }

    private static Boolean $default$skipCache() {
        return false;
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    public Boolean skipCache() {
        return this.skipCache;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    @Override
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    public IClientCredential clientCredential() {
        return this.clientCredential;
    }

    private ClientCredentialParameters(@NonNull Set<String> set, Boolean bl2, ClaimsRequest claimsRequest, Map<String, String> map, String string, IClientCredential iClientCredential) {
        if (set == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        this.scopes = set;
        this.skipCache = bl2;
        this.claims = claimsRequest;
        this.extraHttpHeaders = map;
        this.tenant = string;
        this.clientCredential = iClientCredential;
    }

    public static class ClientCredentialParametersBuilder {
        private Set<String> scopes;
        private boolean skipCache$set;
        private Boolean skipCache;
        private ClaimsRequest claims;
        private Map<String, String> extraHttpHeaders;
        private String tenant;
        private IClientCredential clientCredential;

        ClientCredentialParametersBuilder() {
        }

        public ClientCredentialParametersBuilder scopes(Set<String> set) {
            this.scopes = set;
            return this;
        }

        public ClientCredentialParametersBuilder skipCache(Boolean bl2) {
            this.skipCache = bl2;
            this.skipCache$set = true;
            return this;
        }

        public ClientCredentialParametersBuilder claims(ClaimsRequest claimsRequest) {
            this.claims = claimsRequest;
            return this;
        }

        public ClientCredentialParametersBuilder extraHttpHeaders(Map<String, String> map) {
            this.extraHttpHeaders = map;
            return this;
        }

        public ClientCredentialParametersBuilder tenant(String string) {
            this.tenant = string;
            return this;
        }

        public ClientCredentialParametersBuilder clientCredential(IClientCredential iClientCredential) {
            this.clientCredential = iClientCredential;
            return this;
        }

        public ClientCredentialParameters build() {
            Boolean bl2 = this.skipCache;
            if (!this.skipCache$set) {
                bl2 = ClientCredentialParameters.$default$skipCache();
            }
            return new ClientCredentialParameters(this.scopes, bl2, this.claims, this.extraHttpHeaders, this.tenant, this.clientCredential);
        }

        public String toString() {
            return "ClientCredentialParameters.ClientCredentialParametersBuilder(scopes=" + this.scopes + ", skipCache=" + this.skipCache + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", tenant=" + this.tenant + ", clientCredential=" + this.clientCredential + ")";
        }
    }
}

