/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientCertificate;

final class ClientCertificate
implements IClientCertificate {
    private static final int MIN_KEY_SIZE_IN_BITS = 2048;
    public static final String DEFAULT_PKCS12_PASSWORD = "";
    private final PrivateKey privateKey;
    private final List<X509Certificate> publicKeyCertificateChain;

    ClientCertificate(PrivateKey privateKey, List<X509Certificate> list) {
        block8: {
            if (privateKey == null) {
                throw new NullPointerException("PrivateKey is null or empty");
            }
            this.privateKey = privateKey;
            if (privateKey instanceof RSAPrivateKey) {
                if (((RSAPrivateKey)privateKey).getModulus().bitLength() < 2048) {
                    throw new IllegalArgumentException("certificate key size must be at least 2048");
                }
            } else {
                if ("sun.security.mscapi.RSAPrivateKey".equals(privateKey.getClass().getName()) || "sun.security.mscapi.CPrivateKey".equals(privateKey.getClass().getName())) {
                    try {
                        Method method = privateKey.getClass().getMethod("length", new Class[0]);
                        method.setAccessible(true);
                        if ((Integer)method.invoke((Object)privateKey, new Object[0]) < 2048) {
                            throw new IllegalArgumentException("certificate key size must be at least 2048");
                        }
                        break block8;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        throw new RuntimeException("error accessing sun.security.mscapi.RSAPrivateKey length: " + reflectiveOperationException.getMessage());
                    }
                }
                throw new IllegalArgumentException("certificate key must be an instance of java.security.interfaces.RSAPrivateKey or sun.security.mscapi.RSAPrivateKey");
            }
        }
        this.publicKeyCertificateChain = list;
    }

    @Override
    public String publicCertificateHash() throws CertificateEncodingException, NoSuchAlgorithmException {
        return Base64.getEncoder().encodeToString(ClientCertificate.getHash(this.publicKeyCertificateChain.get(0).getEncoded()));
    }

    @Override
    public List<String> getEncodedPublicKeyCertificateChain() throws CertificateEncodingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (X509Certificate x509Certificate : this.publicKeyCertificateChain) {
            arrayList.add(Base64.getEncoder().encodeToString(x509Certificate.getEncoded()));
        }
        return arrayList;
    }

    static ClientCertificate create(InputStream inputStream, String string) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        if (string == null) {
            string = DEFAULT_PKCS12_PASSWORD;
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(inputStream, string.toCharArray());
        Enumeration<String> enumeration = keyStore.aliases();
        if (!enumeration.hasMoreElements()) {
            throw new IllegalArgumentException("certificate not loaded from input stream");
        }
        String string2 = enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            throw new IllegalArgumentException("more than one certificate alias found in input stream");
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string2, string.toCharArray());
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
        Certificate[] certificateArray = keyStore.getCertificateChain(string2);
        if (certificateArray != null && certificateArray.length > 0) {
            for (Certificate certificate : certificateArray) {
                arrayList.add((X509Certificate)certificate);
            }
        } else {
            arrayList.add(x509Certificate);
        }
        return new ClientCertificate(privateKey, arrayList);
    }

    static ClientCertificate create(PrivateKey privateKey, X509Certificate x509Certificate) {
        return new ClientCertificate(privateKey, Arrays.asList(x509Certificate));
    }

    private static byte[] getHash(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    @Override
    public PrivateKey privateKey() {
        return this.privateKey;
    }
}

