/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URL;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;

class B2CAuthority
extends Authority {
    private static final String AUTHORIZATION_ENDPOINT = "/oauth2/v2.0/authorize";
    private static final String TOKEN_ENDPOINT = "/oauth2/v2.0/token";
    private static final String B2C_AUTHORIZATION_ENDPOINT_FORMAT = "https://%s/%s/%s/oauth2/v2.0/authorize";
    private static final String B2C_TOKEN_ENDPOINT_FORMAT = "https://%s/%s/oauth2/v2.0/token?p=%s";
    private String policy;

    B2CAuthority(URL uRL) {
        super(uRL, AuthorityType.B2C);
        this.setAuthorityProperties();
    }

    private void validatePathSegments(String[] stringArray) {
        if (stringArray.length < 3) {
            throw new IllegalArgumentException("B2C 'authority' Uri should have at least 3 segments in the path (i.e. https://<host>/tfp/<tenant>/<policy>/...)");
        }
    }

    private void setAuthorityProperties() {
        String[] stringArray = this.canonicalAuthorityUrl.getPath().substring(1).split("/");
        this.validatePathSegments(stringArray);
        this.policy = stringArray[2];
        String string = "https://%s/%s/%s/%s/";
        this.authority = String.format("https://%s/%s/%s/%s/", this.canonicalAuthorityUrl.getAuthority(), stringArray[0], stringArray[1], stringArray[2]);
        this.authorizationEndpoint = String.format(B2C_AUTHORIZATION_ENDPOINT_FORMAT, this.host, this.tenant, this.policy);
        this.selfSignedJwtAudience = this.tokenEndpoint = String.format(B2C_TOKEN_ENDPOINT_FORMAT, this.host, this.tenant, this.policy);
    }

    String policy() {
        return this.policy;
    }
}

