/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.concurrent.TimeUnit;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCode;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;

class AcquireTokenByDeviceCodeFlowSupplier
extends AuthenticationResultSupplier {
    private DeviceCodeFlowRequest deviceCodeFlowRequest;

    AcquireTokenByDeviceCodeFlowSupplier(PublicClientApplication publicClientApplication, DeviceCodeFlowRequest deviceCodeFlowRequest) {
        super(publicClientApplication, deviceCodeFlowRequest);
        this.deviceCodeFlowRequest = deviceCodeFlowRequest;
    }

    @Override
    AuthenticationResult execute() throws Exception {
        Authority authority = this.clientApplication.authenticationAuthority;
        authority = this.getAuthorityWithPrefNetworkHost(authority.authority());
        DeviceCode deviceCode = this.getDeviceCode(authority);
        return this.acquireTokenWithDeviceCode(deviceCode, authority);
    }

    private DeviceCode getDeviceCode(Authority authority) {
        DeviceCode deviceCode = this.deviceCodeFlowRequest.acquireDeviceCode(authority.deviceCodeEndpoint(), this.clientApplication.clientId(), this.deviceCodeFlowRequest.headers().getReadonlyHeaderMap(), this.clientApplication.getServiceBundle());
        this.deviceCodeFlowRequest.parameters().deviceCodeConsumer().accept(deviceCode);
        return deviceCode;
    }

    private AuthenticationResult acquireTokenWithDeviceCode(DeviceCode deviceCode, Authority authority) throws Exception {
        this.deviceCodeFlowRequest.createAuthenticationGrant(deviceCode);
        long l2 = this.getCurrentSystemTimeInSeconds() + deviceCode.expiresIn();
        AcquireTokenByAuthorizationGrantSupplier acquireTokenByAuthorizationGrantSupplier = new AcquireTokenByAuthorizationGrantSupplier(this.clientApplication, this.deviceCodeFlowRequest, authority);
        while (this.getCurrentSystemTimeInSeconds() < l2) {
            if (this.deviceCodeFlowRequest.futureReference().get().isCancelled()) {
                throw new InterruptedException("Acquire token Device Code Flow was interrupted");
            }
            try {
                return acquireTokenByAuthorizationGrantSupplier.execute();
            }
            catch (MsalServiceException msalServiceException) {
                if (msalServiceException.errorCode() != null && msalServiceException.errorCode().equals("authorization_pending")) {
                    TimeUnit.SECONDS.sleep(deviceCode.interval());
                    continue;
                }
                throw msalServiceException;
            }
        }
        throw new MsalClientException("Expired Device code", "code_expired");
    }

    private Long getCurrentSystemTimeInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }
}

