/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AADAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ADFSAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryProvider;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AccountsSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByClientCredentialSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByDeviceCodeFlowSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByInteractiveFlowSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByOnBehalfOfSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenSilentSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationCodeRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationRequestUrlParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.B2CAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DefaultHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.LogHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OnBehalfOfRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RemoveAccountRunnable;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TelemetryManager;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenCache;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenRequestExecutor;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserIdentifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;

public abstract class AbstractClientApplicationBase
implements IClientApplicationBase {
    protected Logger log;
    protected Authority authenticationAuthority;
    private ServiceBundle serviceBundle;
    private String clientId;
    private String authority;
    private boolean validateAuthority;
    private String correlationId;
    private boolean logPii;
    private Consumer<List<HashMap<String, String>>> telemetryConsumer;
    private Proxy proxy;
    private SSLSocketFactory sslSocketFactory;
    private Integer connectTimeoutForDefaultHttpClient;
    private Integer readTimeoutForDefaultHttpClient;
    protected TokenCache tokenCache;
    private String applicationName;
    private String applicationVersion;
    private AadInstanceDiscoveryResponse aadAadInstanceDiscoveryResponse;
    private String clientCapabilities;
    private boolean autoDetectRegion;
    private String azureRegion;

    protected abstract ClientAuthentication clientAuthentication();

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(AuthorizationCodeParameters authorizationCodeParameters) {
        ParameterValidationUtils.validateNotNull("parameters", authorizationCodeParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_AUTHORIZATION_CODE, authorizationCodeParameters);
        AuthorizationCodeRequest authorizationCodeRequest = new AuthorizationCodeRequest(authorizationCodeParameters, this, requestContext);
        return this.executeRequest(authorizationCodeRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(RefreshTokenParameters refreshTokenParameters) {
        ParameterValidationUtils.validateNotNull("parameters", refreshTokenParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_REFRESH_TOKEN, refreshTokenParameters);
        RefreshTokenRequest refreshTokenRequest = new RefreshTokenRequest(refreshTokenParameters, this, requestContext);
        return this.executeRequest(refreshTokenRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireTokenSilently(SilentParameters silentParameters) throws MalformedURLException {
        ParameterValidationUtils.validateNotNull("parameters", silentParameters);
        RequestContext requestContext = silentParameters.account() != null ? new RequestContext(this, PublicApi.ACQUIRE_TOKEN_SILENTLY, silentParameters, UserIdentifier.fromHomeAccountId(silentParameters.account().homeAccountId())) : new RequestContext(this, PublicApi.ACQUIRE_TOKEN_SILENTLY, silentParameters);
        SilentRequest silentRequest = new SilentRequest(silentParameters, this, requestContext, null);
        return this.executeRequest(silentRequest);
    }

    @Override
    public CompletableFuture<Set<IAccount>> getAccounts() {
        RequestContext requestContext = new RequestContext(this, PublicApi.GET_ACCOUNTS, null);
        MsalRequest msalRequest = new MsalRequest(this, null, requestContext){};
        AccountsSupplier accountsSupplier = new AccountsSupplier(this, msalRequest);
        return this.serviceBundle.getExecutorService() != null ? CompletableFuture.supplyAsync(accountsSupplier, this.serviceBundle.getExecutorService()) : CompletableFuture.supplyAsync(accountsSupplier);
    }

    @Override
    public CompletableFuture<Void> removeAccount(IAccount iAccount) {
        RequestContext requestContext = new RequestContext(this, PublicApi.REMOVE_ACCOUNTS, null);
        MsalRequest msalRequest = new MsalRequest(this, null, requestContext){};
        RemoveAccountRunnable removeAccountRunnable = new RemoveAccountRunnable(msalRequest, iAccount);
        return this.serviceBundle.getExecutorService() != null ? CompletableFuture.runAsync(removeAccountRunnable, this.serviceBundle.getExecutorService()) : CompletableFuture.runAsync(removeAccountRunnable);
    }

    @Override
    public URL getAuthorizationRequestUrl(AuthorizationRequestUrlParameters authorizationRequestUrlParameters) {
        ParameterValidationUtils.validateNotNull("parameters", authorizationRequestUrlParameters);
        authorizationRequestUrlParameters.requestParameters.put("client_id", Collections.singletonList(this.clientId));
        if (this.clientCapabilities != null) {
            if (authorizationRequestUrlParameters.requestParameters.containsKey("claims")) {
                String string = String.valueOf(authorizationRequestUrlParameters.requestParameters.get("claims").get(0));
                String string2 = JsonHelper.mergeJSONString(string, this.clientCapabilities);
                authorizationRequestUrlParameters.requestParameters.put("claims", Collections.singletonList(string2));
            } else {
                authorizationRequestUrlParameters.requestParameters.put("claims", Collections.singletonList(this.clientCapabilities));
            }
        }
        return authorizationRequestUrlParameters.createAuthorizationURL(this.authenticationAuthority, authorizationRequestUrlParameters.requestParameters());
    }

    CompletableFuture<IAuthenticationResult> executeRequest(MsalRequest msalRequest) {
        AuthenticationResultSupplier authenticationResultSupplier = this.getAuthenticationResultSupplier(msalRequest);
        ExecutorService executorService = this.serviceBundle.getExecutorService();
        return executorService != null ? CompletableFuture.supplyAsync(authenticationResultSupplier, executorService) : CompletableFuture.supplyAsync(authenticationResultSupplier);
    }

    AuthenticationResult acquireTokenCommon(MsalRequest msalRequest, Authority authority) throws Exception {
        HttpHeaders httpHeaders = msalRequest.headers();
        if (this.logPii) {
            this.log.debug(LogHelper.createMessage(String.format("Using Client Http Headers: %s", httpHeaders), httpHeaders.getHeaderCorrelationIdValue()));
        }
        TokenRequestExecutor tokenRequestExecutor = new TokenRequestExecutor(authority, msalRequest, this.serviceBundle);
        AuthenticationResult authenticationResult = tokenRequestExecutor.executeTokenRequest();
        if (this.authenticationAuthority.authorityType.equals((Object)AuthorityType.AAD)) {
            InstanceDiscoveryMetadataEntry instanceDiscoveryMetadataEntry = AadInstanceDiscoveryProvider.getMetadataEntry(authority.canonicalAuthorityUrl(), this.validateAuthority, msalRequest, this.serviceBundle);
            this.tokenCache.saveTokens(tokenRequestExecutor, authenticationResult, instanceDiscoveryMetadataEntry.preferredCache);
        } else {
            this.tokenCache.saveTokens(tokenRequestExecutor, authenticationResult, this.authenticationAuthority.host);
        }
        return authenticationResult;
    }

    private AuthenticationResultSupplier getAuthenticationResultSupplier(MsalRequest msalRequest) {
        AuthenticationResultSupplier authenticationResultSupplier = msalRequest instanceof DeviceCodeFlowRequest ? new AcquireTokenByDeviceCodeFlowSupplier((PublicClientApplication)this, (DeviceCodeFlowRequest)msalRequest) : (msalRequest instanceof SilentRequest ? new AcquireTokenSilentSupplier(this, (SilentRequest)msalRequest) : (msalRequest instanceof InteractiveRequest ? new AcquireTokenByInteractiveFlowSupplier((PublicClientApplication)this, (InteractiveRequest)msalRequest) : (msalRequest instanceof ClientCredentialRequest ? new AcquireTokenByClientCredentialSupplier((ConfidentialClientApplication)this, (ClientCredentialRequest)msalRequest) : (msalRequest instanceof OnBehalfOfRequest ? new AcquireTokenByOnBehalfOfSupplier((ConfidentialClientApplication)this, (OnBehalfOfRequest)msalRequest) : new AcquireTokenByAuthorizationGrantSupplier(this, msalRequest, null)))));
        return authenticationResultSupplier;
    }

    ServiceBundle getServiceBundle() {
        return this.serviceBundle;
    }

    AbstractClientApplicationBase(Builder<?> builder) {
        this.clientId = ((Builder)builder).clientId;
        this.authority = ((Builder)builder).authority;
        this.validateAuthority = ((Builder)builder).validateAuthority;
        this.correlationId = ((Builder)builder).correlationId;
        this.logPii = ((Builder)builder).logPii;
        this.applicationName = ((Builder)builder).applicationName;
        this.applicationVersion = ((Builder)builder).applicationVersion;
        this.telemetryConsumer = ((Builder)builder).telemetryConsumer;
        this.proxy = ((Builder)builder).proxy;
        this.sslSocketFactory = ((Builder)builder).sslSocketFactory;
        this.connectTimeoutForDefaultHttpClient = ((Builder)builder).connectTimeoutForDefaultHttpClient;
        this.readTimeoutForDefaultHttpClient = ((Builder)builder).readTimeoutForDefaultHttpClient;
        this.serviceBundle = new ServiceBundle(((Builder)builder).executorService, ((Builder)builder).httpClient == null ? new DefaultHttpClient(((Builder)builder).proxy, ((Builder)builder).sslSocketFactory, ((Builder)builder).connectTimeoutForDefaultHttpClient, ((Builder)builder).readTimeoutForDefaultHttpClient) : ((Builder)builder).httpClient, new TelemetryManager(this.telemetryConsumer, ((Builder)builder).onlySendFailureTelemetry));
        this.authenticationAuthority = ((Builder)builder).authenticationAuthority;
        this.tokenCache = new TokenCache(((Builder)builder).tokenCacheAccessAspect);
        this.aadAadInstanceDiscoveryResponse = ((Builder)builder).aadInstanceDiscoveryResponse;
        this.clientCapabilities = ((Builder)builder).clientCapabilities;
        this.autoDetectRegion = ((Builder)builder).autoDetectRegion;
        this.azureRegion = ((Builder)builder).azureRegion;
        if (this.aadAadInstanceDiscoveryResponse != null) {
            AadInstanceDiscoveryProvider.cacheInstanceDiscoveryMetadata(this.authenticationAuthority.host, this.aadAadInstanceDiscoveryResponse);
        }
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public String authority() {
        return this.authority;
    }

    @Override
    public boolean validateAuthority() {
        return this.validateAuthority;
    }

    @Override
    public String correlationId() {
        return this.correlationId;
    }

    @Override
    public boolean logPii() {
        return this.logPii;
    }

    Consumer<List<HashMap<String, String>>> telemetryConsumer() {
        return this.telemetryConsumer;
    }

    @Override
    public Proxy proxy() {
        return this.proxy;
    }

    @Override
    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public Integer connectTimeoutForDefaultHttpClient() {
        return this.connectTimeoutForDefaultHttpClient;
    }

    public Integer readTimeoutForDefaultHttpClient() {
        return this.readTimeoutForDefaultHttpClient;
    }

    @Override
    public TokenCache tokenCache() {
        return this.tokenCache;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationVersion() {
        return this.applicationVersion;
    }

    public AadInstanceDiscoveryResponse aadAadInstanceDiscoveryResponse() {
        return this.aadAadInstanceDiscoveryResponse;
    }

    public String clientCapabilities() {
        return this.clientCapabilities;
    }

    public boolean autoDetectRegion() {
        return this.autoDetectRegion;
    }

    public String azureRegion() {
        return this.azureRegion;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String clientId;
        private String authority = "https://login.microsoftonline.com/common/";
        private Authority authenticationAuthority = Builder.createDefaultAADAuthority();
        private boolean validateAuthority = true;
        private String correlationId;
        private boolean logPii = false;
        private ExecutorService executorService;
        private Proxy proxy;
        private SSLSocketFactory sslSocketFactory;
        private IHttpClient httpClient;
        private Consumer<List<HashMap<String, String>>> telemetryConsumer;
        private Boolean onlySendFailureTelemetry = false;
        private String applicationName;
        private String applicationVersion;
        private ITokenCacheAccessAspect tokenCacheAccessAspect;
        private AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse;
        private String clientCapabilities;
        private boolean autoDetectRegion;
        private String azureRegion;
        private Integer connectTimeoutForDefaultHttpClient;
        private Integer readTimeoutForDefaultHttpClient;

        public Builder(String string) {
            ParameterValidationUtils.validateNotBlank("clientId", string);
            this.clientId = string;
        }

        abstract T self();

        public T authority(String string) throws MalformedURLException {
            this.authority = Authority.enforceTrailingSlash(string);
            URL uRL = new URL(this.authority);
            Authority.validateAuthority(uRL);
            switch (Authority.detectAuthorityType(uRL)) {
                case AAD: {
                    this.authenticationAuthority = new AADAuthority(uRL);
                    break;
                }
                case ADFS: {
                    this.authenticationAuthority = new ADFSAuthority(uRL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported authority type.");
                }
            }
            return this.self();
        }

        public T b2cAuthority(String string) throws MalformedURLException {
            this.authority = Authority.enforceTrailingSlash(string);
            URL uRL = new URL(this.authority);
            Authority.validateAuthority(uRL);
            if (Authority.detectAuthorityType(uRL) != AuthorityType.B2C) {
                throw new IllegalArgumentException("Unsupported authority type. Please use B2C authority");
            }
            this.authenticationAuthority = new B2CAuthority(uRL);
            this.validateAuthority = false;
            return this.self();
        }

        public T validateAuthority(boolean bl2) {
            this.validateAuthority = bl2;
            return this.self();
        }

        public T correlationId(String string) {
            ParameterValidationUtils.validateNotBlank("correlationId", string);
            this.correlationId = string;
            return this.self();
        }

        public T logPii(boolean bl2) {
            this.logPii = bl2;
            return this.self();
        }

        public T executorService(ExecutorService executorService) {
            ParameterValidationUtils.validateNotNull("executorService", executorService);
            this.executorService = executorService;
            return this.self();
        }

        public T proxy(Proxy proxy) {
            ParameterValidationUtils.validateNotNull("proxy", proxy);
            this.proxy = proxy;
            return this.self();
        }

        public T httpClient(IHttpClient iHttpClient) {
            ParameterValidationUtils.validateNotNull("httpClient", iHttpClient);
            this.httpClient = iHttpClient;
            return this.self();
        }

        public T sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            ParameterValidationUtils.validateNotNull("sslSocketFactory", sSLSocketFactory);
            this.sslSocketFactory = sSLSocketFactory;
            return this.self();
        }

        public T connectTimeoutForDefaultHttpClient(Integer n2) {
            ParameterValidationUtils.validateNotNull("connectTimeoutForDefaultHttpClient", n2);
            this.connectTimeoutForDefaultHttpClient = n2;
            return this.self();
        }

        public T readTimeoutForDefaultHttpClient(Integer n2) {
            ParameterValidationUtils.validateNotNull("readTimeoutForDefaultHttpClient", n2);
            this.readTimeoutForDefaultHttpClient = n2;
            return this.self();
        }

        T telemetryConsumer(Consumer<List<HashMap<String, String>>> consumer) {
            ParameterValidationUtils.validateNotNull("telemetryConsumer", consumer);
            this.telemetryConsumer = consumer;
            return this.self();
        }

        T onlySendFailureTelemetry(Boolean bl2) {
            this.onlySendFailureTelemetry = bl2;
            return this.self();
        }

        public T applicationName(String string) {
            ParameterValidationUtils.validateNotNull("applicationName", string);
            this.applicationName = string;
            return this.self();
        }

        public T applicationVersion(String string) {
            ParameterValidationUtils.validateNotNull("applicationVersion", string);
            this.applicationVersion = string;
            return this.self();
        }

        public T setTokenCacheAccessAspect(ITokenCacheAccessAspect iTokenCacheAccessAspect) {
            ParameterValidationUtils.validateNotNull("tokenCacheAccessAspect", iTokenCacheAccessAspect);
            this.tokenCacheAccessAspect = iTokenCacheAccessAspect;
            return this.self();
        }

        public T aadInstanceDiscoveryResponse(String string) {
            ParameterValidationUtils.validateNotNull("aadInstanceDiscoveryResponse", string);
            this.aadInstanceDiscoveryResponse = AadInstanceDiscoveryProvider.parseInstanceDiscoveryMetadata(string);
            return this.self();
        }

        private static Authority createDefaultAADAuthority() {
            AADAuthority aADAuthority;
            try {
                aADAuthority = new AADAuthority(new URL("https://login.microsoftonline.com/common/"));
            }
            catch (Exception exception) {
                throw new MsalClientException(exception);
            }
            return aADAuthority;
        }

        public T clientCapabilities(Set<String> set) {
            this.clientCapabilities = JsonHelper.formCapabilitiesJson(set);
            return this.self();
        }

        public T autoDetectRegion(boolean bl2) {
            this.autoDetectRegion = bl2;
            return this.self();
        }

        public T azureRegion(String string) {
            this.azureRegion = string;
            return this.self();
        }

        abstract AbstractClientApplicationBase build();
    }
}

