/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.CurrentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceExceptionFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RegionTelemetry;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class AadInstanceDiscoveryProvider {
    private static final String DEFAULT_TRUSTED_HOST = "login.microsoftonline.com";
    private static final String AUTHORIZE_ENDPOINT_TEMPLATE = "https://{host}/{tenant}/oauth2/v2.0/authorize";
    private static final String INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE = "https://{host}:{port}/common/discovery/instance";
    private static final String INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE_WITH_REGION = "https://{region}.r.{host}:{port}/common/discovery/instance";
    private static final String INSTANCE_DISCOVERY_SOVEREIGN_ENDPOINT_TEMPLATE_WITH_REGION = "https://{region}.{host}:{port}/common/discovery/instance";
    private static final String INSTANCE_DISCOVERY_REQUEST_PARAMETERS_TEMPLATE = "?api-version=1.1&authorization_endpoint={authorizeEndpoint}";
    private static final String REGION_NAME = "REGION_NAME";
    private static final int PORT_NOT_SET = -1;
    private static final String DEFAULT_API_VERSION = "2020-06-01";
    private static final String IMDS_ENDPOINT = "https://169.254.169.254/metadata/instance/compute/location?2020-06-01&format=text";
    static final TreeSet<String> TRUSTED_HOSTS_SET = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    static final TreeSet<String> TRUSTED_SOVEREIGN_HOSTS_SET = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);
    static ConcurrentHashMap<String, InstanceDiscoveryMetadataEntry> cache = new ConcurrentHashMap();

    AadInstanceDiscoveryProvider() {
    }

    static InstanceDiscoveryMetadataEntry getMetadataEntry(URL uRL, boolean bl2, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        InstanceDiscoveryMetadataEntry instanceDiscoveryMetadataEntry = cache.get(uRL.getHost());
        if (instanceDiscoveryMetadataEntry == null) {
            AadInstanceDiscoveryProvider.doInstanceDiscoveryAndCache(uRL, bl2, msalRequest, serviceBundle);
        }
        return cache.get(uRL.getHost());
    }

    static Set<String> getAliases(String string) {
        if (cache.containsKey(string)) {
            return cache.get(string).aliases();
        }
        return Collections.singleton(string);
    }

    static AadInstanceDiscoveryResponse parseInstanceDiscoveryMetadata(String string) {
        AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse;
        try {
            aadInstanceDiscoveryResponse = JsonHelper.convertJsonToObject(string, AadInstanceDiscoveryResponse.class);
        }
        catch (Exception exception) {
            throw new MsalClientException("Error parsing instance discovery response. Data must be in valid JSON format. For more information, see https://aka.ms/msal4j-instance-discovery", "invalid_instance_discovery_metadata");
        }
        return aadInstanceDiscoveryResponse;
    }

    static void cacheInstanceDiscoveryMetadata(String string, AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse) {
        if (aadInstanceDiscoveryResponse != null && aadInstanceDiscoveryResponse.metadata() != null) {
            for (InstanceDiscoveryMetadataEntry instanceDiscoveryMetadataEntry : aadInstanceDiscoveryResponse.metadata()) {
                for (String string2 : instanceDiscoveryMetadataEntry.aliases()) {
                    cache.put(string2, instanceDiscoveryMetadataEntry);
                }
            }
        }
        cache.putIfAbsent(string, InstanceDiscoveryMetadataEntry.builder().preferredCache(string).preferredNetwork(string).aliases(Collections.singleton(string)).build());
    }

    private static String getAuthorizeEndpoint(String string, String string2) {
        return AUTHORIZE_ENDPOINT_TEMPLATE.replace("{host}", string).replace("{tenant}", string2);
    }

    private static String getInstanceDiscoveryEndpoint(URL uRL) {
        String string = TRUSTED_HOSTS_SET.contains(uRL.getHost()) ? uRL.getHost() : DEFAULT_TRUSTED_HOST;
        int n2 = uRL.getPort() == -1 ? uRL.getDefaultPort() : uRL.getPort();
        return INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE.replace("{host}", string).replace("{port}", String.valueOf(n2));
    }

    private static String getInstanceDiscoveryEndpointWithRegion(URL uRL, String string) {
        int n2;
        String string2 = TRUSTED_HOSTS_SET.contains(uRL.getHost()) ? uRL.getHost() : DEFAULT_TRUSTED_HOST;
        int n3 = n2 = uRL.getPort() == -1 ? uRL.getDefaultPort() : uRL.getPort();
        if (TRUSTED_SOVEREIGN_HOSTS_SET.contains(uRL.getHost())) {
            return INSTANCE_DISCOVERY_SOVEREIGN_ENDPOINT_TEMPLATE_WITH_REGION.replace("{region}", string).replace("{host}", string2).replace("{port}", String.valueOf(n2));
        }
        return INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE_WITH_REGION.replace("{region}", string).replace("{host}", string2).replace("{port}", String.valueOf(n2));
    }

    private static AadInstanceDiscoveryResponse sendInstanceDiscoveryRequest(URL uRL, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        String string;
        IHttpResponse iHttpResponse = null;
        String string2 = msalRequest.application().azureRegion();
        String string3 = null;
        int n2 = 0;
        String string4 = null;
        if (string2 != null) {
            string3 = AadInstanceDiscoveryProvider.discoverRegion(msalRequest, serviceBundle);
            string4 = string2;
            n2 = AadInstanceDiscoveryProvider.determineRegionOutcome(string3, string2, msalRequest.application().autoDetectRegion());
        } else if (msalRequest.application().autoDetectRegion()) {
            string3 = AadInstanceDiscoveryProvider.discoverRegion(msalRequest, serviceBundle);
            if (string3 != null) {
                string4 = string3;
            }
            n2 = AadInstanceDiscoveryProvider.determineRegionOutcome(string3, string2, msalRequest.application().autoDetectRegion());
        }
        if (string4 != null) {
            string = AadInstanceDiscoveryProvider.getInstanceDiscoveryEndpointWithRegion(uRL, string4) + AadInstanceDiscoveryProvider.formInstanceDiscoveryParameters(uRL);
            try {
                iHttpResponse = AadInstanceDiscoveryProvider.executeRequest(string, msalRequest.headers().getReadonlyHeaderMap(), msalRequest, serviceBundle);
            }
            catch (MsalClientException msalClientException) {
                log.warn("Could not retrieve regional instance discovery metadata, falling back to global endpoint");
            }
        }
        if (string3 == null && string2 == null || iHttpResponse == null || iHttpResponse.statusCode() != 200) {
            string = AadInstanceDiscoveryProvider.getInstanceDiscoveryEndpoint(uRL) + AadInstanceDiscoveryProvider.formInstanceDiscoveryParameters(uRL);
            iHttpResponse = AadInstanceDiscoveryProvider.executeRequest(string, msalRequest.headers().getReadonlyHeaderMap(), msalRequest, serviceBundle);
        }
        if (iHttpResponse.statusCode() != 200) {
            throw MsalServiceExceptionFactory.fromHttpResponse(iHttpResponse);
        }
        serviceBundle.getServerSideTelemetry().getCurrentRequest().regionOutcome(n2);
        return JsonHelper.convertJsonToObject(iHttpResponse.body(), AadInstanceDiscoveryResponse.class);
    }

    private static int determineRegionOutcome(String string, String string2, boolean bl2) {
        int n2 = 0;
        if (string2 != null) {
            n2 = string == null ? RegionTelemetry.REGION_OUTCOME_DEVELOPER_AUTODETECT_FAILED.telemetryValue : (string2.equals(string) ? RegionTelemetry.REGION_OUTCOME_DEVELOPER_AUTODETECT_MATCH.telemetryValue : RegionTelemetry.REGION_OUTCOME_DEVELOPER_AUTODETECT_MISMATCH.telemetryValue);
        } else if (bl2) {
            n2 = string != null ? RegionTelemetry.REGION_OUTCOME_AUTODETECT_SUCCESS.telemetryValue : RegionTelemetry.REGION_OUTCOME_AUTODETECT_FAILED.telemetryValue;
        }
        return n2;
    }

    private static String formInstanceDiscoveryParameters(URL uRL) {
        return INSTANCE_DISCOVERY_REQUEST_PARAMETERS_TEMPLATE.replace("{authorizeEndpoint}", AadInstanceDiscoveryProvider.getAuthorizeEndpoint(uRL.getHost(), Authority.getTenant(uRL, Authority.detectAuthorityType(uRL))));
    }

    private static IHttpResponse executeRequest(String string, Map<String, String> map, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, string, map);
        return HttpHelper.executeHttpRequest(httpRequest, msalRequest.requestContext(), serviceBundle);
    }

    private static String discoverRegion(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        CurrentRequest currentRequest = serviceBundle.getServerSideTelemetry().getCurrentRequest();
        if (System.getenv(REGION_NAME) != null) {
            log.info("Region found in environment variable: " + System.getenv(REGION_NAME));
            currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_ENV_VARIABLE.telemetryValue);
            return System.getenv(REGION_NAME);
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Metadata", "true");
            IHttpResponse iHttpResponse = AadInstanceDiscoveryProvider.executeRequest(IMDS_ENDPOINT, hashMap, msalRequest, serviceBundle);
            if (iHttpResponse.statusCode() == 200 && !iHttpResponse.body().isEmpty()) {
                log.info("Region retrieved from IMDS endpoint: " + iHttpResponse.body());
                currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_IMDS.telemetryValue);
                return iHttpResponse.body();
            }
            log.warn(String.format("Call to local IMDS failed with status code: %s, or response was empty", iHttpResponse.statusCode()));
            currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_FAILED_AUTODETECT.telemetryValue);
            return null;
        }
        catch (Exception exception) {
            log.warn(String.format("Exception during call to local IMDS endpoint: %s", exception.getMessage()));
            currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_FAILED_AUTODETECT.telemetryValue);
            return null;
        }
    }

    private static void doInstanceDiscoveryAndCache(URL uRL, boolean bl2, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse = null;
        if (msalRequest.application().authenticationAuthority.authorityType.equals((Object)AuthorityType.AAD)) {
            aadInstanceDiscoveryResponse = AadInstanceDiscoveryProvider.sendInstanceDiscoveryRequest(uRL, msalRequest, serviceBundle);
            if (bl2) {
                AadInstanceDiscoveryProvider.validate(aadInstanceDiscoveryResponse);
            }
        }
        AadInstanceDiscoveryProvider.cacheInstanceDiscoveryMetadata(uRL.getHost(), aadInstanceDiscoveryResponse);
    }

    private static void validate(AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse) {
        if (StringHelper.isBlank(aadInstanceDiscoveryResponse.tenantDiscoveryEndpoint())) {
            throw new MsalServiceException(aadInstanceDiscoveryResponse);
        }
    }

    static {
        TRUSTED_SOVEREIGN_HOSTS_SET.addAll(Arrays.asList("login.chinacloudapi.cn", "login-us.microsoftonline.com", "login.microsoftonline.de", "login.microsoftonline.us"));
        TRUSTED_HOSTS_SET.addAll(Arrays.asList("login.windows.net", DEFAULT_TRUSTED_HOST));
        TRUSTED_HOSTS_SET.addAll(TRUSTED_SOVEREIGN_HOSTS_SET);
    }
}

