/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.google.gson.internal.bind;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import macromedia.jdbc.sqlserver.externals.com.google.gson.Gson;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonSyntaxException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.TypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.google.gson.TypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.JavaVersion;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.PreJava9DateFormatProvider;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.bind.util.ISO8601Utils;
import macromedia.jdbc.sqlserver.externals.com.google.gson.reflect.TypeToken;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonWriter;

public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new DateTypeAdapter() : null;
        }
    };
    private final List<DateFormat> dateFormats = new ArrayList<DateFormat>();

    public DateTypeAdapter() {
        this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateTimeFormat(2, 2));
        }
    }

    @Override
    public Date read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return this.deserializeToDate(jsonReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date deserializeToDate(JsonReader jsonReader) throws IOException {
        String string = jsonReader.nextString();
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            for (DateFormat dateFormat : this.dateFormats) {
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                }
            }
        }
        try {
            return ISO8601Utils.parse(string, new ParsePosition(0));
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException("Failed parsing '" + string + "' as Date; at path " + jsonReader.getPreviousPath(), parseException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonWriter jsonWriter, Date date) throws IOException {
        String string;
        if (date == null) {
            jsonWriter.nullValue();
            return;
        }
        DateFormat dateFormat = this.dateFormats.get(0);
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            string = dateFormat.format(date);
        }
        jsonWriter.value(string);
    }
}

