/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser;

import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonInclude;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.AnnotationIntrospector;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.MapperFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.Annotated;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.Annotations;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ArrayBuilders;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.BeanUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.NameTransformer;

public class PropertyBuilder {
    private static final Object NO_DEFAULT_MARKER = Boolean.FALSE;
    protected final SerializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;
    protected final JsonInclude.Value _defaultInclusion;
    protected final boolean _useRealPropertyDefaults;

    public PropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        this._config = serializationConfig;
        this._beanDesc = beanDescription;
        JsonInclude.Value value = JsonInclude.Value.merge(beanDescription.findPropertyInclusion(JsonInclude.Value.empty()), serializationConfig.getDefaultPropertyInclusion(beanDescription.getBeanClass(), JsonInclude.Value.empty()));
        this._defaultInclusion = JsonInclude.Value.merge(serializationConfig.getDefaultPropertyInclusion(), value);
        this._useRealPropertyDefaults = value.getValueInclusion() == JsonInclude.Include.NON_DEFAULT;
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public Annotations getClassAnnotations() {
        return this._beanDesc.getClassAnnotations();
    }

    protected BeanPropertyWriter buildWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, TypeSerializer typeSerializer2, AnnotatedMember annotatedMember, boolean bl2) throws JsonMappingException {
        NameTransformer nameTransformer;
        Object object;
        Class<?>[] classArray;
        Object object2;
        JavaType javaType2;
        try {
            javaType2 = this.findSerializationType(annotatedMember, bl2, javaType);
        }
        catch (JsonMappingException jsonMappingException) {
            if (beanPropertyDefinition == null) {
                return (BeanPropertyWriter)serializerProvider.reportBadDefinition(javaType, ClassUtil.exceptionMessage(jsonMappingException));
            }
            return (BeanPropertyWriter)serializerProvider.reportBadPropertyDefinition(this._beanDesc, beanPropertyDefinition, ClassUtil.exceptionMessage(jsonMappingException), new Object[0]);
        }
        if (typeSerializer2 != null) {
            if (javaType2 == null) {
                javaType2 = javaType;
            }
            if ((object2 = javaType2.getContentType()) == null) {
                serializerProvider.reportBadPropertyDefinition(this._beanDesc, beanPropertyDefinition, "serialization type " + javaType2 + " has no content", new Object[0]);
            }
            javaType2 = javaType2.withContentTypeHandler(typeSerializer2);
            object2 = javaType2.getContentType();
        }
        object2 = null;
        boolean bl3 = false;
        JavaType javaType3 = javaType2 == null ? javaType : javaType2;
        AnnotatedMember annotatedMember2 = beanPropertyDefinition.getAccessor();
        if (annotatedMember2 == null) {
            return (BeanPropertyWriter)serializerProvider.reportBadPropertyDefinition(this._beanDesc, beanPropertyDefinition, "could not determine property type", new Object[0]);
        }
        Class<?> clazz = annotatedMember2.getRawType();
        JsonInclude.Value value = this._config.getDefaultInclusion(javaType3.getRawClass(), clazz, this._defaultInclusion);
        JsonInclude.Include include = (value = value.withOverrides(beanPropertyDefinition.findInclusion())).getValueInclusion();
        if (include == JsonInclude.Include.USE_DEFAULTS) {
            include = JsonInclude.Include.ALWAYS;
        }
        switch (include) {
            case NON_DEFAULT: {
                if (this._useRealPropertyDefaults && (classArray = this.getDefaultBean()) != null) {
                    if (serializerProvider.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                        annotatedMember.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                    }
                    try {
                        object2 = annotatedMember.getValue(classArray);
                    }
                    catch (Exception exception) {
                        this._throwWrapped(exception, beanPropertyDefinition.getName(), classArray);
                    }
                } else {
                    object2 = BeanUtil.getDefaultValue(javaType3);
                    bl3 = true;
                }
                if (object2 == null) {
                    bl3 = true;
                    break;
                }
                if (!object2.getClass().isArray()) break;
                object2 = ArrayBuilders.getArrayComparator(object2);
                break;
            }
            case NON_ABSENT: {
                bl3 = true;
                if (!javaType3.isReferenceType()) break;
                object2 = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case NON_EMPTY: {
                bl3 = true;
                object2 = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case CUSTOM: {
                object2 = serializerProvider.includeFilterInstance(beanPropertyDefinition, value.getValueFilter());
                break;
            }
            case NON_NULL: {
                bl3 = true;
            }
            default: {
                object = SerializationFeature.WRITE_EMPTY_JSON_ARRAYS;
                if (!javaType3.isContainerType() || this._config.isEnabled((SerializationFeature)object)) break;
                object2 = BeanPropertyWriter.MARKER_FOR_EMPTY;
            }
        }
        classArray = beanPropertyDefinition.findViews();
        if (classArray == null) {
            classArray = this._beanDesc.findDefaultViews();
        }
        object = this._constructPropertyWriter(beanPropertyDefinition, annotatedMember, this._beanDesc.getClassAnnotations(), javaType, jsonSerializer, typeSerializer, javaType2, bl3, object2, classArray);
        Object object3 = this._annotationIntrospector.findNullSerializer(annotatedMember);
        if (object3 != null) {
            ((BeanPropertyWriter)object).assignNullSerializer(serializerProvider.serializerInstance(annotatedMember, object3));
        }
        if ((nameTransformer = this._annotationIntrospector.findUnwrappingNameTransformer(annotatedMember)) != null) {
            object = ((BeanPropertyWriter)object).unwrappingWriter(nameTransformer);
        }
        return object;
    }

    protected BeanPropertyWriter _constructPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, AnnotatedMember annotatedMember, Annotations annotations, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JavaType javaType2, boolean bl2, Object object, Class<?>[] classArray) throws JsonMappingException {
        return new BeanPropertyWriter(beanPropertyDefinition, annotatedMember, annotations, javaType, jsonSerializer, typeSerializer, javaType2, bl2, object, classArray);
    }

    protected JavaType findSerializationType(Annotated annotated, boolean bl2, JavaType javaType) throws JsonMappingException {
        Object object;
        JavaType javaType2 = this._annotationIntrospector.refineSerializationType(this._config, annotated, javaType);
        if (javaType2 != javaType) {
            Class<?> clazz;
            object = javaType2.getRawClass();
            if (!((Class)object).isAssignableFrom(clazz = javaType.getRawClass()) && !clazz.isAssignableFrom((Class<?>)object)) {
                throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + annotated.getName() + "': class " + ((Class)object).getName() + " not a super-type of (declared) class " + clazz.getName());
            }
            bl2 = true;
            javaType = javaType2;
        }
        if ((object = this._annotationIntrospector.findSerializationTyping(annotated)) != null && object != JsonSerialize.Typing.DEFAULT_TYPING) {
            boolean bl3 = bl2 = object == JsonSerialize.Typing.STATIC;
        }
        if (bl2) {
            return javaType.withStaticTyping();
        }
        return null;
    }

    protected Object getDefaultBean() {
        Object object = this._defaultBean;
        if (object == null) {
            object = this._beanDesc.instantiateBean(this._config.canOverrideAccessModifiers());
            if (object == null) {
                object = NO_DEFAULT_MARKER;
            }
            this._defaultBean = object;
        }
        return object == NO_DEFAULT_MARKER ? null : this._defaultBean;
    }

    @Deprecated
    protected Object getPropertyDefaultValue(String string, AnnotatedMember annotatedMember, JavaType javaType) {
        Object object = this.getDefaultBean();
        if (object == null) {
            return this.getDefaultValue(javaType);
        }
        try {
            return annotatedMember.getValue(object);
        }
        catch (Exception exception) {
            return this._throwWrapped(exception, string, object);
        }
    }

    @Deprecated
    protected Object getDefaultValue(JavaType javaType) {
        return BeanUtil.getDefaultValue(javaType);
    }

    protected Object _throwWrapped(Exception exception, String string, Object object) {
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        ClassUtil.throwIfRTE(throwable);
        throw new IllegalArgumentException("Failed to get property '" + string + "' of default " + object.getClass().getName() + " instance");
    }
}

