/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotationMap;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

public final class AnnotatedMethod
extends AnnotatedWithParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Method _method;
    protected Class<?>[] _paramClasses;
    protected Serialization _serialization;

    public AnnotatedMethod(TypeResolutionContext typeResolutionContext, Method method, AnnotationMap annotationMap, AnnotationMap[] annotationMapArray) {
        super(typeResolutionContext, annotationMap, annotationMapArray);
        if (method == null) {
            throw new IllegalArgumentException("Cannot construct AnnotatedMethod with null Method");
        }
        this._method = method;
    }

    protected AnnotatedMethod(Serialization serialization) {
        super(null, null, null);
        this._method = null;
        this._serialization = serialization;
    }

    @Override
    public AnnotatedMethod withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedMethod(this._typeContext, this._method, annotationMap, this._paramAnnotations);
    }

    @Override
    public Method getAnnotated() {
        return this._method;
    }

    @Override
    public int getModifiers() {
        return this._method.getModifiers();
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public JavaType getType() {
        return this._typeContext.resolveType(this._method.getGenericReturnType());
    }

    @Override
    public Class<?> getRawType() {
        return this._method.getReturnType();
    }

    @Override
    public final Object call() throws Exception {
        return this._method.invoke(null, new Object[0]);
    }

    @Override
    public final Object call(Object[] objectArray) throws Exception {
        return this._method.invoke(null, objectArray);
    }

    @Override
    public final Object call1(Object object) throws Exception {
        return this._method.invoke(null, object);
    }

    public final Object callOn(Object object) throws Exception {
        return this._method.invoke(object, (Object[])null);
    }

    public final Object callOnWith(Object object, Object ... objectArray) throws Exception {
        return this._method.invoke(object, objectArray);
    }

    @Override
    public int getParameterCount() {
        return this._method.getParameterCount();
    }

    @Override
    public Class<?> getRawParameterType(int n2) {
        Class<?>[] classArray = this.getRawParameterTypes();
        return n2 >= classArray.length ? null : classArray[n2];
    }

    @Override
    public JavaType getParameterType(int n2) {
        Type[] typeArray = this._method.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return this._typeContext.resolveType(typeArray[n2]);
    }

    @Override
    @Deprecated
    public Type getGenericParameterType(int n2) {
        Type[] typeArray = this.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return typeArray[n2];
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    @Override
    public Method getMember() {
        return this._method;
    }

    @Override
    public void setValue(Object object, Object object2) throws IllegalArgumentException {
        try {
            this._method.invoke(object, object2);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException("Failed to setValue() with method " + this.getFullName() + ": " + ClassUtil.exceptionMessage(reflectiveOperationException), reflectiveOperationException);
        }
    }

    @Override
    public Object getValue(Object object) throws IllegalArgumentException {
        try {
            return this._method.invoke(object, (Object[])null);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException("Failed to getValue() with method " + this.getFullName() + ": " + ClassUtil.exceptionMessage(reflectiveOperationException), reflectiveOperationException);
        }
    }

    @Override
    public String getFullName() {
        String string = super.getFullName();
        switch (this.getParameterCount()) {
            case 0: {
                return string + "()";
            }
            case 1: {
                return string + "(" + this.getRawParameterType(0).getName() + ")";
            }
        }
        return String.format("%s(%d params)", super.getFullName(), this.getParameterCount());
    }

    public Class<?>[] getRawParameterTypes() {
        if (this._paramClasses == null) {
            this._paramClasses = this._method.getParameterTypes();
        }
        return this._paramClasses;
    }

    @Deprecated
    public Type[] getGenericParameterTypes() {
        return this._method.getGenericParameterTypes();
    }

    public Class<?> getRawReturnType() {
        return this._method.getReturnType();
    }

    @Deprecated
    public boolean hasReturnType() {
        Class<?> clazz = this.getRawReturnType();
        return clazz != Void.TYPE;
    }

    @Override
    public String toString() {
        return "[method " + this.getFullName() + "]";
    }

    @Override
    public int hashCode() {
        return this._method.getName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        AnnotatedMethod annotatedMethod = (AnnotatedMethod)object;
        if (annotatedMethod._method == null) {
            return this._method == null;
        }
        return annotatedMethod._method.equals(this._method);
    }

    Object writeReplace() {
        return new AnnotatedMethod(new Serialization(this._method));
    }

    Object readResolve() {
        Class<?> clazz = this._serialization.clazz;
        try {
            Method method = clazz.getDeclaredMethod(this._serialization.name, this._serialization.args);
            if (!method.isAccessible()) {
                ClassUtil.checkAndFixAccess(method, false);
            }
            return new AnnotatedMethod(null, method, null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find method '" + this._serialization.name + "' from Class '" + clazz.getName());
        }
    }

    private static final class Serialization
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Class<?> clazz;
        protected String name;
        protected Class<?>[] args;

        public Serialization(Method method) {
            this.clazz = method.getDeclaringClass();
            this.name = method.getName();
            this.args = method.getParameterTypes();
        }
    }
}

