/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.codecs;

import coldfusion.nosql.mongo.CFMongoContext;
import coldfusion.nosql.mongo.bson.BsonUtils;
import coldfusion.nosql.mongo.codecs.CFMongoCodec;
import coldfusion.runtime.Array;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Struct;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;

public class CFMapCodec
implements CFMongoCodec<Map>,
CollectibleCodec<Map> {
    private static final String ID_FIELD_NAME = "_id";
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private static final IdGenerator idGenerator = new ObjectIdGenerator();
    private boolean caseSensitivity;

    public CFMapCodec(CodecRegistry registry) {
        this.registry = registry;
        this.bsonTypeCodecMap = new BsonTypeCodecMap(bsonTypeClassMap, registry);
    }

    public CFMapCodec(CodecRegistry registry, boolean caseSensitivity) {
        this.registry = registry;
        this.bsonTypeCodecMap = new BsonTypeCodecMap(bsonTypeClassMap, registry);
        this.caseSensitivity = caseSensitivity;
    }

    public void encode(BsonWriter writer, Map struct, EncoderContext encoderContext) {
        writer.writeStartDocument();
        this.beforeFields(writer, encoderContext, struct);
        for (Map.Entry obj : struct.entrySet()) {
            Map.Entry entry = obj;
            if (this.skipField(encoderContext, (String)entry.getKey())) continue;
            writer.writeName((String)entry.getKey());
            this.writeValue(writer, encoderContext, entry.getValue());
        }
        writer.writeEndDocument();
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, Map value) {
        if (encoderContext.isEncodingCollectibleDocument() && value.containsKey(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, value.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String key) {
        return encoderContext.isEncodingCollectibleDocument() && key.equals(ID_FIELD_NAME);
    }

    public Map decode(BsonReader reader, DecoderContext decoderContext) {
        CaseSensitiveStruct struct = this.caseSensitivity ? new CaseSensitiveStruct() : new Struct();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            struct.put(fieldName, this.readValue(reader, decoderContext));
        }
        reader.readEndDocument();
        return struct;
    }

    public Class<Map> getEncoderClass() {
        return Map.class;
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return decoderContext.decodeWithChildContext((Decoder)this.registry.get(Array.class), reader);
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid((byte)reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return decoderContext.decodeWithChildContext((Decoder)this.registry.get(UUID.class), reader);
        }
        return this.bsonTypeCodecMap.get(bsonType).decode(reader, decoderContext);
    }

    private void writeValue(BsonWriter writer, EncoderContext encoderContext, Object value) {
        if (value == null) {
            writer.writeNull();
        } else {
            Codec codec = this.registry.get(value.getClass());
            encoderContext.encodeWithChildContext((Encoder)codec, writer, value);
        }
    }

    public Map generateIdIfAbsentFromDocument(Map document) {
        if (!this.documentHasId(document)) {
            String generatedId = new ObjectId().toHexString();
            document.put(ID_FIELD_NAME, generatedId);
            CFMongoContext current = CFMongoContext.current();
            if (current != null) {
                current.addInsertedId(generatedId);
            }
        }
        return document;
    }

    public boolean documentHasId(Map document) {
        return document.containsKey(ID_FIELD_NAME);
    }

    public BsonValue getDocumentId(Map document) {
        Object idVal = document.get(ID_FIELD_NAME);
        if (idVal != null) {
            return BsonUtils.getValue(idVal);
        }
        return null;
    }
}

