/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.core;

import coldfusion.filter.FusionContext;
import coldfusion.orm.ORMSettings;
import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.orm.search.ORMSearchManager;
import coldfusion.orm.search.core.CFCSearchMetadata;
import coldfusion.orm.search.core.IndexableField;
import coldfusion.orm.search.core.IndexableRelationField;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.MetadataUtils;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.server.ORMSearchService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import coldfusion.util.RB;
import coldfusion.util.RuntimeWrapper;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;

public class SearchPropertyBinder {
    private ORMSettings ormSettings;
    private AttributeCollection metadata;
    private String cfcName;
    private CFCSearchMetadata cfcSmd;
    private String cfcpackage;
    private String entityName;
    private static final String EXTENDS = "EXTENDS";
    private boolean referredCFC = false;
    private HibernateConfiguration hibernateConf;
    private static final String DATE = "date";
    private boolean metadataCloned = false;
    private static Set<String> storeOptions = new HashSet<String>();

    public SearchPropertyBinder(String pathToCFC, ORMSettings ormSettings, HibernateConfiguration hibernateConf) {
        this.ormSettings = ormSettings;
        this.hibernateConf = hibernateConf;
        NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
        try {
            this.metadata = (AttributeCollection)MetadataUtils.getBasicComponentMetadata((File)VFSFileFactory.getFileObject((String)pathToCFC), (NeoPageContext)pageContext, null);
        }
        catch (Throwable throwable) {
            throw new RuntimeWrapper(throwable);
        }
        this.cfcName = (String)this.metadata.get((Object)"name");
        this.entityName = hibernateConf.getEntityName(this.cfcName);
        if (this.entityName == null) {
            return;
        }
        PersistentClass hibernatePersistentClazz = hibernateConf.getHibernatePersistenceClass(this.entityName);
        int lastIndex = this.cfcName.lastIndexOf(46);
        if (lastIndex != -1) {
            this.cfcpackage = this.cfcName.substring(0, lastIndex);
        }
        this.buildCFCSearchMetadata(hibernatePersistentClazz);
    }

    private SearchPropertyBinder(AttributeCollection metadata, ORMSettings ormSettings, HibernateConfiguration hibernateConf) {
        this.ormSettings = ormSettings;
        this.metadata = metadata;
        this.cfcName = (String)metadata.get((Object)"name");
        this.entityName = hibernateConf.getEntityName(this.cfcName);
        if (this.entityName == null) {
            return;
        }
        PersistentClass hibernatePersistentClazz = hibernateConf.getHibernatePersistenceClass(this.entityName);
        int lastIndex = this.cfcName.lastIndexOf(46);
        if (lastIndex != -1) {
            this.cfcpackage = this.cfcName.substring(0, lastIndex);
        }
        this.referredCFC = true;
        this.buildCFCSearchMetadata(hibernatePersistentClazz);
    }

    public boolean isIndexable() {
        if (this.entityName == null) {
            return false;
        }
        String indexableStr = (String)this.metadata.get((Object)"indexable");
        return this.getBooleanValue(indexableStr, false);
    }

    public boolean hasIndexableField() {
        Object[] props = (Object[])this.metadata.get((Object)"properties");
        if (props == null) {
            return false;
        }
        for (Object prop : props) {
            AttributeCollection attr = (AttributeCollection)prop;
            String indexableStr = (String)attr.get((Object)"indexable");
            if (indexableStr != null && !Cast._boolean((String)indexableStr)) continue;
            return true;
        }
        return false;
    }

    public synchronized CFCSearchMetadata getCFCSearchMetadata() {
        return this.cfcSmd;
    }

    private CFCSearchMetadata buildCFCSearchMetadata(PersistentClass hibernatePersistentClass) {
        if (!this.isIndexable() && !this.referredCFC) {
            return null;
        }
        PersistentClass parentPersistentClass = hibernatePersistentClass.getSuperclass();
        this.cfcSmd = new CFCSearchMetadata();
        if (parentPersistentClass != null) {
            this.cfcSmd.setParentEntityName(parentPersistentClass.getEntityName());
        }
        this.readCFCData();
        this.readPropertiesFromParentClass(this.metadata);
        if (!this.hasIndexableField()) {
            return this.cfcSmd;
        }
        this.readProperties(hibernatePersistentClass);
        return this.cfcSmd;
    }

    private void readCFCData() {
        Object searchSettings;
        ORMSearchService ormSearchService;
        this.cfcSmd.setCfcName(this.cfcName);
        this.cfcSmd.setEntityName(this.entityName);
        String language = (String)this.metadata.get((Object)"indexlanguage");
        if ((language == null || language.length() == 0) && (ormSearchService = ServiceFactory.getOrmSearchService()) != null && (searchSettings = this.ormSettings.getSearchSetting()) != null) {
            language = ormSearchService.getLanguage(searchSettings);
        }
        this.cfcSmd.setLanguage(language);
        String autoIndex = (String)this.metadata.get((Object)"autoindex");
        this.cfcSmd.setAutoIndex(this.getBooleanValue(autoIndex, true));
    }

    private void readPropertiesFromParentClass(AttributeCollection childMetadata) {
        AttributeCollection parentMetadata = this.getParentMetadata(childMetadata);
        if (parentMetadata == null) {
            return;
        }
        String parentCFCName = (String)parentMetadata.get((Object)"NAME");
        if ("WEB-INF.cftags.component".equalsIgnoreCase(parentCFCName)) {
            return;
        }
        Object[] parentPropertiesArray = (Object[])parentMetadata.get((Object)"properties");
        if (parentPropertiesArray == null || parentPropertiesArray.length == 0) {
            this.readPropertiesFromParentClass(parentMetadata);
            return;
        }
        CaseInsensitiveMap mergedProps = new CaseInsensitiveMap();
        for (int i = 0; i < parentPropertiesArray.length; ++i) {
            Map parentProperties = (Map)parentPropertiesArray[i];
            String propsName = (String)parentProperties.get("name");
            String persistentStr = (String)parentProperties.get("persistent");
            if (persistentStr != null && !"true".equalsIgnoreCase(persistentStr) && !"yes".equalsIgnoreCase(persistentStr)) continue;
            mergedProps.put(propsName, parentProperties);
        }
        Object[] propsArray = (Object[])this.metadata.get((Object)"properties");
        if (propsArray != null && propsArray.length > 0) {
            for (int i = 0; i < propsArray.length; ++i) {
                Map properties = (Map)propsArray[i];
                String propsName = (String)properties.get("name");
                mergedProps.put(propsName, properties);
            }
        }
        Object[] mergedPropsArray = mergedProps.values().toArray();
        if (!this.metadataCloned) {
            try {
                this.metadata = (AttributeCollection)this.metadata.clone();
                this.metadataCloned = true;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        this.metadata.put(Key.PROPERTIES, (Object)mergedPropsArray);
        this.readPropertiesFromParentClass(parentMetadata);
    }

    private AttributeCollection getParentMetadata(AttributeCollection metadata) {
        Object parentMetaDataObj = metadata.get((Object)EXTENDS);
        if (parentMetaDataObj == null) {
            return null;
        }
        if (parentMetaDataObj instanceof AttributeCollection) {
            return (AttributeCollection)parentMetaDataObj;
        }
        String parentCFCName = this.getQualifiedCFCName((String)parentMetaDataObj);
        try {
            TemplateProxy parentCFC = TemplateProxyFactory.createTemplateProxyForMetaData((String)parentCFCName, (NeoPageContext)FusionContext.getCurrent().pageContext, null);
            return (AttributeCollection)parentCFC.getRuntimeMetadata();
        }
        catch (Throwable th) {
            throw new CFCLoadException(th, RB.getString((Object)this, (String)"parentCFCLoadError", (Object)parentCFCName, (Object)this.cfcName));
        }
    }

    private String getQualifiedCFCName(String cfcName) {
        if (cfcName.indexOf(46) == -1 && this.cfcpackage != null) {
            cfcName = this.cfcpackage + "." + cfcName;
        }
        return cfcName;
    }

    private void readProperties(PersistentClass hibernatePersistentClass) {
        Object[] propsArray = (Object[])this.metadata.get((Object)"properties");
        HashSet<String> indentifierPropertySet = new HashSet<String>();
        KeyValue indentifierProperties = hibernatePersistentClass.getIdentifier();
        if (indentifierProperties instanceof Component) {
            Iterator indentifierIterator = ((Component)indentifierProperties).getPropertyIterator();
            while (indentifierIterator.hasNext()) {
                Property property = (Property)indentifierIterator.next();
                indentifierPropertySet.add(property.getName());
            }
        } else if (indentifierProperties instanceof SimpleValue) {
            String propName = hibernatePersistentClass.getIdentifierProperty().getName();
            indentifierPropertySet.add(propName);
        }
        for (Object o : propsArray) {
            Map prop = (Map)o;
            String indexableStr = (String)prop.get("indexable");
            String storeStr = (String)prop.get("indexstore");
            if (!this.getBooleanValue(indexableStr, false) && storeStr == null && !indentifierPropertySet.contains(prop.get("name"))) continue;
            this.buildProperty(prop, hibernatePersistentClass, indentifierPropertySet);
        }
    }

    private void buildProperty(Map<String, String> prop, PersistentClass hibernatePersistentClass, Set indentifierPropertySet) {
        String propName = prop.get("name");
        if (indentifierPropertySet.contains(propName)) {
            this.cfcSmd.addIndexableIDField(this.createIndexableIDField(prop));
        } else {
            Property property = hibernatePersistentClass.getProperty(propName);
            Value propertyValue = property.getValue();
            if (propertyValue instanceof ToOne) {
                if (this.hibernateConf != null) {
                    this.cfcSmd.addIndexableRelationField(this.createIndexableRelationField(prop, hibernatePersistentClass));
                }
            } else if (propertyValue instanceof SimpleValue) {
                IndexableField field = this.createIndexableField(prop);
                field.setType(propertyValue.getType().getName());
                this.cfcSmd.addIndexableField(field);
            }
        }
    }

    private IndexableField createIndexableField(Map<String, String> props) {
        String language;
        IndexableField field = new IndexableField();
        String name = props.get("name");
        field.setName(name);
        String fieldName = props.get("indexfieldname");
        if (fieldName == null || fieldName.length() == 0) {
            fieldName = name;
        }
        field.setIndexFieldName(fieldName);
        String indexTokenierStr = props.get("indextokenize");
        String type = props.get("ormType");
        boolean defaultValue = !DATE.equals(type);
        boolean tokenize = this.getBooleanValue(indexTokenierStr, defaultValue);
        if (DATE.equals(type) && tokenize) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidTokenizeForDate", (Object)tokenize, (Object)fieldName));
        }
        field.setIndextokenize(tokenize);
        String indexStore = props.get("indexstore");
        if (indexStore == null) {
            indexStore = "no";
        }
        if (!storeOptions.contains(indexStore = indexStore.toLowerCase())) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidStore", (Object)indexStore, (Object)fieldName));
        }
        field.setIndexStore(indexStore);
        String boost = props.get("indexboost");
        if (boost != null && boost.length() > 0) {
            try {
                float boostValue = Float.parseFloat(boost);
                field.setBoost(boostValue);
            }
            catch (RuntimeException ex) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidBoostForField", (Object)boost, (Object)fieldName));
            }
        }
        if ((language = props.get("indexlanguage")) != null && !language.equalsIgnoreCase(this.cfcSmd.getLanguage())) {
            field.setLanguage(language);
        }
        return field;
    }

    private IndexableField createIndexableIDField(Map<String, String> props) {
        String language;
        IndexableField field = new IndexableField();
        String name = props.get("name");
        field.setName(name);
        String fieldName = props.get("indexfieldname");
        if (fieldName == null || fieldName.length() == 0) {
            fieldName = name;
        }
        field.setIndexFieldName(name);
        String indexTokenierStr = props.get("indextokenize");
        String type = props.get("ormType");
        boolean defaultValue = !DATE.equals(type);
        boolean tokenize = this.getBooleanValue(indexTokenierStr, defaultValue);
        if (DATE.equals(type) && tokenize) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidTokenizeForDate", (Object)tokenize, (Object)fieldName));
        }
        field.setIndextokenize(tokenize);
        String indexStore = props.get("indexstore");
        if (indexStore == null) {
            indexStore = "yes";
        }
        if (!storeOptions.contains(indexStore = indexStore.toLowerCase())) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidStore", (Object)indexStore, (Object)name, (Object)this.cfcName));
        }
        if (indexStore.equals("no") || indexStore.equals("false")) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidStoreForPK", (Object)name, (Object)this.cfcName));
        }
        field.setIndexStore(indexStore);
        String boost = props.get("indexboost");
        if (boost != null && boost.length() > 0) {
            try {
                float boostValue = Float.parseFloat(boost);
                field.setBoost(boostValue);
            }
            catch (RuntimeException ex) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidBoostForField", (Object)boost, (Object)fieldName));
            }
        }
        if ((language = props.get("indexlanguage")) != null && !language.equalsIgnoreCase(this.cfcSmd.getLanguage())) {
            field.setLanguage(language);
        }
        return field;
    }

    private IndexableRelationField createIndexableRelationField(Map<String, String> props, PersistentClass hibernatePersistentClass) {
        AttributeCollection referredCFCMetadata;
        IndexableRelationField field = new IndexableRelationField();
        String name = props.get("name");
        field.setName(name);
        String fieldName = props.get("indexfieldname");
        if (fieldName == null || fieldName.length() == 0) {
            fieldName = name;
        }
        field.setIndexFieldName(fieldName);
        String indexTokenizerStr = props.get("indextokenize");
        if (this.getBooleanValue(indexTokenizerStr, false)) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidTokenizeForRelation", (Object)name, (Object)this.cfcName));
        }
        String indexStore = props.get("indexstore");
        if (indexStore != null && indexStore.length() > 0) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidStoreForRelation", (Object)name, (Object)this.cfcName));
        }
        String boost = props.get("indexboost");
        if (boost != null && boost.length() > 0) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidBoostForRelation", (Object)name, (Object)this.cfcName));
        }
        String language = props.get("indexlanguage");
        if (language != null && language.length() > 0) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidLanguageForRelation", (Object)name, (Object)this.cfcName));
        }
        String targetedCFCName = props.get("cfc");
        if (targetedCFCName == null || targetedCFCName.length() == 0) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidTargetedCFCNameForRelation", (Object)name, (Object)this.cfcName));
        }
        targetedCFCName = this.getQualifiedCFCName(targetedCFCName);
        try {
            TemplateProxy referredCFC = TemplateProxyFactory.createTemplateProxyForMetaData((String)targetedCFCName, (NeoPageContext)FusionContext.getCurrent().pageContext, null);
            referredCFCMetadata = (AttributeCollection)referredCFC.getRuntimeMetadata();
        }
        catch (Throwable th) {
            throw new CFCLoadException(th, RB.getString((Object)this, (String)"relationshipCFCLoadError", (Object)targetedCFCName, (Object)this.cfcName));
        }
        Property property = hibernatePersistentClass.getProperty(name);
        if (property != null) {
            String cfcName;
            Value propertyValue = property.getValue();
            if (propertyValue instanceof OneToOne) {
                cfcName = ((OneToOne)propertyValue).getReferencedEntityName();
                field.setTargetComponent(this.getQualifiedCFCName(cfcName));
                field.setRelationType(1);
            } else if (propertyValue instanceof ManyToOne) {
                cfcName = ((ManyToOne)propertyValue).getReferencedEntityName();
                field.setTargetComponent(this.getQualifiedCFCName(cfcName));
                field.setRelationType(3);
            }
            if (propertyValue instanceof OneToOne || propertyValue instanceof ManyToOne) {
                SearchPropertyBinder searchBinder = new SearchPropertyBinder(referredCFCMetadata, this.ormSettings, this.hibernateConf);
                CFCSearchMetadata searchMetadata = searchBinder.getCFCSearchMetadata();
                ORMSearchManager.getCurrentSearchFactory().addCFCSearchMetadataForReferredCFC(searchMetadata.getEntityName(), searchMetadata);
            }
        }
        return field;
    }

    private boolean getBooleanValue(String str, boolean defaultVal) {
        if (str == null) {
            return defaultVal;
        }
        return "true".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str);
    }

    static {
        storeOptions.add("no");
        storeOptions.add("yes");
        storeOptions.add("compressed");
        storeOptions.add("false");
        storeOptions.add("true");
    }

    public static class CFCLoadException
    extends ApplicationException {
        private String msg;

        public CFCLoadException(Throwable ex, String msg) {
            super(ex);
            this.msg = msg;
        }

        public String getMessage() {
            return this.msg;
        }

        public String getDetail() {
            return this.rootCause.getMessage();
        }
    }

    public static class AttributeValidationException
    extends RuntimeException {
        public AttributeValidationException(String message) {
            super(message);
        }
    }
}

