/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.report;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.report.CFExprEvaluator;
import coldfusion.runtime.report.CSSDocumentHandler;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.helpers.ParserFactory;

public class CFRptCompiler
implements JRCompiler {
    private static final CFRptCompiler instance = new CFRptCompiler();

    public static CFRptCompiler getInstance() {
        return instance;
    }

    @Override
    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        JasperReport jasperReport = null;
        this.parseStylesFromCSSFile(jasperDesign);
        Collection brokenRules = JRVerifier.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report design not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
        CompileData cd = new CompileData();
        cd.expressionCollector = null;
        cd.design = jasperDesign;
        jasperReport = new JasperReport(jasperDesign, this.getClass().getName(), cd, cd.expressionCollector);
        return jasperReport;
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return new CFExprEvaluator(jasperReport, FusionContext.getCurrent().pageContext);
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        return this.loadEvaluator(jasperReport);
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab crosstab) throws JRException {
        return this.loadEvaluator(jasperReport);
    }

    private void parseStylesFromCSSFile(JasperDesign jasperDesign) throws JRException {
        if (jasperDesign.getCSSStyles() != null) {
            try {
                InputSource is = new InputSource();
                StringReader r = new StringReader(jasperDesign.getCSSStyles());
                is.setCharacterStream((Reader)r);
                ParserFactory factory = new ParserFactory();
                Parser parser = factory.makeParser();
                parser.setDocumentHandler((DocumentHandler)new CSSDocumentHandler(jasperDesign));
                parser.parseStyleSheet(is);
                r.close();
            }
            catch (Exception e) {
                String msg = "ReportTag: error parsing CSS style for report";
                if (e.getLocalizedMessage() != null) {
                    msg = msg + ": " + e.getLocalizedMessage();
                }
                CFLogs.APPLICATION_LOG.warn((Object)msg, (Throwable)e);
            }
        }
    }

    static {
        System.setProperty("org.w3c.css.sac.parser", "org.apache.batik.css.parser.Parser");
    }

    class CompileData
    implements Serializable {
        JRExpressionCollector expressionCollector;
        JasperDesign design;

        CompileData() {
        }
    }
}

