/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.search;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ExtensionMatcher {
    private String[] extensions;
    private boolean bMatchNoExtension = false;
    private boolean bMatchAll = false;
    private static final String wildcardDot = "*.";
    private static final String dotWildcard = ".*";

    public ExtensionMatcher(String extensionString) {
        this(ExtensionMatcher.convertExtensions(extensionString));
    }

    public ExtensionMatcher(String[] extensions) {
        this.extensions = extensions;
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.extensions.length; ++i) {
            String ext = this.extensions[i];
            if (ext.equals(wildcardDot)) {
                this.bMatchNoExtension = true;
                continue;
            }
            if (!ext.equals(dotWildcard)) continue;
            this.bMatchAll = true;
        }
    }

    public void getFiles(List filelist, File dir, boolean recurse) {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                if (!recurse) continue;
                this.getFiles(filelist, list[i], recurse);
                continue;
            }
            boolean match = false;
            String fn = list[i].getName();
            if (this.bMatchAll) {
                match = true;
            } else if (this.bMatchNoExtension && fn.charAt(fn.length() - 1) == '.') {
                match = true;
            } else {
                int dot = fn.lastIndexOf(46);
                if (dot == -1) {
                    if (this.bMatchNoExtension) {
                        match = true;
                    }
                } else {
                    String ext = fn.substring(dot + 1);
                    for (int q = 0; !match && q < this.extensions.length; ++q) {
                        match = File.separatorChar == '\\' ? ext.equalsIgnoreCase(this.extensions[q]) : ext.equals(this.extensions[q]);
                    }
                }
            }
            if (!match) continue;
            filelist.add(list[i]);
        }
    }

    private static String[] convertExtensions(String ext) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(ext, ",");
        while (tok.hasMoreTokens()) {
            String e = tok.nextToken().trim();
            if (!dotWildcard.equals(e) && e.charAt(0) == '.') {
                list.add(e.substring(1));
                continue;
            }
            list.add(e);
        }
        String[] ret = new String[list.size()];
        return list.toArray(ret);
    }
}

