/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf.customfilters;

import com.adobe.internal.pdftoolkit.color.ColorSpaceCache;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomEncodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import com.adobe.internal.pdftoolkit.image.ImageInputSource;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ColorSpaceCacheImpl;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class DCTCustomEncodeFilter
implements CustomEncodeFilter {
    private boolean JPEGImageWriterExists() {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        return iter.hasNext();
    }

    public ASName getName() {
        return ASName.create((String)"DCTDecode");
    }

    public FilterParams updateFilterParams(FilterParams fParams) {
        return null;
    }

    public OutputStream encode(OutputStream dstStm, FilterParams filterParams) throws CustomFilterException {
        if (!this.JPEGImageWriterExists()) {
            throw new CustomFilterException("Encoding using DCT is not supported");
        }
        return new DCTDecodeOutputStream(dstStm, filterParams);
    }

    public class DCTDecodeOutputStream
    extends FilterOutputStream {
        OutputStream outStm;
        ByteArrayOutputStream dataToEncode;
        FilterParams filterParams;

        public DCTDecodeOutputStream(OutputStream out, FilterParams image) {
            super(out);
            this.dataToEncode = null;
            this.outStm = out;
            this.filterParams = image;
        }

        private void initialize() {
            if (this.dataToEncode == null) {
                this.dataToEncode = new ByteArrayOutputStream();
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.initialize();
            this.dataToEncode.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.initialize();
            this.dataToEncode.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.initialize();
            this.dataToEncode.write(b, off, len);
        }

        private void write() throws IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.dataToEncode == null || this.dataToEncode.size() == 0) {
                return;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(this.dataToEncode.toByteArray());
            this.dataToEncode.close();
            ARGBImage bImage = new ARGBImage((ImageInputSource)new ImageInputSourceImpl(stream), ((Integer)this.filterParams.get((Object)"Columns")).intValue(), ((Integer)this.filterParams.get((Object)"Rows")).intValue(), ((Integer)this.filterParams.get((Object)"BitsPerComponent")).intValue(), (ColorSpaceCache)ColorSpaceCacheImpl.newInstance((PDFColorSpace)PDFColorSpaceFactory.getInstance((CosObject)((CosObject)this.filterParams.get((Object)"ColorSpace"))), null, null));
            BufferedImage image = this.getCompleteBufImage(bImage, bImage.getWidth(), bImage.getHeight());
            bImage.close();
            ImageIO.write((RenderedImage)image, "jpeg", this.outStm);
        }

        private BufferedImage getCompleteBufImage(ARGBImage rgbImage, int width, int height) {
            BufferedImage bim = new BufferedImage(width, height, 1);
            Iterator itr = rgbImage.getBufferedImagesIterator();
            BufferedImage tile = null;
            int offset = 0;
            while (itr.hasNext()) {
                tile = (BufferedImage)itr.next();
                int length = tile.getWidth() * tile.getHeight();
                System.arraycopy(((DataBufferInt)tile.getRaster().getDataBuffer()).getData(), 0, ((DataBufferInt)bim.getRaster().getDataBuffer()).getData(), offset, length);
                offset += length;
            }
            return bim;
        }

        @Override
        public void flush() throws IOException {
            try {
                this.write();
            }
            catch (PDFInvalidDocumentException e) {
                throw new PDFRuntimeException((PDFException)((Object)e));
            }
            catch (PDFIOException e) {
                throw new PDFRuntimeException((PDFException)((Object)e));
            }
            catch (PDFSecurityException e) {
                throw new PDFRuntimeException((PDFException)((Object)e));
            }
        }
    }

    private static class ImageInputSourceImpl
    implements ImageInputSource {
        private InputStream is = null;

        private ImageInputSourceImpl(InputStream is) {
            this.is = is;
        }

        public InputStream getImageInputStream() throws IOException {
            return this.is;
        }

        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
        }
    }
}

