/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.document.CFDocument;
import coldfusion.document.pdf.core.PdfPermissions;
import coldfusion.document.webkit.core.DocumentProtectionException;
import coldfusion.document.webkit.core.DocumentSettingsWebkit;
import coldfusion.document.webkit.core.HeaderFooterObject;
import coldfusion.document.webkit.core.HtmlToPdfPageLayout;
import coldfusion.image.Image;
import coldfusion.log.CFLogs;
import coldfusion.osgi.services.PDFService;
import coldfusion.pdf.PDFDocHandler;
import coldfusion.pdf.PDFDocOperation;
import coldfusion.pdf.PDFDocWrapper;
import coldfusion.pdf.PDFFormCFDocProcessor;
import coldfusion.pdf.core.PDFException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import com.adobe.internal.ddxm.Executive;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.pdfm.util.FontSetBuilder;
import com.adobe.internal.pdftoolkit.core.cos.PDFCore;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSetManager;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.jsp.PageContext;

public class PDFServiceImpl
implements PDFService {
    public Object deepCopy(Object obj) {
        PDFDocWrapper source = (PDFDocWrapper)obj;
        return PDFDocWrapper.deepCopy(source, source.getPassword());
    }

    public Object writeDocument(String password, Object source, boolean b, boolean c) {
        PDFDocHandler docHandler = new PDFDocOperation().getPdfDocHandler();
        try {
            PDFDocument pdfDocument = docHandler.readInternal(password, source, b, c);
            return docHandler.writeDocument(pdfDocument, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (PDFException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object getAssemblerFontSet() {
        PDFFontSetManager x = new PDFFontSetManager();
        return FontSetBuilder.getPdfFontSet();
    }

    public boolean validateArchive(String value, String standard) {
        boolean b = false;
        b = PDFDocOperation.validateArchive(value, standard);
        return b;
    }

    public boolean validateDDX(String value, NeoPageContext pageContext) {
        boolean valid;
        try {
            PDFDocOperation.validateDDX(value, (PageContext)pageContext);
            valid = true;
        }
        catch (Exception pex) {
            valid = false;
        }
        return valid;
    }

    public boolean readFile(String fname) {
        return PDFDocHandler.readFile(fname);
    }

    public boolean isPDFObject(Object value) {
        return PDFDocHandler.isPDFObject(value);
    }

    public byte[] getSourceAsByte(Object binObj) {
        byte[] attachBin = null;
        PDFDocWrapper newDoc = PDFDocWrapper.deepCopy((PDFDocWrapper)binObj, null);
        try {
            attachBin = (byte[])new PDFDocOperation().getSourceAsByte(newDoc, newDoc.getPassword());
        }
        catch (PDFException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return attachBin;
    }

    public byte[] deepCopyByte(Object data) {
        return PDFDocWrapper.deepCopyByte((PDFDocWrapper)data, null);
    }

    public Struct getInfo(String canonicalPath, String string, boolean b) {
        PDFDocOperation pdfOperation = new PDFDocOperation();
        Struct info = pdfOperation.getInfo(canonicalPath, string, b);
        return info;
    }

    public String extractText(String canonicalPath, String s1, String s, String s2, boolean b, boolean c, boolean d, String s3) {
        PDFDocOperation pdfOperation = new PDFDocOperation();
        return pdfOperation.extractText(canonicalPath, s1, s, s2, b, c, d, s3);
    }

    public boolean isPDFCoreObject(Object source) {
        return source instanceof PDFDocWrapper || source instanceof PDFCore;
    }

    public void applyExtraAttributesForWebkit(DocumentSettingsWebkit settingsObj, ByteArrayOutputStream byteOut, boolean addWaterMark, String encryption, String ownerpassword, String permissions, String userpassword, Object waterMarkImageObj, boolean encryptionSet, HtmlToPdfPageLayout pagelayout, Object waterMarkImageObjOrig, String langauge) {
        PDFDocOperation pdfDocOperation = new PDFDocOperation();
        PDFDocHandler pdfDocHandler = pdfDocOperation.getPdfDocHandler();
        try {
            PDFDocument pdfDocument = PDFDocument.newInstance((ByteReader)new InputStreamByteReader((InputStream)new ByteArrayInputStream(byteOut.toByteArray())), (PDFOpenOptions)PDFOpenOptions.newInstance());
            PDFSaveFullOptions saveFullOptions = PDFSaveFullOptions.newInstance();
            pdfDocHandler.setPropertiesFor508Compliance(pdfDocument, langauge);
            if (settingsObj != null) {
                this.addHeaderFooter(settingsObj, pdfDocHandler, pdfDocument);
            }
            if (addWaterMark) {
                this.addWatermark(pdfDocHandler, pdfDocument, (Image)waterMarkImageObj, pagelayout, (Image)waterMarkImageObjOrig);
            }
            if (encryption != null && encryption.length() > 0 || ownerpassword != null && ownerpassword.length() > 0 || userpassword != null && userpassword.length() > 0 || permissions != null && permissions.length() > 0) {
                saveFullOptions = this.addProtectionAttributes(pdfDocHandler, pdfDocument, saveFullOptions, permissions, userpassword, ownerpassword, encryption, encryptionSet);
            }
            this.savePDFDocumentObj(pdfDocHandler, pdfDocument, saveFullOptions, byteOut);
        }
        catch (PDFInvalidDocumentException e) {
            throw new DocumentProtectionException((Throwable)e);
        }
        catch (PDFIOException e) {
            throw new DocumentProtectionException((Throwable)e);
        }
        catch (PDFSecurityException e) {
            throw new DocumentProtectionException((Throwable)e);
        }
        catch (IOException e) {
            throw new DocumentProtectionException((Throwable)e);
        }
        catch (PDFException e) {
            throw new DocumentProtectionException((Throwable)e);
        }
    }

    private void savePDFDocumentObj(PDFDocHandler pdfDocHandler, PDFDocument pdfDocument, PDFSaveFullOptions saveFullOptions, ByteArrayOutputStream byteOut) throws IOException, PDFException {
        byte[] savedBytes = pdfDocHandler.writeDocument(pdfDocument, (PDFSaveOptions)saveFullOptions);
        byteOut.reset();
        byteOut.write(savedBytes);
    }

    private void addHeaderFooter(DocumentSettingsWebkit settingsObj, PDFDocHandler pdfDocHandler, PDFDocument pdfDocument) {
        try {
            HeaderFooterObject headerObj = settingsObj.getHeader();
            HeaderFooterObject footerObj = settingsObj.getFooter();
            if (headerObj != null) {
                pdfDocHandler.addHFForDocument(pdfDocument, headerObj.getOpacity(), headerObj.isShowOnPrint(), headerObj.getContentProvider(), (Image)headerObj.getImage(), "ADDHEADER", headerObj.getNumberFormat(), headerObj.getAlign(), headerObj.getLeftMargin(), headerObj.getRightMargin(), headerObj.getTopMargin());
            }
            if (footerObj != null) {
                pdfDocHandler.addHFForDocument(pdfDocument, footerObj.getOpacity(), footerObj.isShowOnPrint(), footerObj.getContentProvider(), (Image)footerObj.getImage(), "ADDFOOTER", footerObj.getNumberFormat(), footerObj.getAlign(), footerObj.getLeftMargin(), footerObj.getRightMargin(), footerObj.getBottomMargin());
            }
        }
        catch (PDFException e) {
            throw new PDFException.DocumentHeaderFooterException((Throwable)e);
        }
    }

    private void addWatermark(PDFDocHandler pdfDocHandler, PDFDocument pdfDocument, Image waterMarkImageObj, HtmlToPdfPageLayout pagelayout, Image waterMarkImageObjOrig) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (waterMarkImageObj == null) {
            throw new PDFException.HtmlToPdfInvalidWaterMarkFileException();
        }
        try {
            int[] a = new int[]{0, 0};
            if (pagelayout.getPagewidth() != 8.5 || pagelayout.getPageheight() != 11.0) {
                Image image = new Image(waterMarkImageObjOrig);
                image.resize(String.valueOf(pagelayout.getPagewidth() * 72.0), String.valueOf(pagelayout.getPageheight() * 72.0), "highestPerformance");
                pdfDocHandler.addBackgroundForDocument(pdfDocument, image, true, 7, a, 0, true);
            } else {
                pdfDocHandler.addBackgroundForDocument(pdfDocument, waterMarkImageObj, true, 7, a, 0, true);
            }
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
    }

    private PDFSaveFullOptions addProtectionAttributes(PDFDocHandler pdfDocHandler, PDFDocument pdfDocument, PDFSaveFullOptions saveFullOptions, String permissions, String userpassword, String ownerpassword, String encryption, boolean encryptionSet) throws PDFException, UnsupportedEncodingException {
        SecurityLock securityLock;
        if (ownerpassword == null) {
            ownerpassword = String.valueOf(System.currentTimeMillis());
        }
        if ((permissions == null || permissions != null && permissions.length() == 0) && encryptionSet && encryption != null && encryption.length() > 0) {
            permissions = "None";
        }
        if ((securityLock = pdfDocHandler.getPdfDocSecurityHandler().encrypt(pdfDocument, ownerpassword, userpassword, encryption, permissions, true)) != null) {
            saveFullOptions = PDFSaveFullOptions.newInstance((SecurityLock)securityLock);
        }
        return saveFullOptions;
    }

    public byte[] mergePDF(byte[] byteArray, Object o, String encryption, String ownerpassword, String userpassword, PdfPermissions pdfPermissions) {
        return ((PDFFormCFDocProcessor)o).mergePDF(byteArray, encryption, ownerpassword, userpassword, pdfPermissions);
    }

    public int getNumPagesInPDFForm(Object o) {
        return ((PDFFormCFDocProcessor)o).getNumPagesInPDFForm();
    }

    public Object getPDFFormCFDocProcessor(Object document) {
        ServiceFactory.getDocumentService((boolean)true);
        return new PDFFormCFDocProcessor((CFDocument)document);
    }

    public void initFonts(LinkedList l1, List o, LinkedList l2) {
        Executive.initFonts((List)l1, (List)o, (List)l2);
    }
}

