/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.retry.backoff;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;

@FunctionalInterface
@SdkPublicApi
public interface BackoffStrategy {
    public Duration computeDelayBeforeNextRetry(RetryPolicyContext var1);

    default public int calculateExponentialDelay(int retriesAttempted, Duration baseDelay, Duration maxBackoffTime) {
        return (int)Math.min((1L << retriesAttempted) * baseDelay.toMillis(), maxBackoffTime.toMillis());
    }

    public static BackoffStrategy defaultStrategy() {
        return FullJitterBackoffStrategy.builder().baseDelay(SdkDefaultRetrySetting.BASE_DELAY).maxBackoffTime(SdkDefaultRetrySetting.MAX_BACKOFF).build();
    }

    public static BackoffStrategy defaultThrottlingStrategy() {
        return EqualJitterBackoffStrategy.builder().baseDelay(SdkDefaultRetrySetting.THROTTLED_BASE_DELAY).maxBackoffTime(SdkDefaultRetrySetting.MAX_BACKOFF).build();
    }

    public static BackoffStrategy none() {
        return FixedDelayBackoffStrategy.create(Duration.ofMillis(1L));
    }
}

