/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.endpointdiscovery.providers;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.endpointdiscovery.providers.EndpointDiscoveryProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.utils.ToString;

@SdkInternalApi
public class ProfileEndpointDiscoveryProvider
implements EndpointDiscoveryProvider {
    private final String profileName = ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();

    private ProfileEndpointDiscoveryProvider() {
    }

    public static ProfileEndpointDiscoveryProvider create() {
        return new ProfileEndpointDiscoveryProvider();
    }

    @Override
    public boolean resolveEndpointDiscovery() {
        return ProfileFile.defaultProfileFile().profile(this.profileName).map(p -> (String)p.properties().get("aws_endpoint_discovery_enabled")).map(Boolean::parseBoolean).orElseThrow(() -> SdkClientException.builder().message("No endpoint discovery setting provided in profile: " + this.profileName).build());
    }

    public String toString() {
        return ToString.create((String)"ProfileEndpointDiscoveryProvider");
    }
}

