/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml.idp;

import coldfusion.log.CFLogs;
import coldfusion.saml.IdpConfiguration;
import coldfusion.saml.SAMLServiceImpl;
import coldfusion.saml.idp.AbstractMetadataProvider;
import coldfusion.saml.idp.MetadataProvider;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.RB;
import com.onelogin.saml2.settings.IdPMetadataParser;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import com.onelogin.saml2.util.Util;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class FileMetadataProvider
extends AbstractMetadataProvider
implements MetadataProvider {
    public FileMetadataProvider(IdpConfiguration config) {
        super(config);
    }

    @Override
    public Saml2Settings provide() {
        double currentTime = System.currentTimeMillis();
        if (!this.isValid(this.idpConfiguration.getRefreshInterval())) {
            try {
                Document xmlDocument = Util.parseXML((InputSource)new InputSource(new StringReader(FileUtils.readFile((String)this.idpConfiguration.getMetadataFilePath(), null))));
                this.samlSettings = new SettingsBuilder().fromValues(IdPMetadataParser.parseXML((Document)xmlDocument)).build();
                super.setLastUpdated(currentTime);
            }
            catch (ParserConfigurationException e) {
                if (this.samlSettings != null) {
                    CFLogs.APPLICATION_LOG.warn((Object)RB.getString(SAMLServiceImpl.class, (String)"FileMetadataFetchError", (Object)this.idpConfiguration.getMetadataFilePath()));
                }
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"ParserConfigError"));
            }
            catch (Exception e) {
                if (this.samlSettings != null) {
                    CFLogs.APPLICATION_LOG.warn((Object)RB.getString(SAMLServiceImpl.class, (String)"FileMetadataFetchError", (Object)this.idpConfiguration.getMetadataFilePath()));
                }
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"ParsingError"));
            }
        }
        super.setLastFetched(currentTime);
        return this.samlSettings;
    }
}

