/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import macromedia.sequelink.util.UtilMessage;

public class UnicodeStreamToReader
extends Reader {
    private InputStream in;

    public UnicodeStreamToReader(InputStream inputStream) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException(UtilMessage.Gen.getPrefixedMessage("err.stream.null"));
        }
        this.in = inputStream;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.stream.closed"));
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.ensureOpen();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n3 == -1 || n4 == -1) {
            return -1;
        }
        int n5 = n;
        cArray[n5] = (char)(n3 * 256 + n4);
        ++n5;
        int n6 = n + n2;
        while (n5 < n6 && (n3 = this.in.read()) != -1 && (n4 = this.in.read()) != -1) {
            cArray[n5] = (char)(n3 * 256 + n4);
            ++n5;
        }
        return n5 - n;
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
    }
}

