/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.OutputStream;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.net.SPDU;
import macromedia.sequelink.net.SPDUConnectEncoder;

public class SPDUConnect
extends SPDU {
    private static final int kMAX_USERDATA = 512;
    private int fuReq;
    private int protocolOptions;
    private byte[] callingSelector;
    private byte[] calledSelector;
    private int maxSendTduSize;
    private int maxRecvTduSize;
    private int userDataLen;

    SPDUConnect(int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, int n5) throws NetworkException {
        super(1);
        this.validateSelector(byArray);
        this.validateSelector(byArray2);
        this.validateUserDataLen(n5);
        this.fuReq = n;
        this.protocolOptions = n2;
        this.callingSelector = byArray;
        this.calledSelector = byArray2;
        this.maxSendTduSize = n3;
        this.maxRecvTduSize = n4;
        this.userDataLen = n5;
    }

    private void validateUserDataLen(int n) throws NetworkException {
        if (n < 0 || n > 512) {
            throw SPDUConnect.getException(7576);
        }
    }

    public int getFuReq() {
        return this.fuReq;
    }

    public int getProtocolOptions() {
        return this.protocolOptions;
    }

    public byte[] getCalledSelector() {
        return this.calledSelector;
    }

    public byte[] getCallingSelector() {
        return this.callingSelector;
    }

    public int getMaxSendTduSize() {
        return this.maxSendTduSize;
    }

    public int getMaxRecvTduSize() {
        return this.maxRecvTduSize;
    }

    public int getUserDataLen() {
        return this.userDataLen;
    }

    public int encode(OutputStream outputStream) throws NetworkException {
        SPDUConnectEncoder sPDUConnectEncoder = new SPDUConnectEncoder(outputStream, this);
        return sPDUConnectEncoder.size();
    }
}

