/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import macromedia.jdbc.sequelink.Result;
import macromedia.jdbc.sequelink.SequeLinkImplConnection;
import macromedia.jdbc.sequelink.SequeLinkImplResultSet;
import macromedia.jdbc.sequelink.columns.SequeLinkBigintColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkBinaryColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkBitColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkBlobColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkCharColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkClobColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import macromedia.jdbc.sequelink.columns.SequeLinkColumns;
import macromedia.jdbc.sequelink.columns.SequeLinkDatatypeColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkDateColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkDoubleColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkIntegerColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkLongvarbinaryColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkLongvarcharColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkNumericColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkPseudoColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkRealColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkTimeColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkTimestampColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkVarbinaryColumn;
import macromedia.jdbc.sequelink.columns.SequeLinkVarcharColumn;
import macromedia.jdbc.sequelink.parameters.SequeLinkBigintParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkBitParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkBlobParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkClobParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkDateParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkDoubleParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkIntegerParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkLongvarbinaryParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkLongvarcharParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkNumericParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkParamDescribe;
import macromedia.jdbc.sequelink.parameters.SequeLinkParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkParameters;
import macromedia.jdbc.sequelink.parameters.SequeLinkRealParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkStreamParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkTimeParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkTimestampParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkVarbinaryParameter;
import macromedia.jdbc.sequelink.parameters.SequeLinkVarcharParameter;
import macromedia.jdbc.slbase.BaseColumns;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseImplResultSet;
import macromedia.jdbc.slbase.BaseImplResultSetClientSideEmpty;
import macromedia.jdbc.slbase.BaseImplStatement;
import macromedia.jdbc.slbase.BaseParameter;
import macromedia.jdbc.slbase.BaseParameterInfo;
import macromedia.jdbc.slbase.BaseParameters;
import macromedia.jdbc.slbase.BaseSQL;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.describe.VariableDescriptor;
import macromedia.sequelink.ssp.Diagnostic;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.util.UnSyncVector;

public final class SequeLinkImplStatement
extends BaseImplStatement {
    private SequeLinkImplConnection implCon;
    private StatementContext stmtCtxt;
    private DiagnosticList diagnosticList;
    private boolean prepared;
    private boolean sqlChanged;
    private boolean columnsAreBound;
    private boolean parametersAreBound;
    private SequeLinkColumns cursorVariables;
    private SequeLinkParameters parameterVariables;
    private int rowsInBatch;
    private int fetchFlag;
    private int fetchedFromBatch;
    private int fetchedFromCursor;
    private boolean multipleResults;
    private int rsn;
    private int[] updateCounts;
    private String rowid;
    private int myMaxRows;
    private boolean supportsCatalogs;
    private Result result;
    private boolean allowBlockFetch;
    private boolean MSSMapLongToDecimal;
    private boolean ORANumber0IsNumeric;
    private int serverVersion;
    private boolean alreadyClosed;
    private boolean prefetched;
    private boolean allowPrefetch;
    private String defaultParameterEncoding;
    private int lastAccessedColumn;
    private boolean isBadDescribeParam54;

    SequeLinkImplStatement(SequeLinkImplConnection sequeLinkImplConnection) {
        this.implCon = sequeLinkImplConnection;
        this.stmtCtxt = new StatementContext(sequeLinkImplConnection.conCtxt);
        this.diagnosticList = new DiagnosticList();
        this.allowBlockFetch = sequeLinkImplConnection.conCtxt.allowBlockFetch();
        this.MSSMapLongToDecimal = sequeLinkImplConnection.conCtxt.MSSMapLongToDecimal();
        this.ORANumber0IsNumeric = sequeLinkImplConnection.conCtxt.ORANumber0IsNumeric();
        this.serverVersion = sequeLinkImplConnection.conCtxt.getServerVersion();
        this.rowid = this._getRowIdColumnName();
        this.allowPrefetch = sequeLinkImplConnection.conCtxt.allowPrefetch();
        this.allowPrefetch &= this.allowBlockFetch;
        try {
            DiagnosticList diagnosticList = DiagnosticList.GetADummyList();
            this.defaultParameterEncoding = sequeLinkImplConnection.conCtxt.getDefaultParameterEncoding(diagnosticList);
            this.supportsCatalogs = sequeLinkImplConnection.conCtxt.supportsCatalogs(diagnosticList);
        }
        catch (SQLException sQLException) {
            this.defaultParameterEncoding = "";
            this.supportsCatalogs = true;
        }
        this.isBadDescribeParam54 = sequeLinkImplConnection.conCtxt.WABadDescribeParam54();
    }

    SequeLinkImplConnection getImplConnection() {
        return this.implCon;
    }

    public void close() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        this.stmtCtxt.deactivate(this.diagnosticList);
        this.addWarnings();
        if (this.cursorVariables != null) {
            this.cursorVariables.cleanUp();
            this.cursorVariables = null;
        }
        this.parameterVariables = null;
        this.updateCounts = null;
        this.diagnosticList = null;
        this.implCon = null;
        this.stmtCtxt = null;
        this.alreadyClosed = true;
    }

    private void addWarnings() {
        SQLWarning sQLWarning = this.diagnosticList.getSQLWarning();
        if (sQLWarning != null) {
            String[] stringArray = new String[]{sQLWarning.getMessage()};
            do {
                this.warnings.add(6001, stringArray, sQLWarning.getSQLState(), sQLWarning.getErrorCode());
            } while ((sQLWarning = sQLWarning.getNextWarning()) != null);
            this.diagnosticList.clear();
        }
    }

    public BaseImplResultSet getNextResultSet() throws SQLException {
        if (this.rsn == 999) {
            return new BaseImplResultSetClientSideEmpty();
        }
        this.myMaxRows = this.maxRows;
        return new SequeLinkImplResultSet(this);
    }

    private void nextResult() throws SQLException {
        this.stmtCtxt.nextResult(this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
        this.addWarnings();
        this.rowsInBatch = 0;
        this.fetchedFromBatch = 0;
        this.result.setResult(this.stmtCtxt.getResultType(), this.stmtCtxt.getRowCount());
        this.fetchFlag = this.result.isResultSet() ? 1 : 0;
        if (!this.result.isEnd()) {
            this.multipleResults = true;
        }
    }

    void closeCursor() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        if (this.alreadyClosed) {
            return;
        }
        if (this.databaseMetaDataResultSet != 0) {
            return;
        }
        this.stmtCtxt.nextResult(this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
        this.addWarnings();
        this.result.setResult(this.stmtCtxt.getResultType(), this.stmtCtxt.getRowCount());
        this.rowsInBatch = 0;
        this.fetchedFromBatch = 0;
        this.fetchFlag = this.result.isResultSet() ? 1 : 0;
        if (!this.result.isEnd()) {
            this.multipleResults = true;
            if (this.result.isResultSet()) {
                this.invalidateCursorVariables();
            }
        }
    }

    public int getNextResultType() throws SQLException {
        int n = this.result.getNextResultType();
        if (n == 104) {
            this.nextResult();
            n = this.result.getNextResultType();
        }
        switch (n) {
            case 100: {
                return 3;
            }
            case 101: {
                return 2;
            }
            case 102: {
                return 0;
            }
            case 103: {
                return 1;
            }
        }
        throw new InternalError(this.getClass().getName() + " getNextResultType");
    }

    public int getNextRowsAffectedCount() throws SQLException {
        return this.result.getRowCount();
    }

    private int mapDatabaseMetaDataResultSetToRsn() {
        switch (this.databaseMetaDataResultSet) {
            case 1: {
                return 103;
            }
            case 2: {
                return 107;
            }
            case 3: {
                return 116;
            }
            case 4: {
                return 106;
            }
            case 5: {
                return 101;
            }
            case 6: {
                return 102;
            }
            case 7: {
                return 110;
            }
            case 8: {
                if (!this.supportsCatalogs) {
                    return 999;
                }
                return 105;
            }
            case 9: {
                return 108;
            }
            case 10: {
                return 115;
            }
            case 11: {
                return 114;
            }
            case 12: {
                return 113;
            }
            case 13: {
                return 117;
            }
            case 14: {
                return 112;
            }
            case 15: {
                if (this.serverVersion < 0x5030000) {
                    return 104;
                }
                return 118;
            }
            case 16: {
                return 109;
            }
            case 18: {
                return 111;
            }
        }
        return 999;
    }

    private void invalidateCursorVariables() throws SQLException {
        if (this.columnsAreBound) {
            this.stmtCtxt.freeVariables(1, this.diagnosticList);
            this.cursorVariables.cleanUp();
            this.cursorVariables = null;
            this.columnsAreBound = false;
        }
    }

    private void invalidateParameterVariables() throws SQLException {
        if (this.parametersAreBound) {
            if (this.parameterVariables != null && this.parameterVariables.containsNormalParameters()) {
                this.stmtCtxt.freeVariables(2, this.diagnosticList);
            }
            this.parameterVariables = null;
            this.parametersAreBound = false;
        }
    }

    protected void setSQL(BaseSQL baseSQL) throws SQLException {
        super.setSQL(baseSQL);
        this.sqlChanged = true;
    }

    public void prepare() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        this.updateCounts = null;
        if (this.sqlChanged) {
            this.invalidateCursorVariables();
            this.invalidateParameterVariables();
        } else if (this.columnsAreBound || this.parametersAreBound) {
            throw new InternalError("not expected: sqlChanged == false, columnsAreBound == " + this.columnsAreBound + ", parametersAreBound == " + this.parametersAreBound);
        }
        boolean bl = this.sql.getParameterCount() != 0;
        this.stmtCtxt.associate(this.sql.getFormatted(), bl, this.diagnosticList);
        this.addWarnings();
        this.prepared = true;
        this.sqlChanged = false;
    }

    public void execute() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        this.updateCounts = null;
        if (this.multipleResults) {
            this.invalidateCursorVariables();
            this.multipleResults = false;
        }
        if (this.databaseMetaDataResultSet != 0) {
            this.rsn = this.mapDatabaseMetaDataResultSetToRsn();
        }
        if (!this.parametersAreBound) {
            this.bindParameters();
            this.parametersAreBound = true;
        }
        this.bindParameterData();
        if (this.databaseMetaDataResultSet == 0) {
            if (!this.prepared) {
                this.invalidateCursorVariables();
                this.stmtCtxt.execDirect(this.sql.getFormatted(), this.sql.resultType(), this.parameterVariables.getNormalInputParams(), this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
            } else if (this.sqlChanged) {
                this.invalidateCursorVariables();
                boolean bl = this.sql.getParameterCount() != 0;
                this.stmtCtxt.prepareAndExecute(this.sql.getFormatted(), this.sql.resultType(), bl, this.parameterVariables.getNormalInputParams(), this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
                this.sqlChanged = false;
            } else {
                this.stmtCtxt.execute(this.sql.resultType(), this.parameterVariables.getNormalInputParams(), this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
            }
        } else {
            this.stmtCtxt.execRsn(this.rsn, this.parameterVariables.getNormalInputParams(), this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
        }
        this.addWarnings();
        this.result = new Result();
        this.result.setResult(this.stmtCtxt.getResultType(), this.stmtCtxt.getRowCount());
        this.rowsInBatch = 0;
        this.fetchedFromBatch = 0;
        this.fetchedFromCursor = 0;
        this.fetchFlag = 1;
    }

    public void executeBatch() throws BatchUpdateException {
        try {
            this.updateCounts = null;
            if (this.sql.isBatch()) {
                UnSyncVector unSyncVector = new UnSyncVector();
                int n = this.sql.batchSize();
                for (int i = 0; i < n; ++i) {
                    this.sql.nextBatchStatement();
                    unSyncVector.addElement(this.sql.getFormatted());
                }
                this.updateCounts = this.implCon.executeBatch(unSyncVector, this.diagnosticList);
            } else {
                if (!this.parametersAreBound) {
                    this.bindParameters();
                    this.parametersAreBound = true;
                }
                int n = this.bindParameterData();
                this.updateCounts = this.stmtCtxt.executeBatch(n, this.parameterVariables.getNormalInputParams(), this.diagnosticList);
            }
            this.addWarnings();
            this.result = new Result();
            this.result.setResult(0, -1);
            this.rowsInBatch = 0;
            this.fetchedFromBatch = 0;
            this.fetchedFromCursor = 0;
            this.fetchFlag = 1;
        }
        catch (BatchUpdateException batchUpdateException) {
            throw batchUpdateException;
        }
        catch (SQLException sQLException) {
            if (this.updateCounts == null) {
                this.updateCounts = new int[0];
            }
            BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), this.updateCounts);
            batchUpdateException.setNextException(sQLException.getNextException());
            throw batchUpdateException;
        }
    }

    public void reset() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        this.updateCounts = null;
        this.result = null;
        this.diagnosticList.clear();
        this.rowsInBatch = 0;
        this.fetchFlag = 0;
        this.fetchedFromBatch = 0;
        this.fetchedFromCursor = 0;
        this.myMaxRows = 0;
    }

    private SequeLinkColumn makeColumn(SequeLinkColumnDescribe sequeLinkColumnDescribe, boolean bl, boolean bl2) throws SQLException {
        int n = sequeLinkColumnDescribe.getType();
        switch (n) {
            case 12: {
                if (this.databaseMetaDataResultSet == 0) {
                    return new SequeLinkVarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                }
                return new SequeLinkVarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize, bl2);
            }
            case 1: {
                return new SequeLinkCharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -1: {
                if (this.maxFieldSize > 0 && this.maxFieldSize <= 4096) {
                    SequeLinkVarcharColumn sequeLinkVarcharColumn = new SequeLinkVarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                    sequeLinkVarcharColumn.setType(-1);
                    return sequeLinkVarcharColumn;
                }
                int n2 = sequeLinkColumnDescribe.getPrecision();
                if (n2 <= 4096) {
                    SequeLinkVarcharColumn sequeLinkVarcharColumn = new SequeLinkVarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                    sequeLinkVarcharColumn.setType(-1);
                    return sequeLinkVarcharColumn;
                }
                return new SequeLinkLongvarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe);
            }
            case -3: {
                return new SequeLinkVarbinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -2: {
                return new SequeLinkBinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -4: {
                if (this.maxFieldSize > 0 && this.maxFieldSize <= 4096) {
                    SequeLinkVarbinaryColumn sequeLinkVarbinaryColumn = new SequeLinkVarbinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                    sequeLinkVarbinaryColumn.setType(-4);
                    return sequeLinkVarbinaryColumn;
                }
                int n3 = sequeLinkColumnDescribe.getPrecision();
                if (n3 <= 4096) {
                    SequeLinkVarbinaryColumn sequeLinkVarbinaryColumn = new SequeLinkVarbinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                    sequeLinkVarbinaryColumn.setType(-4);
                    return sequeLinkVarbinaryColumn;
                }
                return new SequeLinkLongvarbinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe);
            }
            case 2: 
            case 3: {
                SequeLinkNumericColumn sequeLinkNumericColumn = new SequeLinkNumericColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                if (n != 2) {
                    sequeLinkNumericColumn.setType(n);
                }
                return sequeLinkNumericColumn;
            }
            case -5: {
                return new SequeLinkBigintColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -7: {
                return new SequeLinkBitColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -6: 
            case 4: 
            case 5: {
                SequeLinkIntegerColumn sequeLinkIntegerColumn = bl ? new SequeLinkDatatypeColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize) : new SequeLinkIntegerColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                if (n != 4) {
                    sequeLinkIntegerColumn.setType(n);
                }
                return sequeLinkIntegerColumn;
            }
            case 7: {
                return new SequeLinkRealColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case 6: 
            case 8: {
                SequeLinkDoubleColumn sequeLinkDoubleColumn = new SequeLinkDoubleColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                if (n != 8) {
                    sequeLinkDoubleColumn.setType(n);
                }
                return sequeLinkDoubleColumn;
            }
            case 91: {
                return new SequeLinkDateColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case 92: {
                return new SequeLinkTimeColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case 93: {
                return new SequeLinkTimestampColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case 2004: {
                return new SequeLinkBlobColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.implCon);
            }
            case 2005: {
                return new SequeLinkClobColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.implCon);
            }
        }
        throw Diagnostic.ClientCoreError(7369);
    }

    private SequeLinkParameter makeParameter(int n, int n2, int n3, int n4) throws SQLException {
        switch (n2) {
            case 1: 
            case 12: {
                SequeLinkVarcharParameter sequeLinkVarcharParameter = new SequeLinkVarcharParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
                if (n2 != 12) {
                    sequeLinkVarcharParameter.setType(n2);
                }
                return sequeLinkVarcharParameter;
            }
            case -1: {
                return new SequeLinkLongvarcharParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
            case -3: 
            case -2: {
                SequeLinkVarbinaryParameter sequeLinkVarbinaryParameter = new SequeLinkVarbinaryParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
                if (n2 != -3) {
                    sequeLinkVarbinaryParameter.setType(n2);
                }
                return sequeLinkVarbinaryParameter;
            }
            case -4: {
                return new SequeLinkLongvarbinaryParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
            case 2: 
            case 3: {
                SequeLinkNumericParameter sequeLinkNumericParameter = new SequeLinkNumericParameter(this.stmtCtxt, n, n3, n4, this.implCon.exceptions);
                if (n2 != 2) {
                    sequeLinkNumericParameter.setType(n2);
                }
                return sequeLinkNumericParameter;
            }
            case -5: {
                if (this.MSSMapLongToDecimal) {
                    SequeLinkNumericParameter sequeLinkNumericParameter = new SequeLinkNumericParameter(this.stmtCtxt, n, 0, n4, this.implCon.exceptions);
                    sequeLinkNumericParameter.setType(3);
                    return sequeLinkNumericParameter;
                }
                return new SequeLinkBigintParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
            case -7: {
                return new SequeLinkBitParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
            case -6: 
            case 4: 
            case 5: {
                SequeLinkIntegerParameter sequeLinkIntegerParameter = new SequeLinkIntegerParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
                if (n2 != 4) {
                    sequeLinkIntegerParameter.setType(n2);
                }
                return sequeLinkIntegerParameter;
            }
            case 7: {
                return new SequeLinkRealParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
            case 6: 
            case 8: {
                SequeLinkDoubleParameter sequeLinkDoubleParameter = new SequeLinkDoubleParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
                if (n2 != 8) {
                    sequeLinkDoubleParameter.setType(n2);
                }
                return sequeLinkDoubleParameter;
            }
            case 91: {
                return new SequeLinkDateParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
            case 92: {
                return new SequeLinkTimeParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
            case 93: {
                return new SequeLinkTimestampParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
            case 2004: {
                if (this.implCon.supportsLobsNatively()) {
                    return new SequeLinkBlobParameter(this.stmtCtxt, n, n4, this.implCon.exceptions, this.implCon);
                }
                return new SequeLinkLongvarbinaryParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
            case 2005: {
                if (this.implCon.supportsLobsNatively()) {
                    return new SequeLinkClobParameter(this.stmtCtxt, n, n4, this.implCon.exceptions, this.implCon);
                }
                return new SequeLinkLongvarcharParameter(this.stmtCtxt, n, n4, this.implCon.exceptions);
            }
        }
        throw Diagnostic.ClientCoreError(7369);
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        if (this.cursorVariables != null) {
            this.cursorVariables.cleanUp();
        }
        this.cursorVariables = new SequeLinkColumns();
        if (baseColumns == null) {
            VariableDescriptor[][] variableDescriptorArray = this.stmtCtxt.getDescribeCursor(this.diagnosticList);
            if (variableDescriptorArray == null) {
                return null;
            }
            int n = variableDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = i + 1;
                SequeLinkColumnDescribe sequeLinkColumnDescribe = new SequeLinkColumnDescribe(this.implCon, variableDescriptorArray[n2 - 1], n2, this.ORANumber0IsNumeric);
                SequeLinkColumn sequeLinkColumn = this.makeColumn(sequeLinkColumnDescribe, false, false);
                this.cursorVariables.add(sequeLinkColumn);
            }
        } else {
            int n;
            int n3;
            int n4 = this.databaseMetaDataResultSet == 7 ? 8 : (this.databaseMetaDataResultSet == 18 ? 8 : (this.databaseMetaDataResultSet == 13 ? 13 : baseColumns.count(0)));
            int n5 = n4;
            if (this.databaseMetaDataResultSet == 15) {
                if (this.rsn == 104) {
                    n5 = 1;
                }
            } else if (this.databaseMetaDataResultSet == 2) {
                n5 = 18;
            } else if (this.databaseMetaDataResultSet == 1) {
                n5 = 5;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                n = n3 + 1;
                boolean bl = false;
                boolean bl2 = false;
                switch (this.databaseMetaDataResultSet) {
                    case 7: {
                        bl2 = n == 3;
                        break;
                    }
                    case 9: {
                        bl = n <= 4;
                        bl |= n == 8;
                        break;
                    }
                    case 2: {
                        bl = n <= 3;
                        bl |= n == 18;
                        bl2 = n == 5;
                        break;
                    }
                    case 10: {
                        bl = n >= 1 && n <= 8;
                        break;
                    }
                    case 11: {
                        bl = n >= 1 && n <= 8;
                        break;
                    }
                    case 12: {
                        bl = n >= 1 && n <= 8;
                        break;
                    }
                    case 13: {
                        bl = n <= 3;
                        bl |= n == 5;
                        bl |= n == 10;
                        break;
                    }
                    case 14: {
                        bl = n <= 3;
                        break;
                    }
                    case 6: {
                        bl = n <= 3;
                        bl2 = n == 6;
                        break;
                    }
                    case 5: {
                        bl = n <= 2;
                        break;
                    }
                    case 16: {
                        bl = n <= 3 || n == 6;
                        break;
                    }
                    case 1: {
                        bl = n <= 2;
                        bl |= n == 4;
                        break;
                    }
                    case 17: {
                        bl = n <= 3;
                        bl2 = n == 5;
                        break;
                    }
                    case 18: {
                        bl2 = n == 3;
                    }
                }
                SequeLinkColumnDescribe sequeLinkColumnDescribe = new SequeLinkColumnDescribe(this.implCon, baseColumns.get(n), n);
                SequeLinkColumn sequeLinkColumn = this.makeColumn(sequeLinkColumnDescribe, bl2, bl);
                this.cursorVariables.add(sequeLinkColumn);
            }
            if (this.filterDescriptor != null) {
                this.filterDescriptor.removeAllRestrictions();
            }
            if (this.sortDescriptor != null) {
                this.sortDescriptor.setSatisfied();
            }
            for (n3 = n5; n3 < n4; ++n3) {
                n = n3 + 1;
                SequeLinkColumnDescribe sequeLinkColumnDescribe = new SequeLinkColumnDescribe(this.implCon, baseColumns.get(n), n);
                SequeLinkPseudoColumn sequeLinkPseudoColumn = new SequeLinkPseudoColumn(this.stmtCtxt, sequeLinkColumnDescribe);
                this.cursorVariables.add(sequeLinkPseudoColumn);
            }
        }
        return this.cursorVariables;
    }

    boolean fetchRow() throws SQLException {
        if (!this.columnsAreBound) {
            this.bindColumns();
            this.columnsAreBound = true;
        }
        this.lastAccessedColumn = 0;
        this.cursorVariables.clearCache();
        if (this.fetchedFromBatch < this.rowsInBatch) {
            ++this.fetchedFromBatch;
            return true;
        }
        return this.fetchBatch();
    }

    private int calculateBatchSize() {
        int n = !this.allowBlockFetch || this.cursorVariables.containsLongColumns() ? 1 : Integer.MAX_VALUE;
        if (this.myMaxRows > 0) {
            int n2 = this.myMaxRows - this.fetchedFromCursor;
            n = Math.min(n2, n);
        }
        return n;
    }

    private boolean fetchBatch() throws SQLException {
        if (this.fetchFlag == 0) {
            return false;
        }
        if (this.myMaxRows > 0 && this.myMaxRows == this.fetchedFromCursor) {
            return false;
        }
        this.cursorVariables.clearData();
        if (this.prefetched) {
            this.stmtCtxt.postFetch(this.diagnosticList);
            this.prefetched = false;
        } else {
            this.stmtCtxt.fetch(this.calculateBatchSize(), this.cursorVariables, this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
        }
        this.rowsInBatch = this.stmtCtxt.getRowCount();
        this.fetchedFromCursor += this.rowsInBatch;
        this.fetchFlag = this.stmtCtxt.getFetchFlag();
        if (this.allowPrefetch && this.fetchFlag == 1 && !this.cursorVariables.containsLongColumns()) {
            this.stmtCtxt.preFetch(this.calculateBatchSize(), this.cursorVariables, this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
            this.prefetched = true;
        }
        if (this.rowsInBatch == 0) {
            this.fetchedFromBatch = 0;
            return false;
        }
        this.fetchedFromBatch = 1;
        return true;
    }

    private void bindColumns() throws SQLException {
        if (this.cursorVariables == null) {
            throw new InternalError(this.getClass().getName() + " bindColumns");
        }
        if (this.cursorVariables.containsNormalColumns()) {
            this.stmtCtxt.extendedDefine(this.cursorVariables.getNormalColumns(), this.diagnosticList);
        }
    }

    private SequeLinkParameter makeParameter(BaseParameter baseParameter, BaseParameter baseParameter2, int n) throws SQLException {
        int n2;
        int n3;
        int n4;
        if (baseParameter != null && baseParameter2 != null) {
            n4 = 6;
            n3 = baseParameter2.sqlType;
            n2 = baseParameter2.scale;
        } else if (baseParameter != null) {
            n4 = 2;
            n3 = baseParameter.sqlType;
            n2 = 0;
        } else if (baseParameter2 != null) {
            n4 = 5;
            n3 = baseParameter2.sqlType;
            n2 = baseParameter2.scale;
        } else {
            throw new InternalError(this.getClass().getName() + " makeParameter");
        }
        return this.makeParameter(n, n3, n2, n4);
    }

    private void bindParameters() throws SQLException {
        this.parameterVariables = new SequeLinkParameters();
        if (this.databaseMetaDataResultSet == 0) {
            this.bindParametersNormal();
        } else {
            this.bindParametersDDA();
        }
        if (this.parameterVariables.containsNormalParameters()) {
            this.stmtCtxt.extendedDefine(this.parameterVariables.getNormalParams(), this.diagnosticList);
        }
    }

    private void bindParametersNormal() throws SQLException {
        int n;
        if (this.parameterSets == null) {
            return;
        }
        BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        if (baseParameters == null) {
            return;
        }
        int n2 = baseParameters.count();
        if (n2 == 0) {
            return;
        }
        VariableDescriptor[][] variableDescriptorArray = null;
        if (this.stmtCtxt.hasDescribeParam() && (n = (variableDescriptorArray = this.stmtCtxt.getDescribeParam(DiagnosticList.GetADummyList())).length) != n2) {
            throw new InternalError("Framework and SequeLink Server disagree on parameter count");
        }
        for (n = 1; n <= n2; ++n) {
            SequeLinkParameter sequeLinkParameter = this.makeParameter(baseParameters.get(n, 1), baseParameters.get(n, 2), n);
            this.parameterVariables.add(sequeLinkParameter);
            if (variableDescriptorArray != null) {
                SequeLinkParamDescribe sequeLinkParamDescribe = new SequeLinkParamDescribe(variableDescriptorArray[n - 1], n, this.isBadDescribeParam54);
                sequeLinkParameter.overrideEncoding(sequeLinkParamDescribe.getEncoding());
                continue;
            }
            sequeLinkParameter.overrideEncoding(this.defaultParameterEncoding);
        }
    }

    private boolean isCatalogParam(int n) {
        int n2 = n + 1;
        switch (this.databaseMetaDataResultSet) {
            case 1: {
                return n2 == 1;
            }
            case 2: {
                return n2 == 1;
            }
            case 5: {
                return n2 == 1;
            }
            case 6: {
                return n2 == 1;
            }
            case 7: {
                return n2 == 1;
            }
            case 9: {
                return n2 == 1;
            }
            case 10: {
                return n2 == 1 || n2 == 4;
            }
            case 11: {
                return n2 == 1;
            }
            case 12: {
                return n2 == 1;
            }
            case 13: {
                return n2 == 1;
            }
            case 14: {
                return n2 == 1;
            }
            case 16: {
                return n2 == 1;
            }
            case 18: {
                return n2 == 1;
            }
        }
        return false;
    }

    private void bindParametersDDA() throws SQLException {
        int n = this.filterDescriptor == null ? 0 : this.filterDescriptor.getRestrictionCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            int n2;
            int n3;
            Object object3 = this.filterDescriptor.getRestrictionByIndex(i);
            if (this.isCatalogParam(i) && !this.supportsCatalogs && object3 != null) {
                throw Message.Gen.getSqlException(7474);
            }
            if (object3 == null || object3 instanceof String) {
                n3 = 12;
                n2 = 10;
            } else if (object3 instanceof Boolean) {
                n3 = -7;
                n2 = 9;
            } else if (object3 instanceof Integer) {
                n3 = 4;
                n2 = 4;
            } else if (object3 instanceof String[]) {
                object2 = (String[])object3;
                object = new StringBuffer();
                for (int j = 0; j < ((String[])object2).length; ++j) {
                    if (((StringBuffer)object).length() != 0) {
                        ((StringBuffer)object).append(",");
                    }
                    ((StringBuffer)object).append(object2[j]);
                }
                if (((StringBuffer)object).length() == 0) {
                    this.rsn = 999;
                }
                object3 = ((StringBuffer)object).toString();
                n3 = 12;
                n2 = 10;
            } else {
                throw new InternalError(this.getClass().getName() + " bindParametersDDA - unexpected object " + object3.getClass().getName());
            }
            object2 = new BaseParameter(n3, n2, object3, this.implCon.con);
            object = this.makeParameter((BaseParameter)object2, null, i + 1);
            this.parameterVariables.add((SequeLinkParameter)object);
            ((SequeLinkParameter)object).setDataIn((BaseParameter)object2);
        }
    }

    private int bindParameterData() throws SQLException {
        if (this.parameterSets == null) {
            return 0;
        }
        int n = this.parameterSets.size();
        if (n == 0) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(i);
            if (baseParameters == null) {
                return n;
            }
            int n2 = baseParameters.count();
            if (n2 == 0) {
                return n;
            }
            int n3 = 0;
            int n4 = 0;
            UnSyncVector unSyncVector = this.parameterVariables.getInputParams();
            UnSyncVector unSyncVector2 = this.parameterVariables.getOutputParams();
            for (int j = 1; j <= n2; ++j) {
                SequeLinkParameter sequeLinkParameter;
                BaseParameter baseParameter = baseParameters.get(j, 1);
                BaseParameter baseParameter2 = baseParameters.get(j, 2);
                if (baseParameter != null) {
                    sequeLinkParameter = (SequeLinkParameter)unSyncVector.elementAt(n3++);
                    if (i == 0 && n > 1) {
                        sequeLinkParameter.setBatch();
                    }
                    sequeLinkParameter.setDataIn(baseParameter);
                    if (sequeLinkParameter.isLong()) {
                        SequeLinkStreamParameter sequeLinkStreamParameter = (SequeLinkStreamParameter)sequeLinkParameter;
                        sequeLinkStreamParameter.xfer(this.diagnosticList);
                    }
                }
                if (baseParameter2 == null) continue;
                sequeLinkParameter = (SequeLinkParameter)unSyncVector2.elementAt(n4++);
                sequeLinkParameter.setDataOut(baseParameter2);
            }
        }
        return n;
    }

    BaseData getData(int n, int n2) throws SQLException {
        while (this.lastAccessedColumn + 1 < n) {
            this.cursorVariables.cacheData(++this.lastAccessedColumn, this.fetchedFromBatch - 1, this.diagnosticList);
        }
        BaseData baseData = this.cursorVariables.getData(n, n2, this.fetchedFromBatch - 1, this.diagnosticList);
        return baseData;
    }

    private String _getRowIdColumnName() {
        String string = this.implCon.getRowIdColumnName(this.diagnosticList);
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getRowIdColumnName() {
        return this.rowid;
    }

    public boolean supportsBatchStatements() {
        return true;
    }

    public boolean supportsBatchParameters() {
        return true;
    }

    public int[] getBatchRowsAffectedCount() throws SQLException {
        return this.updateCounts;
    }

    public void cancel() throws SQLException {
        this.stmtCtxt.cancel();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.stmtCtxt.setQueryTimeout(n, this.diagnosticList);
    }

    public int getRequiredSQLProcessing(String string) {
        if (string.indexOf(63) >= 0) {
            return 1;
        }
        return 0;
    }

    public void describeParameters(BaseParameters baseParameters) throws SQLException {
        int n;
        if (!this.stmtCtxt.supportsDescribeParam()) {
            return;
        }
        VariableDescriptor[][] variableDescriptorArray = this.stmtCtxt.getDescribeParam(this.diagnosticList);
        int n2 = n = variableDescriptorArray == null ? 0 : variableDescriptorArray.length;
        if (n != baseParameters.count()) {
            throw new InternalError("Framework and SequeLink Server disagree on parameter count");
        }
        for (int i = 0; i < n; ++i) {
            int n3 = i + 1;
            SequeLinkParamDescribe sequeLinkParamDescribe = new SequeLinkParamDescribe(variableDescriptorArray[i], n3, this.isBadDescribeParam54);
            BaseParameterInfo baseParameterInfo = new BaseParameterInfo();
            baseParameterInfo.sqlType = sequeLinkParamDescribe.getType();
            baseParameterInfo.mode = sequeLinkParamDescribe.getMode();
            baseParameterInfo.nullable = sequeLinkParamDescribe.isNullable();
            baseParameterInfo.signed = sequeLinkParamDescribe.isSigned();
            baseParameterInfo.precision = sequeLinkParamDescribe.getPrecision();
            baseParameterInfo.scale = sequeLinkParamDescribe.getScale();
            baseParameterInfo.nativeTypeName = sequeLinkParamDescribe.getTypeName();
            baseParameterInfo.typeClassName = sequeLinkParamDescribe.getTypeClassName();
            baseParameters.setParameterInfo(i, baseParameterInfo);
        }
    }
}

