/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Section;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfField;
import com.lowagie.text.rtf.field.RtfTOCEntry;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfSection
extends RtfElement {
    protected RtfParagraph title = null;
    protected ArrayList items = new ArrayList();

    public RtfSection(RtfDocument rtfDocument, Section section) {
        super(rtfDocument);
        try {
            Object object2;
            if (section.getTitle() != null) {
                this.title = (RtfParagraph)rtfDocument.getMapper().mapElement(section.getTitle());
            }
            if (this.document.getAutogenerateTOCEntries()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (Object object2 : section.getTitle()) {
                    if (object2.type() != 10) continue;
                    stringBuffer.append(((Chunk)object2).getContent());
                }
                if (stringBuffer.toString().trim().length() > 0) {
                    object2 = new RtfTOCEntry(stringBuffer.toString());
                    ((RtfField)object2).setRtfDocument(this.document);
                    this.items.add(object2);
                }
            }
            for (Object object3 : section) {
                object2 = rtfDocument.getMapper().mapElement((Element)object3);
                if (object2 == null) continue;
                this.items.add(object2);
            }
            this.updateIndentation(section.getIndentationLeft(), section.getIndentationRight(), section.getIndentation());
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(RtfParagraph.PARAGRAPH);
        if (this.title != null) {
            this.title.writeContent(outputStream);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.items.get(i);
            rtfBasicElement.writeContent(outputStream);
        }
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInTable(bl);
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInHeader(bl);
        }
    }

    private void updateIndentation(float f, float f2, float f3) {
        if (this.title != null) {
            this.title.setIndentLeft((int)((double)this.title.getIndentLeft() + (double)f * 20.0));
            this.title.setIndentRight((int)((double)this.title.getIndentRight() + (double)f2 * 20.0));
        }
        for (int i = 0; i < this.items.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.items.get(i);
            if (rtfBasicElement instanceof RtfSection) {
                ((RtfSection)rtfBasicElement).updateIndentation(f + f3, f2, 0.0f);
                continue;
            }
            if (!(rtfBasicElement instanceof RtfParagraph)) continue;
            ((RtfParagraph)rtfBasicElement).setIndentLeft((int)((double)((RtfParagraph)rtfBasicElement).getIndentLeft() + (double)(f + f3) * 20.0));
            ((RtfParagraph)rtfBasicElement).setIndentRight((int)((double)((RtfParagraph)rtfBasicElement).getIndentRight() + (double)f2 * 20.0));
        }
    }
}

