/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.pjava12;

import ice.debug.Debug;
import ice.util.io.IOKit;
import ice.util.security.pjava12.JarCache_pjava12;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;

final class URLClassLoader_pjava12
extends SecureClassLoader {
    private URL codebase = null;
    private URL[] urls = null;

    URLClassLoader_pjava12(URL[] urls, ClassLoader parent) {
        super(parent);
        this.urls = urls;
        this.codebase = urls[0];
        for (int i = 1; i < urls.length; ++i) {
            JarCache_pjava12.getInstance().addJarFile(urls[i]);
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            try {
                return this.findSystemClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.do_loadClass(name);
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private Class do_loadClass(final String className) {
        final String resourceName = className.replace('.', '/') + ".class";
        URL originUrl = this.urls.length > 1 ? this.urls[1] : this.codebase;
        final CodeSource origin = new CodeSource(originUrl, null);
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                byte[] data = URLClassLoader_pjava12.this.getResourceAsByteArray(resourceName);
                if (data != null) {
                    return URLClassLoader_pjava12.this.defineClass(className, data, 0, data.length, origin);
                }
                return null;
            }
        });
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = super.getPermissions(codesource);
        this.addSourceAllowances(pc, codesource.getLocation());
        return pc;
    }

    private void addSourceAllowances(PermissionCollection pc, URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            String urlPath = url.getFile();
            String systemPath = '/' == File.separatorChar ? urlPath : urlPath.replace('/', File.separatorChar);
            boolean directory = urlPath.endsWith("/");
            String allowedPath = directory ? systemPath + '-' : systemPath;
            pc.add(new FilePermission(allowedPath, "read"));
        } else {
            String host = url.getHost();
            if (host == null || host.length() == 0) {
                host = "localhost";
            }
            pc.add(new SocketPermission(host, "connect, accept"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getResourceAsByteArray(String name) {
        byte[] data;
        block7: {
            data = null;
            if (this.urls.length > 1) {
                String fullName = "jar:" + this.urls[1] + "!/" + name;
                data = JarCache_pjava12.getInstance().getResource(fullName);
            }
            if (data == null && this.codebase != null) {
                try {
                    URL u = new URL(this.codebase, name);
                    InputStream is = this.getInputStream(u);
                    if (is == null) break block7;
                    try {
                        data = IOKit.readAll(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    if (!Debug.ex) break block7;
                    Debug.ex(ex);
                }
            }
        }
        return data;
    }

    public URL getResource(String name) {
        URL u = URLClassLoader_pjava12.getSystemResource(name);
        if (u != null) {
            return u;
        }
        if (this.urls.length > 1) {
            try {
                u = new URL("jar://" + this.urls[1].toString() + "!/" + name);
                return u;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (this.codebase != null) {
            try {
                u = new URL(this.codebase, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return u;
    }

    public InputStream getResourceAsStream(String name) {
        URL u;
        byte[] data;
        InputStream s = URLClassLoader_pjava12.getSystemResourceAsStream(name);
        if (s != null) {
            return s;
        }
        if (this.urls.length > 1 && (data = this.getResourceAsByteArray(name)) != null) {
            s = new ByteArrayInputStream(data);
        }
        if (s == null && this.codebase != null && (u = this.getResource(name)) != null) {
            s = this.getInputStream(u);
        }
        return s;
    }

    private InputStream getInputStream(URL url) {
        URLConnection uc;
        try {
            uc = url.openConnection();
        }
        catch (IOException ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            return null;
        }
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URLClassLoader_pjava12.this.do_getInputStream(uc);
            }
        });
    }

    private InputStream do_getInputStream(URLConnection uc) {
        InputStream is;
        try {
            HttpURLConnection hc;
            int code;
            is = uc.getInputStream();
            if (uc instanceof HttpURLConnection && (code = (hc = (HttpURLConnection)uc).getResponseCode()) >= 400) {
                is = null;
            }
        }
        catch (IOException ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            is = null;
        }
        return is;
    }
}

