/**
 * Copyright 2007 Adobe Systems Incorporated
 * All Rights Reserved.
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package coldfusion.print;

import javax.print.attribute.standard.Fidelity;
import java.util.HashSet;
import java.util.Set;

/**
 * CFPrintAttribute
 * <p/>
 * Created on Jan 19, 2007
 *
 * @author cframpto
 */
public class CFPrintAttribute
{
    public static final String AUTO_ROTATE_AND_CENTER = "autorotateandcenter";
    public static final String COLLATE = "collate";
    public static final String COLOR = "color";                 // synonym for chromaticity
    public static final String CHROMATICITY = "chromaticity";
    public static final String COPIES = "copies";
    public static final String COVERPAGE = "coverpage";            // synonym for jobSheets
    public static final String FIDELITY = "fidelity";
    public static final String FINISHINGS = "finishings";
    public static final String JOB_HOLD_UNITL = "jobholduntil";
    public static final String JOBNAME = "jobname";
    public static final String JOB_PRIORITY = "jobpriority";
    public static final String JOBSHEETS = "jobsheets";
    public static final String MEDIA = "media";
    public static final String NUMBERUP = "numberup";
    public static final String ORIENTATION = "orientation";
    public static final String ORIENTATION_REQUESTED = "orientationrequested";
    public static final String PAGES = "pages";
    public static final String PAGE_SCALING = "pagescaling";
    public static final String PAGE_SUBSET = "pagesubset";
    public static final String PAPER = "paper";                 // synonym for media
    public static final String PRESENTATION_DIRECTION = "presentationdirection";
    public static final String PRINTER = "printer";
    public static final String REQUESTING_USERNAME = "requestingusername";
    public static final String REVERSE_PAGES = "reversepages";
    public static final String QUALITY = "quality";
    public static final String SHEET_COLLATE = "sheetcollate";
    public static final String SIDES = "sides";
    public static final String USE_PDF_PAGE_SIZE = "usepdfpagesize";

    private static HashSet set = null;

    private static Set getCFStructAttributeSet()
    {
        if (set == null)
        {
            set = new HashSet();
            set.add(AUTO_ROTATE_AND_CENTER);
            set.add(COLLATE);
            set.add(COLOR);
            set.add(CHROMATICITY);
            set.add(COPIES);
            set.add(COVERPAGE);
            set.add(FIDELITY);
            set.add(FINISHINGS);
            set.add(JOB_HOLD_UNITL);
            set.add(JOBNAME);
            set.add(JOB_PRIORITY);
            set.add(JOBSHEETS);
            set.add(MEDIA);
            set.add(NUMBERUP);
            set.add(ORIENTATION);
            set.add(ORIENTATION_REQUESTED);
            set.add(PAGES);
            set.add(PAGE_SCALING);
            set.add(PAGE_SUBSET);
            set.add(PAPER);
            set.add(PRESENTATION_DIRECTION);
            set.add(PRINTER);
            set.add(REQUESTING_USERNAME);
            set.add(REVERSE_PAGES);
            set.add(QUALITY);
            set.add(SHEET_COLLATE);
            set.add(SIDES);
            set.add(USE_PDF_PAGE_SIZE);
        }

        return set;
    }

    public static boolean isCFStructAttribute(String name)
    {
        return (getCFStructAttributeSet().contains(name));
    }

    public static String getCFStructAttributes()
    {
        return coldfusion.runtime.ArrayUtil.ArrayToList(getCFStructAttributeSet(), ",");
    }
}
 
