/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3;

import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;

public class S3FileSystemConfigBuilder
extends DefaultFileSystemConfigBuilder {
    private static S3FileSystemConfigBuilder instance = new S3FileSystemConfigBuilder();
    private static final String ACCESS_KEY_ID = S3FileSystemConfigBuilder.class.getName() + ".ACCESS_KEY_ID";
    private static final String SECRET_ACCESS_KEY = S3FileSystemConfigBuilder.class.getName() + ".SECRET_ACCESS_KEY";
    private static final String LOCATION = S3FileSystemConfigBuilder.class.getName() + ".LOCATION";
    private static final String CREDENTIAL_PROVIDER_CHAIN_ENABLED = S3FileSystemConfigBuilder.class.getName() + "CREDENTIAL_PROVIDER_CHAIN_ENABLED";

    public static S3FileSystemConfigBuilder getInstance() {
        return instance;
    }

    private S3FileSystemConfigBuilder() {
    }

    protected Class getConfigClass() {
        return S3FileSystemConfigBuilder.class;
    }

    public void setCredentialProviderChain(FileSystemOptions opts, boolean value) {
        this.setParam(opts, CREDENTIAL_PROVIDER_CHAIN_ENABLED, value);
    }

    public boolean getCredentialProviderChain(FileSystemOptions opts) {
        return Boolean.TRUE.equals(this.getParam(opts, CREDENTIAL_PROVIDER_CHAIN_ENABLED));
    }

    public void setAccessKeyID(FileSystemOptions opts, String accessKeyID) {
        this.setParam(opts, ACCESS_KEY_ID, accessKeyID);
    }

    public String getAccessKeyID(FileSystemOptions opts) {
        return (String)this.getParam(opts, ACCESS_KEY_ID);
    }

    public void setSecretAccessKey(FileSystemOptions opts, String secretAccessKey) {
        this.setParam(opts, SECRET_ACCESS_KEY, secretAccessKey);
    }

    public String getSecretAccessKey(FileSystemOptions opts) {
        return (String)this.getParam(opts, SECRET_ACCESS_KEY);
    }

    public void setDefaultLocation(FileSystemOptions opts, String location) {
        this.setParam(opts, LOCATION, location);
    }

    public String getDefaultLocation(FileSystemOptions opts) {
        return (String)this.getParam(opts, LOCATION);
    }
}

