/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3;

import coldfusion.security.ESAPIUtils;
import coldfusion.vfs.s3.S3FileName;
import coldfusion.vfs.s3.S3FileSystem;
import coldfusion.vfs.s3.S3OutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.StorageOwner;

public class S3FileObject
extends AbstractFileObject {
    private S3Service s3Service;
    private S3FileName rootName;
    private String s3Key;
    private S3Object s3Obj;
    private S3Bucket bucket;
    private final String bucketName;
    private static final boolean cached = true;
    private static final Set<String> ignoreAttributeKeys = new HashSet<String>(Arrays.asList("__service__", "__complete__", "__http__", "__user__"));

    public S3FileObject(AbstractFileName name, S3FileSystem fs, S3FileName rootName) {
        super(name, (AbstractFileSystem)fs);
        this.rootName = rootName;
        this.s3Service = fs.getS3Service();
        this.bucket = fs.getBucket();
        this.bucketName = fs.getBucketName();
        String path = name.getPath();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        this.s3Key = path;
        if (!this.s3Key.equals("") && !this.s3Key.endsWith("/") && this.getName() != null && this.getName().getType().equals((Object)FileType.FOLDER)) {
            this.s3Key = this.s3Key + "/";
        }
    }

    public String getS3Key() {
        return this.s3Key;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public StorageOwner getOwner() {
        if (this.bucket == null) {
            this.refreshBucket();
        }
        if (this.bucket != null) {
            return this.bucket.getOwner();
        }
        return null;
    }

    public String getBucketLocation() {
        if (this.bucket == null) {
            this.refreshBucket();
        }
        if (this.bucket != null) {
            String location = this.bucket.getLocation();
            return location == null ? "US" : location;
        }
        return null;
    }

    protected void doAttach() throws Exception {
        if (this.bucket == null) {
            this.refreshBucket();
        } else {
            this.checkBucketExists();
        }
        if (this.s3Key.length() > 0 && this.bucket != null && this.s3Obj == null) {
            try {
                this.s3Obj = this.s3Service.getObjectDetails(this.bucket, this.s3Key);
            }
            catch (S3ServiceException s3ServiceException) {
                // empty catch block
            }
        }
    }

    private void checkBucketExists() {
        try {
            S3Bucket bucket = this.s3Service.getBucket(this.bucketName);
            if (bucket == null) {
                this.bucket = null;
            }
        }
        catch (S3ServiceException s3ServiceException) {
            // empty catch block
        }
    }

    private void refreshBucket() {
        try {
            this.bucket = this.s3Service.getBucket(this.bucketName);
            if (this.bucket != null && !this.bucket.isLocationKnown()) {
                this.bucket.setLocation(this.s3Service.getBucketLocation(this.bucketName));
            }
            if (this.bucket == null && this.s3Service.isBucketAccessible(this.bucketName)) {
                this.bucket = new S3Bucket(this.bucketName);
            }
            if (this.bucket != null) {
                ((S3FileSystem)this.getFileSystem()).setBucket(this.bucket);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    protected FileType doGetType() throws Exception {
        if (this.getName() != null) {
            return this.getName().getType();
        }
        return FileType.FILE;
    }

    public FileObject[] getChildren() throws FileSystemException {
        if (this.bucket == null) {
            throw new FileSystemException("vfs.provider/list-children-not-folder.error", (Object)this.getName());
        }
        try {
            return this.doListChildrenResolved();
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public String[] doListChildren() throws Exception {
        String prefix = this.s3Key.length() == 0 ? null : this.s3Key + "/";
        S3Object[] objects = this.s3Service.listObjects(this.bucket, prefix, null);
        String[] children = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            S3Object object = objects[i];
            children[i] = object.getKey();
        }
        return children;
    }

    public FileObject[] doListChildrenResolved() throws Exception {
        String prefix = this.s3Key.length() == 0 ? null : this.s3Key + "/";
        S3Object[] objects = this.s3Service.listObjects(this.bucket, prefix, null);
        FileObject[] children = new FileObject[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            S3Object object = objects[i];
            children[i] = this.getFileSystem().resolveFile(ESAPIUtils.encodeForURL((String)object.getKey(), (boolean)false).replace("+", "%20"));
        }
        return children;
    }

    public FileObject[] findFiles(FileSelector selector) throws FileSystemException {
        ArrayList list = new ArrayList();
        this.findFiles(selector, true, list);
        return list.toArray(new FileObject[list.size()]);
    }

    public void findFiles(FileSelector selector, boolean depthwise, List selected) throws FileSystemException {
        S3FileSelectInfo info = new S3FileSelectInfo(this.getFileSystem().getRoot());
        FileObject[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            FileObject child = children[i];
            info.setFile(child);
            try {
                if (!selector.includeFile((FileSelectInfo)info)) continue;
                selected.add(child);
                continue;
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }
    }

    protected long doGetContentSize() throws Exception {
        if (this.s3Obj != null) {
            return this.s3Obj.getContentLength();
        }
        return -1L;
    }

    protected InputStream doGetInputStream() throws Exception {
        this.s3Obj = this.bucket != null ? this.s3Service.getObject(this.bucket, this.s3Key) : this.s3Service.getObject(this.bucketName, this.s3Key);
        return this.s3Obj.getDataInputStream();
    }

    public boolean delete() throws FileSystemException {
        try {
            this.doDelete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void doDelete() throws Exception {
        if (this.s3Obj != null) {
            this.s3Service.deleteObject(this.bucket, this.s3Key);
            this.s3Obj = null;
        } else if (this.s3Key.length() == 0) {
            this.s3Service.deleteBucket(this.bucket);
            this.bucket = null;
            ((S3FileSystem)this.getFileSystem()).setBucket(null);
        }
    }

    protected void doRename(FileObject newfile) throws Exception {
        if (this.s3Obj != null && newfile instanceof S3FileObject) {
            S3FileObject destination = (S3FileObject)newfile;
            destination.doAttach();
            if (destination.s3Obj == null) {
                destination.createS3Object();
            }
            destination.s3Obj.setAcl(this.getObjectACL());
            this.s3Service.renameObject(this.bucket.getName(), this.s3Key, (StorageObject)destination.s3Obj);
            this.s3Obj = null;
        }
    }

    public void createFolder() throws FileSystemException {
        if (this.s3Key.length() == 0 && this.bucket == null) {
            try {
                this.s3Service.createBucket(this.bucketName);
                this.refreshBucket();
            }
            catch (S3ServiceException e) {
                throw new FileSystemException((Throwable)e);
            }
        }
    }

    protected void doCreateFolder() throws Exception {
        if (this.s3Obj != null) {
            this.s3Obj.setContentType("application/x-directory");
            this.s3Service.putObject(this.bucket, this.s3Obj);
        } else {
            this.s3Service.createBucket(this.bucketName);
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.s3Obj != null) {
            return this.s3Obj.getLastModifiedDate().getTime();
        }
        return -1L;
    }

    protected boolean doSetLastModifiedTime(long modtime) {
        try {
            if (this.s3Obj != null) {
                this.s3Obj.setLastModifiedDate(new Date(modtime));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Map doGetAttributes() throws Exception {
        HashMap map = new HashMap();
        if (this.s3Key.length() > 0 && this.s3Obj != null) {
            map.putAll(this.s3Obj.getMetadataMap());
        } else if (this.s3Key.length() == 0 && this.bucket != null) {
            map.putAll(this.bucket.getMetadataMap());
        }
        map.keySet().removeAll(ignoreAttributeKeys);
        return map;
    }

    protected void doSetAttribute(String attrName, Object value) throws Exception {
        if (this.s3Obj != null) {
            this.s3Obj.addMetadata(attrName, (String)value);
        } else if (this.s3Key.length() == 0) {
            this.bucket.addMetadata(attrName, (String)value);
        }
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (this.s3Obj == null) {
            this.createS3Object();
        }
        return new S3OutputStream(this.s3Obj, this.s3Service, this.bucket, bAppend);
    }

    public void createS3Object() {
        this.s3Obj = new S3Object(this.bucket, this.s3Key);
        this.s3Obj.setLastModifiedDate(new Date());
    }

    public FileObject getParent() throws FileSystemException {
        FileObject root = this.getFileSystem().getRoot();
        if (root == this) {
            return null;
        }
        return root;
    }

    public boolean exists() throws FileSystemException {
        try {
            this.doAttach();
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
        if (this.s3Key.length() == 0) {
            return this.bucket != null;
        }
        return this.s3Obj != null;
    }

    public void setACL(AccessControlList acl) throws Exception {
        this.doAttach();
        if (this.s3Key.length() > 0) {
            this.s3Service.putObjectAcl(this.bucketName, this.s3Key, acl);
        } else {
            this.s3Service.putBucketAcl(this.bucketName, acl);
        }
    }

    public AccessControlList getACL() throws ServiceException {
        if (this.s3Key.length() > 0) {
            return this.s3Service.getObjectAcl(this.bucketName, this.s3Key);
        }
        return this.s3Service.getBucketAcl(this.bucketName);
    }

    private AccessControlList getObjectACL() throws ServiceException {
        if (this.s3Key.length() > 0) {
            return this.s3Service.getObjectAcl(this.bucketName, this.s3Key);
        }
        return null;
    }

    public void updateMetadata() throws ServiceException, Exception {
        AccessControlList acl = this.s3Key.length() > 0 ? this.s3Service.getObjectAcl(this.bucketName, this.s3Key) : this.s3Service.getBucketAcl(this.bucketName);
        if (this.s3Obj != null) {
            this.s3Service.updateObjectMetadata(this.bucketName, (StorageObject)this.s3Obj);
        }
        this.setACL(acl);
    }

    public S3Object getS3Object() {
        return this.s3Obj;
    }

    public S3Service getS3Service() {
        return this.s3Service;
    }

    private static class S3FileSelectInfo
    implements FileSelectInfo {
        private FileObject baseFolder;
        private FileObject file;

        public S3FileSelectInfo(FileObject baseFolder) {
            this.baseFolder = baseFolder;
        }

        public FileObject getBaseFolder() {
            return this.baseFolder;
        }

        public FileObject getFile() {
            return this.file;
        }

        public void setFile(FileObject file) {
            this.file = file;
        }

        public int getDepth() {
            return 0;
        }
    }
}

