/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.testing.logger.LogInspectionHelper;
import org.hibernate.testing.logger.LogListener;
import org.hibernate.testing.orm.junit.Logger;
import org.hibernate.testing.orm.junit.MessageKeyWatcher;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;

public class MessageKeyWatcherImpl
implements MessageKeyWatcher,
LogListener {
    private final String messageKey;
    private final List<String> loggerNames = new ArrayList<String>();
    private final List<String> triggeredMessages = new ArrayList<String>();

    public MessageKeyWatcherImpl(String messageKey) {
        this.messageKey = messageKey;
    }

    public void addLoggerName(String name) {
        this.loggerNames.add(name);
    }

    public void addLogger(Logger loggerAnn) {
        org.jboss.logging.Logger logger;
        if (loggerAnn.loggerNameClass() != Void.TYPE) {
            logger = org.jboss.logging.Logger.getLogger(loggerAnn.loggerNameClass());
        } else if (!"".equals(loggerAnn.loggerName().trim())) {
            logger = org.jboss.logging.Logger.getLogger((String)loggerAnn.loggerName().trim());
        } else {
            throw new IllegalStateException("@LoggingInspections for prefix '" + this.messageKey + "' did not specify proper Logger name.  Use `@LoggingInspections#loggerName or `@LoggingInspections#loggerNameClass`");
        }
        LogInspectionHelper.registerListener(this, (BasicLogger)logger);
    }

    public static String loggerKey(Logger loggerAnn) {
        org.jboss.logging.Logger logger;
        if (loggerAnn.loggerNameClass() != Void.TYPE) {
            logger = org.jboss.logging.Logger.getLogger(loggerAnn.loggerNameClass());
        } else if (!"".equals(loggerAnn.loggerName().trim())) {
            logger = org.jboss.logging.Logger.getLogger((String)loggerAnn.loggerName().trim());
        } else {
            throw new IllegalArgumentException("`@Logger` must specify either `#loggerNameClass` or `#loggerName`");
        }
        return logger.getName();
    }

    public List<String> getLoggerNames() {
        return this.loggerNames;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public boolean wasTriggered() {
        return !this.triggeredMessages.isEmpty();
    }

    @Override
    public List<String> getTriggeredMessages() {
        return this.triggeredMessages;
    }

    @Override
    public String getFirstTriggeredMessage() {
        return this.triggeredMessages.isEmpty() ? null : this.triggeredMessages.get(0);
    }

    @Override
    public void reset() {
        this.triggeredMessages.clear();
    }

    @Override
    public void loggedEvent(Logger.Level level, String renderedMessage, Throwable thrown) {
        if (renderedMessage != null && renderedMessage.startsWith(this.messageKey)) {
            this.triggeredMessages.add(renderedMessage);
        }
    }

    public String toString() {
        return "MessageIdWatcherImpl{messageKey='" + this.messageKey + '\'' + ", loggerNames=" + this.loggerNames + '}';
    }
}

