/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc.leak;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.testing.jdbc.JdbcProperties;
import org.hibernate.testing.jdbc.leak.ConnectionLeakException;
import org.hibernate.testing.jdbc.leak.H2IdleConnectionCounter;
import org.hibernate.testing.jdbc.leak.IdleConnectionCounter;
import org.hibernate.testing.jdbc.leak.MySQLIdleConnectionCounter;
import org.hibernate.testing.jdbc.leak.OracleIdleConnectionCounter;
import org.hibernate.testing.jdbc.leak.PostgreSQLIdleConnectionCounter;

public class ConnectionLeakUtil {
    private JdbcProperties jdbcProperties = JdbcProperties.INSTANCE;
    private List<IdleConnectionCounter> idleConnectionCounters = Arrays.asList(H2IdleConnectionCounter.INSTANCE, OracleIdleConnectionCounter.INSTANCE, PostgreSQLIdleConnectionCounter.INSTANCE, MySQLIdleConnectionCounter.INSTANCE);
    private IdleConnectionCounter connectionCounter;
    private int connectionLeakCount;

    public ConnectionLeakUtil() {
        for (IdleConnectionCounter connectionCounter : this.idleConnectionCounters) {
            if (!connectionCounter.appliesTo(Dialect.getDialect().getClass())) continue;
            this.connectionCounter = connectionCounter;
            break;
        }
        if (this.connectionCounter != null) {
            this.connectionLeakCount = this.countConnectionLeaks();
        }
    }

    public void assertNoLeaks() {
        int currentConnectionLeakCount;
        int diff;
        if (this.connectionCounter != null && (diff = (currentConnectionLeakCount = this.countConnectionLeaks()) - this.connectionLeakCount) > 0) {
            throw new ConnectionLeakException(String.format("%d connection(s) have been leaked! Previous leak count: %d, Current leak count: %d", diff, this.connectionLeakCount, currentConnectionLeakCount));
        }
    }

    private int countConnectionLeaks() {
        int n;
        block8: {
            Connection connection = this.newConnection();
            try {
                n = this.connectionCounter.count(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
            connection.close();
        }
        return n;
    }

    private Connection newConnection() {
        try {
            return DriverManager.getConnection(this.jdbcProperties.getUrl(), this.jdbcProperties.getUser(), this.jdbcProperties.getPassword());
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

