/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import java.io.IOException;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricsContext;

public interface SolrMetricProducer
extends AutoCloseable {
    public static String getUniqueMetricTag(Object o, String parentName) {
        String name = o.getClass().getSimpleName() + "@" + Integer.toHexString(o.hashCode());
        if (parentName != null && parentName.contains(name)) {
            throw new RuntimeException("Parent already includes this component! parent=" + parentName + ", this=" + name);
        }
        return parentName == null ? name : parentName + ":" + name;
    }

    @Deprecated
    default public void initializeMetrics(SolrMetricManager manager, String registry, String tag, String scope) {
        this.initializeMetrics(new SolrMetricsContext(manager, registry, tag), scope);
    }

    default public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        throw new RuntimeException("In class " + this.getClass().getName() + " you must implement either initializeMetrics(SolrMetricsContext, String) or " + "initializeMetrics(SolrMetricManager, String, String, String)");
    }

    default public SolrMetricsContext getSolrMetricsContext() {
        return null;
    }

    @Override
    default public void close() throws IOException {
        SolrMetricsContext context = this.getSolrMetricsContext();
        if (context == null) {
            return;
        }
        context.unregister();
    }
}

