/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3.credentials;

import coldfusion.log.Logger;
import coldfusion.runtime.JSONUtils;
import coldfusion.server.ServiceFactory;
import coldfusion.vfs.s3.credentials.AWSCredentialsProvider;
import coldfusion.vfs.s3.credentials.AWSSystemSettings;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.jets3t.service.security.AWSCredentials;

public final class ECSContainerCredentialsProvider
implements AWSCredentialsProvider {
    private final Logger logger = ServiceFactory.getLoggingService().getLogger("awsS3Legacy");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AWSCredentials loadCredentials() {
        try (BufferedReader reader = null;){
            URL url = new URL(AWSSystemSettings.AWS_ECS_CONTAINER_SERVICE_ENDPOINT.getValue() + System.getenv(AWSSystemSettings.ENV_AWS_ECS_CONTAINER_CREDENTIALS_RELATIVE_URI.getValue()));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            con.setRequestMethod("GET");
            con.setDoOutput(true);
            con.setInstanceFollowRedirects(false);
            con.setRequestProperty("Accept", "application/json");
            InputStream in = con.getInputStream();
            StringBuilder sb = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(in));
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                sb.append(nextLine);
            }
            Map responseCred = (Map)JSONUtils.deserializeJSON((Object)sb.toString());
            String accessKeyId = (String)responseCred.get(AWSSystemSettings.ACCESS_KEY_ID.getValue());
            String secretKey = (String)responseCred.get(AWSSystemSettings.SECRET_ACCESS_KEY.getValue());
            if (accessKeyId == null) return null;
            if (secretKey == null) return null;
            this.logger.info((Object)"AWS Credentials found using ECS Container relative URI!");
            AWSCredentials aWSCredentials = new AWSCredentials(accessKeyId, secretKey);
            return aWSCredentials;
        }
        catch (Exception e) {
            this.logger.info((Object)"AWS Credentials NOT found from ECS Container credentials relative URI.");
        }
        return null;
    }
}

