/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import com.microsoft.azure.storage.blob.SharedAccessBlobPermissions;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class SharedAccessBlobPolicyConsumer
extends ConsumerMap<SharedAccessBlobPolicy> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static SharedAccessBlobPolicyConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharedAccessBlobPolicyConsumer getInstance() {
        if (instance != null) return instance;
        Class<SharedAccessBlobPolicyConsumer> clazz = SharedAccessBlobPolicyConsumer.class;
        synchronized (SharedAccessBlobPolicyConsumer.class) {
            instance = new SharedAccessBlobPolicyConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SharedAccessBlobPolicyConsumer() {
        this.put("permissions", new ConsumerValidator((sharedAccessBlobPolicy, value) -> {
            List list = Cast._List((Object)value);
            EnumSet<SharedAccessBlobPermissions> blobPermissions = EnumSet.noneOf(SharedAccessBlobPermissions.class);
            list.forEach(item -> blobPermissions.add(SharedAccessBlobPermissions.valueOf((String)this.cast.getStringProperty(item))));
            sharedAccessBlobPolicy.setPermissions(blobPermissions);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("sharedAccessExpiryTime", new ConsumerValidator((containerPermissions, value) -> containerPermissions.setSharedAccessExpiryTime(this.cast.getDateProperty(value)), Collections.emptyList()));
        this.put("sharedAccessStartTime", new ConsumerValidator((containerPermissions, value) -> containerPermissions.setSharedAccessStartTime(this.cast.getDateProperty(value)), Collections.emptyList()));
    }

    public Struct getPolicyStruct(SharedAccessBlobPolicy policy) {
        Struct struct = new Struct();
        StringBuilder permissionList = new StringBuilder();
        Iterator iterator = policy.getPermissions().iterator();
        while (iterator.hasNext()) {
            permissionList.append(((SharedAccessBlobPermissions)iterator.next()).name());
            if (!iterator.hasNext()) continue;
            permissionList.append(',');
        }
        struct.put((Object)"permissions", (Object)permissionList.toString());
        struct.put((Object)"sharedAccessExpiryTime", (Object)policy.getSharedAccessExpiryTime().toString());
        struct.put((Object)"sharedAccessStartTime", (Object)policy.getSharedAccessStartTime().toString());
        return struct;
    }
}

