/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.azure.blob.ContainerReference;
import coldfusion.azure.blob.consumer.AbstractAzureBlobRequestConsumer;
import coldfusion.azure.blob.request.BlockUploadRequest;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.filter.FusionContext;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import java.util.Collections;
import javax.servlet.jsp.PageContext;

public class BlockUploadRequestConsumer
extends AbstractAzureBlobRequestConsumer<BlockUploadRequest> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private final ValidatorFiller filler = ValidatorFiller.INSTANCE;
    public static BlockUploadRequestConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlockUploadRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<BlockUploadRequestConsumer> clazz = BlockUploadRequestConsumer.class;
        synchronized (BlockUploadRequestConsumer.class) {
            instance = new BlockUploadRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private BlockUploadRequestConsumer() {
        this.put("blobName", new ConsumerValidator((request, value) -> request.setBlobName(this.cast.getStringProperty(value)), Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("blockId", new ConsumerValidator((request, value) -> {
            String id = this.cast.getStringProperty(value).trim();
            if (id.isEmpty()) {
                throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidBlockIds"));
            }
            request.setBlockId(id);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("srcFile", new ConsumerValidator((request, value) -> request.setSourceFile(Utils.getFileFullPath((String)this.cast.getStringProperty(value), (PageContext)FusionContext.getCurrent().pageContext, (boolean)true)), Collections.emptyList()));
        this.put("object", new ConsumerValidator(BlockUploadRequest::setInputObject, Collections.emptyList()));
    }
}

