/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.azure.blob.config.RetryConfig;
import coldfusion.azure.blob.consumer.RetryConfigConsumer;
import coldfusion.azure.blob.exception.AzureBlobApiException;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.cryptography.RsaKey;
import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.RetryExponentialRetry;
import com.microsoft.azure.storage.RetryLinearRetry;
import com.microsoft.azure.storage.RetryNoRetry;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.blob.BlobEncryptionPolicy;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.Map;

public class BlobRequestOptionsConsumer
extends ConsumerMap<BlobRequestOptions> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static BlobRequestOptionsConsumer instance;
    private static Provider secProvider;
    private static final String[] PREFERABLESECURITYPROVIDERS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlobRequestOptionsConsumer getInstance() {
        if (instance != null) return instance;
        Class<BlobRequestOptionsConsumer> clazz = BlobRequestOptionsConsumer.class;
        synchronized (BlobRequestOptionsConsumer.class) {
            instance = new BlobRequestOptionsConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public BlobRequestOptionsConsumer() {
        this.put("absorbConditionalErrorsOnRetry", new ConsumerValidator((requestOptions, value) -> requestOptions.setAbsorbConditionalErrorsOnRetry(this.cast.getBooleanProperty(value)), Collections.emptyList()));
        this.put("concurrentRequestCount", new ConsumerValidator((requestOptions, value) -> {
            requestOptions.setConcurrentRequestCount(Integer.valueOf(this.cast.getIntegerProperty(value)));
            ValidationUtil.validPositiveNumber((long)requestOptions.getConcurrentRequestCount().intValue(), (String)"concurrentRequestCount");
        }, Collections.emptyList()));
        this.put("useTransactionalContentMD5", new ConsumerValidator((requestOptions, value) -> requestOptions.setUseTransactionalContentMD5(this.cast.getBooleanProperty(value)), Collections.emptyList()));
        this.put("storeBlobContentMD5", new ConsumerValidator((requestOptions, value) -> requestOptions.setStoreBlobContentMD5(this.cast.getBooleanProperty(value)), Collections.emptyList()));
        this.put("disableContentMD5Validation", new ConsumerValidator((requestOptions, value) -> requestOptions.setDisableContentMD5Validation(this.cast.getBooleanProperty(value)), Collections.emptyList()));
        this.put("singleBlobPutThresholdInBytes", new ConsumerValidator((requestOptions, value) -> {
            int v = this.cast.getIntegerProperty(value);
            ValidationUtil.validNumberInRange((long)v, (long)0x100000L, (long)0x10000000L, (String)"singleBlobPutThresholdInBytes");
            requestOptions.setSingleBlobPutThresholdInBytes(Integer.valueOf(v));
        }, Collections.emptyList()));
        this.put("encryption", new ConsumerValidator((requestOptions, value) -> {
            Map encryptionConfig = this.cast.getMapProperty(value);
            requestOptions.setRequireEncryption(Boolean.valueOf(true));
            try {
                RsaKey rsaKey = new RsaKey((String)encryptionConfig.get("kid"), (KeyPair)encryptionConfig.get("keyPair"), BlobRequestOptionsConsumer.getEncryptionProvider());
                BlobEncryptionPolicy policy = new BlobEncryptionPolicy((IKey)rsaKey, null);
                requestOptions.setEncryptionPolicy(policy);
            }
            catch (Exception e) {
                throw new AzureBlobApiException("ExceptionWhileUsingExcryptionKey", e);
            }
        }, Collections.emptyList()));
        this.put("skipEtagLocking", new ConsumerValidator((requestOptions, value) -> requestOptions.setSkipEtagLocking(this.cast.getBooleanProperty(value).booleanValue()), Collections.emptyList()));
        this.put("retryPolicyFactory", new ConsumerValidator((requestOptions, value) -> {
            Map map = this.cast.getMapProperty(value);
            RetryConfig retryConfig = new RetryConfig();
            ValidatorFiller.INSTANCE.fillObject((Object)retryConfig, map, (ConsumerMap)RetryConfigConsumer.getInstance());
            retryConfig.validate();
            RetryPolicyFactory retryPolicyFactory = this.getRetryPolicy(retryConfig);
            requestOptions.setRetryPolicyFactory(retryPolicyFactory);
        }, Collections.emptyList()));
        this.put("locationMode", new ConsumerValidator((requestOptions, value) -> requestOptions.setLocationMode(LocationMode.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("maximumExecutionTimeInMs", new ConsumerValidator((requestOptions, value) -> {
            requestOptions.setMaximumExecutionTimeInMs(Integer.valueOf(this.cast.getIntegerProperty(value)));
            ValidationUtil.validPositiveNumber((long)requestOptions.getMaximumExecutionTimeInMs().intValue(), (String)"maximumExecutionTimeInMs");
        }, Collections.emptyList()));
        this.put("timeoutIntervalInMs", new ConsumerValidator((requestOptions, value) -> {
            requestOptions.setTimeoutIntervalInMs(Integer.valueOf(this.cast.getIntegerProperty(value)));
            ValidationUtil.validPositiveNumber((long)requestOptions.getTimeoutIntervalInMs().intValue(), (String)"timeoutIntervalInMs");
        }, Collections.emptyList()));
    }

    private RetryPolicyFactory getRetryPolicy(RetryConfig retryConfig) {
        switch (retryConfig.getRetryPolicyType()) {
            case EXPONENTIAL: {
                if (RetryConfig.isNonZero(retryConfig.getDeltaBackoffIntervalInMs())) {
                    if (RetryConfig.isNonZero(retryConfig.getResolvedMaxBackoff())) {
                        return new RetryExponentialRetry(retryConfig.getResolvedMinBackoff().intValue(), retryConfig.getDeltaBackoffIntervalInMs().intValue(), retryConfig.getResolvedMaxBackoff().intValue(), retryConfig.getMaximumAttempts().intValue());
                    }
                    return new RetryExponentialRetry(retryConfig.getDeltaBackoffIntervalInMs().intValue(), retryConfig.getMaximumAttempts().intValue());
                }
                return new RetryExponentialRetry();
            }
            case LINEAR: {
                if (RetryConfig.isNonZero(retryConfig.getDeltaBackoffIntervalInMs())) {
                    return new RetryLinearRetry(retryConfig.getDeltaBackoffIntervalInMs().intValue(), retryConfig.getMaximumAttempts().intValue());
                }
                return new RetryLinearRetry();
            }
            case NONE: {
                return new RetryNoRetry();
            }
        }
        throw new ValidationException("Invalid Retry Type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Provider getEncryptionProvider() {
        if (secProvider != null) return secProvider;
        Class<BlobRequestOptionsConsumer> clazz = BlobRequestOptionsConsumer.class;
        synchronized (BlobRequestOptionsConsumer.class) {
            if (secProvider != null) return secProvider;
            for (String name : PREFERABLESECURITYPROVIDERS) {
                Provider provider = Security.getProvider(name);
                if (provider == null) continue;
                secProvider = provider;
                break;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return secProvider;
        }
    }

    static {
        secProvider = null;
        PREFERABLESECURITYPROVIDERS = new String[]{"BC", "JsafeJCE", "SunJCE", "IBMJCE"};
    }
}

