/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public abstract class JRAbstractExporter
implements JRExporter {
    protected Map parameters = new HashMap();
    protected List jasperPrintList = null;
    protected JasperPrint jasperPrint = null;
    protected boolean isModeBatch = true;
    protected int startPageIndex = 0;
    protected int endPageIndex = 0;
    protected int globalOffsetX = 0;
    protected int globalOffsetY = 0;
    protected ClassLoader classLoader = null;
    protected boolean classLoaderSet;
    protected URLStreamHandlerFactory urlHandlerFactory;
    protected boolean urlHandlerFactorySet;
    private LinkedList elementOffsetStack;
    private int elementOffsetX;
    private int elementOffsetY;
    private Map penBoxes;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();

    protected JRAbstractExporter() {
        this.elementOffsetStack = new LinkedList();
        this.elementOffsetX = this.globalOffsetX;
        this.elementOffsetY = this.globalOffsetY;
        this.penBoxes = new HashMap();
    }

    @Override
    public void setParameter(JRExporterParameter parameter, Object value) {
        this.parameters.put(parameter, value);
    }

    @Override
    public Object getParameter(JRExporterParameter parameter) {
        return this.parameters.get(parameter);
    }

    @Override
    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    @Override
    public Map getParameters() {
        return this.parameters;
    }

    @Override
    public abstract void exportReport() throws JRException;

    protected void setOffset() {
        Integer offsetY;
        Integer offsetX = (Integer)this.parameters.get(JRExporterParameter.OFFSET_X);
        if (offsetX != null) {
            this.globalOffsetX = offsetX;
        }
        if ((offsetY = (Integer)this.parameters.get(JRExporterParameter.OFFSET_Y)) != null) {
            this.globalOffsetY = offsetY;
        }
        this.elementOffsetX = this.globalOffsetX;
        this.elementOffsetY = this.globalOffsetY;
    }

    protected void setExportContext() {
        this.classLoaderSet = false;
        this.urlHandlerFactorySet = false;
        this.classLoader = (ClassLoader)this.parameters.get(JRExporterParameter.CLASS_LOADER);
        if (this.classLoader != null) {
            JRResourcesUtil.setThreadClassLoader(this.classLoader);
            this.classLoaderSet = true;
        }
        this.urlHandlerFactory = (URLStreamHandlerFactory)this.parameters.get(JRExporterParameter.URL_HANDLER_FACTORY);
        if (this.urlHandlerFactory != null) {
            JRResourcesUtil.setThreadURLHandlerFactory(this.urlHandlerFactory);
            this.urlHandlerFactorySet = true;
        }
    }

    protected void resetExportContext() {
        if (this.classLoaderSet) {
            JRResourcesUtil.resetClassLoader();
        }
        if (this.urlHandlerFactorySet) {
            JRResourcesUtil.resetThreadURLHandlerFactory();
        }
    }

    protected void setClassLoader() {
        this.setExportContext();
    }

    protected void resetClassLoader() {
        this.resetExportContext();
    }

    protected void setInput() throws JRException {
        this.jasperPrintList = (List)this.parameters.get(JRExporterParameter.JASPER_PRINT_LIST);
        if (this.jasperPrintList == null) {
            this.isModeBatch = false;
            this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
            if (this.jasperPrint == null) {
                InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
                if (is != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
                } else {
                    URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                    if (url != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                    } else {
                        File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                        if (file != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                        } else {
                            String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                            if (fileName != null) {
                                this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                            } else {
                                throw new JRException("No input source supplied to the exporter.");
                            }
                        }
                    }
                }
            }
            this.jasperPrintList = new ArrayList();
            this.jasperPrintList.add(this.jasperPrint);
        } else {
            this.isModeBatch = true;
            if (this.jasperPrintList.size() == 0) {
                throw new JRException("Empty input source supplied to the exporter in batch mode.");
            }
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(0);
        }
    }

    protected void setPageRange() throws JRException {
        Integer start;
        int lastPageIndex = -1;
        if (this.jasperPrint.getPages() != null) {
            lastPageIndex = this.jasperPrint.getPages().size() - 1;
        }
        if ((start = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = start;
            if (this.startPageIndex < 0 || this.startPageIndex > lastPageIndex) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + lastPageIndex);
            }
        }
        Integer end = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (end == null) {
            this.endPageIndex = lastPageIndex;
        } else {
            this.endPageIndex = end;
            if (this.endPageIndex < this.startPageIndex || this.endPageIndex > lastPageIndex) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " (" + this.startPageIndex + " : " + lastPageIndex + ")");
            }
        }
        Integer index = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (index != null) {
            int pageIndex = index;
            if (pageIndex < 0 || pageIndex > lastPageIndex) {
                throw new JRException("Page index out of range : " + pageIndex + " of " + lastPageIndex);
            }
            this.startPageIndex = pageIndex;
            this.endPageIndex = pageIndex;
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
            attributes.putAll(JRFontUtil.setAttributes(attributes, textElement));
            attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
            if (setBackcolor && textElement.getMode() == 1) {
                attributes.put(TextAttribute.BACKGROUND, textElement.getBackcolor());
            }
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(attributes, text);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
            }
        }
        return styledText;
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        return this.getStyledText(textElement, true);
    }

    protected void setOutput() {
    }

    protected int getOffsetX() {
        return this.elementOffsetX;
    }

    protected int getOffsetY() {
        return this.elementOffsetY;
    }

    protected void setFrameElementsOffset(JRPrintFrame frame, boolean relative) {
        if (relative) {
            this.setElementOffsets(0, 0);
        } else {
            int topPadding = frame.getTopPadding();
            int leftPadding = frame.getLeftPadding();
            this.setElementOffsets(this.getOffsetX() + frame.getX() + leftPadding, this.getOffsetY() + frame.getY() + topPadding);
        }
    }

    private void setElementOffsets(int offsetX, int offsetY) {
        this.elementOffsetStack.addLast(new int[]{this.elementOffsetX, this.elementOffsetY});
        this.elementOffsetX = offsetX;
        this.elementOffsetY = offsetY;
    }

    protected void restoreElementOffsets() {
        int[] offsets = (int[])this.elementOffsetStack.removeLast();
        this.elementOffsetX = offsets[0];
        this.elementOffsetY = offsets[1];
    }

    protected JRBox getBox(JRPrintGraphicElement element) {
        byte pen = element.getPen();
        Byte key = new Byte(pen);
        JRBox box = (JRBox)this.penBoxes.get(key);
        if (box == null) {
            box = new JRBaseBox(pen, element.getForecolor());
            this.penBoxes.put(key, box);
        }
        return box;
    }

    protected Locale getTextLocale(JRPrintText text) {
        String localeCode = text.getLocaleCode();
        if (localeCode == null) {
            localeCode = this.jasperPrint.getLocaleCode();
        }
        return localeCode == null ? null : JRDataUtils.getLocale(localeCode);
    }

    protected TimeZone getTextTimeZone(JRPrintText text) {
        String tzId = text.getTimeZoneId();
        if (tzId == null) {
            tzId = this.jasperPrint.getTimeZoneId();
        }
        return tzId == null ? null : JRDataUtils.getTimeZone(tzId);
    }

    protected TextValue getTextValue(JRPrintText text, String textStr) {
        TextValue textValue;
        if (text.getValueClassName() == null) {
            textValue = this.getTextValueString(text, textStr);
        } else {
            try {
                Class valueClass = JRClassLoader.loadClassForName(text.getValueClassName());
                textValue = Number.class.isAssignableFrom(valueClass) ? this.getNumberCellValue(text, textStr) : (Date.class.isAssignableFrom(valueClass) ? this.getDateCellValue(text, textStr) : (Boolean.class.equals((Object)valueClass) ? this.getBooleanCellValue(text, textStr) : this.getTextValueString(text, textStr)));
            }
            catch (ParseException e) {
                textValue = this.getTextValueString(text, textStr);
            }
            catch (ClassNotFoundException e) {
                textValue = this.getTextValueString(text, textStr);
            }
        }
        return textValue;
    }

    protected TextValue getTextValueString(JRPrintText text, String textStr) {
        return new StringTextValue(textStr);
    }

    protected TextValue getBooleanCellValue(JRPrintText text, String textStr) {
        Boolean value = null;
        if (textStr != null || textStr.length() > 0) {
            value = Boolean.valueOf(textStr);
        }
        return new BooleanTextValue(textStr, value);
    }

    protected TextValue getDateCellValue(JRPrintText text, String textStr) throws ParseException {
        TextValue textValue;
        String pattern = text.getPattern();
        if (pattern == null || pattern.trim().length() == 0) {
            textValue = this.getTextValueString(text, textStr);
        } else {
            DateFormat dateFormat = JRDataUtils.getDateFormat(pattern, this.getTextLocale(text), this.getTextTimeZone(text));
            Date value = null;
            if (textStr != null && textStr.length() > 0) {
                value = dateFormat.parse(textStr);
            }
            textValue = new DateTextValue(textStr, value, pattern);
        }
        return textValue;
    }

    protected TextValue getNumberCellValue(JRPrintText text, String textStr) throws ParseException, ClassNotFoundException {
        TextValue textValue;
        String pattern = text.getPattern();
        if (pattern == null || pattern.trim().length() == 0) {
            Number value;
            textValue = textStr != null && textStr.length() > 0 ? ((value = this.defaultParseNumber(textStr, JRClassLoader.loadClassForName(text.getValueClassName()))) != null ? new NumberTextValue(textStr, value, null) : this.getTextValueString(text, textStr)) : new NumberTextValue(textStr, null, null);
        } else {
            NumberFormat numberFormat = JRDataUtils.getNumberFormat(pattern, this.getTextLocale(text));
            Number value = null;
            if (textStr != null && textStr.length() > 0) {
                value = numberFormat.parse(textStr);
            }
            textValue = new NumberTextValue(textStr, value, pattern);
        }
        return textValue;
    }

    protected Number defaultParseNumber(String textStr, Class valueClass) {
        Number value = null;
        try {
            if (valueClass.equals(Byte.class)) {
                value = Byte.valueOf(textStr);
            } else if (valueClass.equals(Short.class)) {
                value = Short.valueOf(textStr);
            } else if (valueClass.equals(Integer.class)) {
                value = Integer.valueOf(textStr);
            } else if (valueClass.equals(Long.class)) {
                value = Long.valueOf(textStr);
            } else if (valueClass.equals(Float.class)) {
                value = Float.valueOf(textStr);
            } else if (valueClass.equals(Double.class)) {
                value = Double.valueOf(textStr);
            } else if (valueClass.equals(BigInteger.class)) {
                value = new BigInteger(textStr);
            } else if (valueClass.equals(BigDecimal.class)) {
                value = new BigDecimal(textStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }
}

