/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.filter.FusionContext;
import coldfusion.s3.request.UploadDirectoryS3Request;
import coldfusion.util.Utils;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.jsp.PageContext;

public class UploadDirectoryS3RequestConsumer
extends ConsumerMap<UploadDirectoryS3Request> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public UploadDirectoryS3RequestConsumer() {
        this.put("prefix", new ConsumerValidator((uploadDirectoryS3Request, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"prefix");
            uploadDirectoryS3Request.setPrefix(input);
        }, Collections.emptyList()));
        this.put("sourceDirectory", new ConsumerValidator((uploadDirectoryS3Request, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"sourceDirectory");
            String srcFile = Optional.ofNullable(FusionContext.getCurrent()).isPresent() && Optional.ofNullable(FusionContext.getCurrent().pageContext).isPresent() ? Utils.getFileFullPath((String)input, (PageContext)FusionContext.getCurrent().pageContext, (boolean)true) : input;
            uploadDirectoryS3Request.setSrcDirectory(srcFile);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("uploadNestedDirectory", new ConsumerValidator((uploadDirectoryS3Request, value) -> uploadDirectoryS3Request.setUploadNestedDirectory(this.cast.getBooleanProperty(value)), Collections.emptyList()));
    }
}

