/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.jdk11;

import ice.debug.Debug;
import ice.util.io.IOKit;
import ice.util.security.BoxedCode;
import ice.util.security.ProxyException;
import ice.util.security.SecurityKit;
import ice.util.security.jdk11.JarCache_jdk11;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

final class URLClassLoader_jdk11
extends ClassLoader {
    private URL[] _urls;
    private boolean[] _is_jar;
    ThreadGroup _threadGroup;

    URLClassLoader_jdk11(URL[] urls) {
        int N = urls.length;
        this._urls = urls;
        this._is_jar = new boolean[N];
        for (int i = 0; i != N; ++i) {
            if (urls[i].toString().endsWith("/")) continue;
            this._is_jar[i] = true;
        }
        JarCache_jdk11 cache = JarCache_jdk11.instance;
        for (int i = 0; i != N; ++i) {
            if (!this._is_jar[i]) continue;
            cache.addJarFile(urls[i]);
        }
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block8: {
            c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    return this.findSystemClass(name);
                }
                catch (ClassNotFoundException e) {
                    try {
                        String r = name.replace('.', '/') + ".class";
                        byte[] data = this.getResourceAsByteArray(r);
                        if (data != null) {
                            c = this.defineClass(name, data, 0, data.length);
                        }
                    }
                    catch (Exception ex) {
                        if (!Debug.ex) break block8;
                        Debug.ex(ex);
                    }
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException("Class <" + name + "> not found anywhere");
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public byte[] getResourceAsByteArray(String name) {
        byte[] data = null;
        JarCache_jdk11 cache = JarCache_jdk11.instance;
        int N = this._urls.length;
        for (int i = 0; i != N && data == null; ++i) {
            URL u = this._urls[i];
            if (this._is_jar[i]) {
                data = cache.getJarData(u.toString(), name);
                continue;
            }
            try {
                URL entry_url = new URL(u, name);
                data = this.readUrl(entry_url);
                continue;
            }
            catch (IOException ex) {
                if (!Debug.ex) continue;
                Debug.ex(ex);
            }
        }
        return data;
    }

    public URL getResource(String name) {
        URL u = URLClassLoader_jdk11.getSystemResource(name);
        if (u != null) {
            return u;
        }
        JarCache_jdk11 cache = JarCache_jdk11.instance;
        int N = this._urls.length;
        for (int i = 0; i != N; ++i) {
            u = this._urls[i];
            if (this._is_jar[i]) {
                String jar = u.toString();
                if (null == cache.getJarData(jar, name)) continue;
                try {
                    return new URL("jar:" + jar + "!/" + name);
                }
                catch (IOException ex) {
                    if (Debug.ex) {
                        Debug.ex(ex);
                    }
                    return null;
                }
            }
            try {
                URL entry_url = new URL(u, name);
                if (null == this.readUrl(entry_url)) continue;
                return entry_url;
            }
            catch (IOException ex) {
                if (!Debug.ex) continue;
                Debug.ex(ex);
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream s = URLClassLoader_jdk11.getSystemResourceAsStream(name);
        if (s != null) {
            return s;
        }
        byte[] data = this.getResourceAsByteArray(name);
        if (data != null) {
            s = new ByteArrayInputStream(data);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readUrl(URL u) throws IOException {
        final URLConnection uc = u.openConnection();
        InputStream is = null;
        try {
            is = (InputStream)SecurityKit.doPrivileged(new BoxedCode(){

                public Object run() {
                    return URLClassLoader_jdk11.getInputStream(uc);
                }
            });
        }
        catch (ProxyException ex) {
            throw (IOException)ex.getTarget();
        }
        if (is != null) {
            try {
                byte[] byArray = IOKit.readAll(is);
                return byArray;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    private static InputStream getInputStream(URLConnection uc) {
        InputStream is;
        try {
            HttpURLConnection hc;
            int code;
            is = uc.getInputStream();
            if (uc instanceof HttpURLConnection && (code = (hc = (HttpURLConnection)uc).getResponseCode()) >= 400) {
                is = null;
            }
        }
        catch (IOException ex) {
            throw new ProxyException(ex);
        }
        return is;
    }

    URL getSecurityContext() {
        return this._urls.length != 0 ? this._urls[this._urls.length - 1] : null;
    }

    protected void finalize() throws Throwable {
        JarCache_jdk11 cache = JarCache_jdk11.instance;
        cache.clear();
        super.finalize();
    }
}

