/*
 * Decompiled with CFR 0.152.
 */
package ice.util.memory;

import ice.util.Defs;

public class MemoryManager {
    private static MemoryManager instance;
    protected final Runtime runtime = Runtime.getRuntime();
    protected long minMemory = 300000L;
    protected long maxMemory = 64000000L;

    public static void setInstance(MemoryManager mem) {
        instance = mem;
    }

    public static MemoryManager getInstance() {
        if (instance == null) {
            instance = new MemoryManager();
        }
        return instance;
    }

    protected MemoryManager() {
        try {
            int t = MemoryManager.parse("ice.browser.minMemory");
            if (t > 0) {
                this.minMemory = t;
            }
            if ((long)(t = MemoryManager.parse("ice.browser.maxMemory")) > this.minMemory) {
                this.maxMemory = t;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static final int parse(String propName) {
        String s = Defs.sysProperty(propName);
        if (s == null) {
            return -1;
        }
        int mult = 1;
        char c = s.charAt(s.length() - 1);
        if (c == 'k' || c == 'K') {
            mult = 1024;
            s = s.substring(0, s.length() - 1);
        }
        if (c == 'm' || c == 'M') {
            mult = 0x100000;
            s = s.substring(0, s.length() - 1);
        }
        return mult * Integer.parseInt(s);
    }

    public void setMinMemory(long m) {
        this.minMemory = m;
    }

    public long getMinMemory() {
        return this.minMemory;
    }

    public void setMaxMemory(long m) {
        this.maxMemory = m;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public boolean canAllocate(int bytes) {
        long mem = this.runtime.freeMemory();
        if (mem - (long)bytes > this.minMemory) {
            return true;
        }
        long total = this.runtime.totalMemory();
        if (this.maxMemory > total && (mem += this.maxMemory - total) - (long)bytes > this.minMemory) {
            return true;
        }
        System.gc();
        mem = this.runtime.freeMemory();
        if (mem - (long)bytes > this.minMemory) {
            return true;
        }
        System.runFinalization();
        System.gc();
        mem = this.runtime.freeMemory();
        return mem - (long)bytes > this.minMemory;
    }

    public boolean isLowMemory() {
        return !this.canAllocate(0);
    }
}

