/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DocumentProxy;
import ice.storm.DynamicObject;
import ice.storm.LoadSession;
import ice.storm.LoadThread;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.ViewportGuiParams;
import ice.storm.ViewportVisitor;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.Listeners;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class Viewport {
    private static final String DEFAULT_NAME = new String("view");
    private static final Object counterLock = new Object();
    private static long viewportCounter = 0L;
    private static final Method createWindowObj = Viewport.getCreateWindowObj();
    private StormBase stormBase;
    private final Object dataLock = new Object();
    private String id;
    private String name;
    protected Viewport parent = null;
    private Viewport first;
    private Viewport last;
    private Viewport next;
    private Viewport prev;
    private final Object loadLock = new Object();
    private LoadSession loadSession;
    private LoadThread loadThread;
    volatile String stateString = "empty";
    protected Container container = null;
    protected Pilot pilot = null;
    private Component pilotComponent = null;
    private final HashArray params = new HashArray();
    private ViewportGuiParams guiParams;
    private Object propertyListeners;
    private int zoom = 256;
    private DynamicObject _windowObj;
    private String historyId = null;
    private String _locationUrl;
    private String _baseUrl;
    private volatile int documentId = 1;
    private boolean frameArrayMember;
    static /* synthetic */ Class class$ice$storm$StormBase;
    static /* synthetic */ Class class$ice$storm$Viewport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeDefaultId(String name) {
        long counter;
        Object object = counterLock;
        synchronized (object) {
            counter = viewportCounter++;
        }
        return '_' + name + '_' + counter;
    }

    private static Method getCreateWindowObj() {
        Class[] sig = new Class[]{class$ice$storm$StormBase == null ? (class$ice$storm$StormBase = Viewport.class$("ice.storm.StormBase")) : class$ice$storm$StormBase, class$ice$storm$Viewport == null ? (class$ice$storm$Viewport = Viewport.class$("ice.storm.Viewport")) : class$ice$storm$Viewport};
        Method m = Defs.getMethod("ice.scripters.WindowObj", "create", sig);
        if (m == null && Debug.trace) {
            Debug.trace("No scripting support");
        }
        return m;
    }

    public Viewport(StormBase storm) {
        this(storm, null);
    }

    public Viewport(StormBase storm, String name) {
        if (storm == null) {
            throw new IllegalArgumentException("StormBase can not be null");
        }
        this.stormBase = storm;
        if (name != null) {
            this.name = name;
            this.id = Viewport.makeDefaultId(this.name);
        } else {
            this.name = this.id = Viewport.makeDefaultId(DEFAULT_NAME);
        }
    }

    final StormBase getStormBase() {
        return this.stormBase;
    }

    public String toString() {
        return "{Viewport id=" + this.id + " name=" + this.name + "}";
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isSyntheticName() {
        if (this.name == this.id) {
            return true;
        }
        return this.name == this.stormBase.initialViewportName;
    }

    public void setName(String s) {
        if (s != null && s.length() != 0) {
            this.stormBase.sendViewportMessage(this, "nameChange", this.name, s);
            this.name = s;
        }
    }

    public int getDocumentId() {
        return this.documentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void increseDocumentId() {
        Object object = this.dataLock;
        synchronized (object) {
            ++this.documentId;
        }
    }

    public void setZoom(int z) {
        if (z <= 0) {
            throw new IllegalArgumentException("Zoom factor must be positive");
        }
        if (this.zoom != z) {
            this.zoom = z;
            Pilot p = this.getPilot();
            if (p != null) {
                p.setZoom(z);
            }
        }
        for (Viewport v = this.first; v != null; v = v.getNextSibling()) {
            v.setZoom(this.zoom);
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        Object object = this.dataLock;
        synchronized (object) {
            this.propertyListeners = Listeners.add(this.propertyListeners, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener l) {
        Object object = this.dataLock;
        synchronized (object) {
            this.propertyListeners = Listeners.remove(this.propertyListeners, l);
        }
    }

    final Object getPropertyListeners() {
        return this.propertyListeners;
    }

    public Container getContainer() {
        return this.container;
    }

    public Container getTopLevelContainer() {
        Container cursor = this.container;
        if (cursor != null) {
            Container parent;
            while ((parent = cursor.getParent()) != null) {
                cursor = parent;
            }
        }
        return cursor;
    }

    public void setContainer(Container c) {
        if (Debug.trace && this.container != null) {
            Debug.trace("Replacing AWT container in " + this);
        }
        this.container = c;
        for (Viewport v = this.first; v != null; v = v.getNextSibling()) {
            v.setContainer(c);
        }
    }

    public void setProperty(Object key, Object value) {
        this.params.put(key, value);
    }

    public void removeProperty(Object key) {
        this.params.remove(key);
    }

    public Object getProperty(Object key) {
        return this.params.get(key);
    }

    public ViewportGuiParams getGuiParams() {
        return this.guiParams;
    }

    public void setGuiParams(ViewportGuiParams value) {
        this.guiParams = value;
    }

    public boolean isStopRequested() {
        Thread t = Thread.currentThread();
        return t instanceof LoadThread && ((LoadThread)t).isStopRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopLoading() {
        Object object = this.loadLock;
        synchronized (object) {
            this.stopLoadingImpl();
        }
        Pilot p = this.pilot;
        if (p != null) {
            p.stopLoading();
        }
    }

    private void stopLoadingImpl() {
        if (this.loadThread != null) {
            this.loadThread.shouldStop();
            this.loadThread.interrupt();
            this.loadThread = null;
        }
        if (this.loadSession != null) {
            if (this.loadSession.onloadParent != null) {
                this.loadSession.onloadParent.removeOnloadBlocker(this.loadSession.parentSessionTag, this.loadLock);
            }
            this.loadSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueRenderContent(ContentLoader cl) {
        Object object = this.loadLock;
        synchronized (object) {
            this.stopLoadingImpl();
            this.loadSession = new LoadSession(cl);
            this.loadSession.onloadParent = this.parent;
            this.loadSession.selfSessionTag = this.addOnloadBlocker(this.loadLock);
            if (this.loadSession.selfSessionTag != this.loadSession) {
                throw new IllegalArgumentException("BAD SESSION CODE");
            }
            if (this.loadSession.onloadParent != null) {
                this.loadSession.parentSessionTag = this.loadSession.onloadParent.addOnloadBlocker(this.loadLock);
            }
            this.loadThread = LoadThread.create(this);
            this.loadThread.loadSession = this.loadSession;
            this.loadThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAsynchronousLoad(LoadSession threadSession) {
        try {
            this.stateString = "busy";
            this.stormBase.do_render_content(threadSession.getContentLoader(), this);
            Object var3_2 = null;
            this.stateString = "ready";
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stateString = "ready";
            Thread current = Thread.currentThread();
            Object object = this.loadLock;
            synchronized (object) {
                if (current == this.loadThread) {
                    this.loadThread = null;
                }
            }
            this.removeOnloadBlocker(threadSession.selfSessionTag, this.loadLock);
            throw throwable;
        }
        Thread current = Thread.currentThread();
        Object object = this.loadLock;
        synchronized (object) {
            if (current == this.loadThread) {
                this.loadThread = null;
            }
        }
        this.removeOnloadBlocker(threadSession.selfSessionTag, this.loadLock);
    }

    public Viewport getNextSibling() {
        return this.next;
    }

    public Viewport getFirstChild() {
        return this.first;
    }

    public void addChild(Viewport v) {
        v.setParent(this);
        v.prev = this.last;
        v.next = null;
        if (this.last != null) {
            this.last.next = v;
        } else {
            this.first = v;
        }
        this.last = v;
        v.setZoom(this.zoom);
    }

    public Enumeration getChildren() {
        if (this.first == null) {
            return null;
        }
        return new ChildrenEnumerator(this.first);
    }

    public int getChildrenCount() {
        int count = 0;
        for (Viewport v = this.first; v != null; v = v.getNextSibling()) {
            ++count;
        }
        return count;
    }

    public Viewport getChildByIndex(int index) {
        Viewport v;
        for (v = this.first; index > 0 && v != null; --index, v = v.getNextSibling()) {
        }
        return v;
    }

    String getHistoryId() {
        if (this.historyId != null) {
            return this.historyId;
        }
        Viewport parent = this.getParent();
        if (parent == null) {
            return this.id;
        }
        this.historyId = "";
        for (Viewport v = parent; v != null; v = v.getParent()) {
            this.historyId = this.historyId + "_" + v.getChildIndex(this);
        }
        this.historyId = this.historyId + "_" + parent.getLocation();
        return this.historyId;
    }

    private int getChildIndex(Viewport child) {
        Viewport v;
        int count = 0;
        for (v = this.first; v != null && v != child; v = v.getNextSibling()) {
            ++count;
        }
        if (v == null) {
            return -1;
        }
        return count;
    }

    public Viewport getParent() {
        return this.parent;
    }

    public Viewport getTopParent() {
        Viewport parent;
        Viewport v = this;
        while ((parent = v.getParent()) != null) {
            v = parent;
        }
        return v;
    }

    void setParent(Viewport p) {
        if (this.parent != null) {
            return;
        }
        this.parent = p;
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public void iterate(ViewportVisitor vc) {
        if (vc == null) {
            return;
        }
        vc.visit(this);
        for (Viewport vv = this.first; vv != null; vv = vv.getNextSibling()) {
            vv.iterate(vc);
        }
    }

    public void getViewAndAllChildren(Vector buffer) {
        buffer.addElement(this);
        for (Viewport vv = this.first; vv != null; vv = vv.getNextSibling()) {
            vv.getViewAndAllChildren(buffer);
        }
    }

    public Viewport findViewportByName(String s) {
        if (s.equals(this.id) || s.equals(this.name)) {
            return this;
        }
        for (Viewport vv = this.first; vv != null; vv = vv.getNextSibling()) {
            Viewport v = vv.findViewportByName(s);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    Viewport findViewportByHistoryId(String s) {
        if (s.equals(this.getHistoryId())) {
            return this;
        }
        for (Viewport vv = this.first; vv != null; vv = vv.getNextSibling()) {
            Viewport v = vv.findViewportByHistoryId(s);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public Viewport findImmediateChild(String s) {
        for (Viewport vv = this.first; vv != null; vv = vv.getNextSibling()) {
            if (!s.equals(vv.id) && !s.equals(vv.name)) continue;
            return vv;
        }
        return null;
    }

    public Viewport getImmediateChildWithProperty(Object key, Object value) {
        for (Viewport vv = this.first; vv != null; vv = vv.getNextSibling()) {
            if (vv.getProperty(key) != value) continue;
            return vv;
        }
        return null;
    }

    public Viewport findViewportInTreeByName(String name) {
        switch (name.length()) {
            case 4: {
                if (!"_top".equals(name)) break;
                return this.getTopParent();
            }
            case 5: {
                if (!"_self".equals(name)) break;
                return this;
            }
            case 7: {
                if (!"_parent".equals(name)) break;
                Viewport vv = this.getParent();
                if (vv == null) {
                    vv = this;
                }
                return vv;
            }
        }
        Viewport v = this;
        do {
            Viewport child;
            if ((child = v.findViewportByName(name)) == null) continue;
            return child;
        } while ((v = v.getParent()) != null);
        return this.stormBase.findViewportByName(name);
    }

    public Component getPilotComponent() {
        return this.pilotComponent;
    }

    public Pilot getPilot() {
        return this.pilot;
    }

    public Pilot getParentChainPilot() {
        Viewport v = this;
        do {
            Pilot p;
            if ((p = v.getPilot()) == null) continue;
            return p;
        } while ((v = v.getParent()) != null);
        return null;
    }

    protected void setPilot(Pilot p) {
        this.removePilot();
        this.pilot = p;
        this.pilot.setZoom(this.zoom);
        if (this.first == null) {
            this.pilotComponent = this.pilot.createComponent();
            if (this.pilotComponent != null && this.container != null) {
                this.pilotComponent.setSize(this.container.getSize());
                this.stormBase.runOnEventThreadLater(new Runnable(){

                    public void run() {
                        if (Viewport.this.pilotComponent != null) {
                            Viewport.this.container.add(Viewport.this.pilotComponent);
                            Viewport.this.container.validate();
                        }
                    }
                }, 0L);
            }
        }
    }

    protected void scheduleValidate(final Component c) {
        this.stormBase.runOnEventThreadLater(new Runnable(){

            public void run() {
                c.validate();
            }
        }, 0L);
    }

    protected void removePilot() {
        this.increseDocumentId();
        if (this.pilot == null) {
            return;
        }
        this.pilot.dispose();
        if (this.pilotComponent != null) {
            if (this.container != null) {
                this.container.remove(this.pilotComponent);
            }
            this.pilotComponent = null;
        }
        this.pilot = null;
    }

    protected void dispose() {
        this.removePilot();
        for (Viewport v = this.first; v != null; v = v.getNextSibling()) {
            v.dispose();
        }
        this.last = null;
        this.first = null;
        this.stormBase.getHistoryManager().clearHistoryForViewport(this);
        this.clearWindowObj();
        this.container = null;
        this.parent = null;
    }

    void clearContent() {
        this.increseDocumentId();
        for (Viewport v = this.first; v != null; v = v.getNextSibling()) {
            v.dispose();
        }
        this.last = null;
        this.first = null;
        if (this.pilot != null && this.pilotComponent == null) {
            this.pilotComponent = this.pilot.createComponent();
            if (this.pilotComponent != null && this.container != null) {
                this.pilotComponent.setSize(this.container.getSize());
                this.stormBase.runOnEventThreadLater(new Runnable(){

                    public void run() {
                        if (Viewport.this.pilotComponent != null) {
                            Viewport.this.container.add(Viewport.this.pilotComponent);
                            Viewport.this.container.validate();
                        }
                    }
                }, 0L);
            }
        }
    }

    public void removePilotComponent() {
        if (this.pilotComponent != null) {
            if (this.container != null) {
                this.container.remove(this.pilotComponent);
            }
            this.pilotComponent = null;
        }
    }

    public void viewportLayout(int x, int y, int w, int h) {
        Pilot p = this.pilot;
        if (p != null) {
            DocPane pane = p.getDocPane();
            if (pane != null) {
                pane.revalidate(x, y, w, h);
            } else {
                Component c = this.pilotComponent;
                if (c != null) {
                    c.setBounds(x, y, w, h);
                    this.scheduleValidate(c);
                }
            }
        }
    }

    public String getLocation() {
        return this._locationUrl;
    }

    public void setLocationUrl(String url) {
        this._locationUrl = url;
        this._baseUrl = null;
    }

    public URL getBaseURL() {
        String base = this.getBaseUrl();
        if (base != null) {
            try {
                return new URL(base);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getBaseUrl() {
        String base = this._baseUrl;
        if (base == null) {
            if (this._locationUrl != null) {
                base = this._locationUrl;
            } else if (this.parent != null) {
                base = this.parent.getBaseUrl();
            }
        }
        return base;
    }

    public void setBaseUrl(String url) {
        if (url == null) {
            Debug.bug();
        }
        this._baseUrl = url;
    }

    public DynamicObject getDynamicWrapper() {
        return this.getWindowObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DynamicObject getWindowObj() {
        DynamicObject window = this._windowObj;
        if (window == null && createWindowObj != null) {
            Object[] args = new Object[]{this.stormBase, this};
            Object object = this.dataLock;
            synchronized (object) {
                block9: {
                    window = this._windowObj;
                    if (window == null) {
                        try {
                            window = this._windowObj = (DynamicObject)createWindowObj.invoke(null, args);
                        }
                        catch (IllegalAccessException ex) {
                            if (Debug.ex) {
                                Debug.ex(ex);
                            }
                        }
                        catch (InvocationTargetException ex) {
                            if (!Debug.ex) break block9;
                            Debug.ex(ex.getTargetException());
                        }
                    }
                }
            }
        }
        return window;
    }

    final void removeWindowVariables() {
        DynamicObject window = this._windowObj;
        if (window != null) {
            window.unlinkAllSlots();
        }
    }

    final void clearWindowObj() {
        DynamicObject window = this._windowObj;
        if (window != null) {
            window.unlinkAllSlots();
        }
        this._windowObj = null;
    }

    public Viewport getContextViewport() {
        return Scripter.contextViewportImpl();
    }

    public DynamicObject getDocumentObject() {
        DynamicObject result = null;
        Pilot pilot = this.getPilot();
        if (pilot != null) {
            result = pilot.getDocumentObject();
        }
        if (result == null) {
            result = new DocumentProxy(this);
        }
        return result;
    }

    public boolean isFrameArrayMember() {
        return this.frameArrayMember;
    }

    public void setFrameArrayMember() {
        this.frameArrayMember = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object addOnloadBlocker(Object blocker) {
        LoadSession session;
        Object object = this.loadLock;
        synchronized (object) {
            session = this.loadSession;
            if (session != null) {
                session.onloadBlockers.put(blocker, (Object)Boolean.TRUE);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeOnloadBlocker(Object sessionObj, Object blocker) {
        LoadSession session = (LoadSession)sessionObj;
        LoadSession finishedSession = null;
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loadSession != null && session == this.loadSession) {
                this.loadSession.onloadBlockers.remove(blocker);
                if (this.loadSession.onloadBlockers.size() == 0) {
                    finishedSession = this.loadSession;
                    this.loadSession = null;
                }
            }
        }
        if (finishedSession != null) {
            try {
                final Pilot p = this.pilot;
                final int currentId = this.getDocumentId();
                if (p != null) {
                    this.stormBase.runOnEventThreadLater(new Runnable(){

                        public void run() {
                            if (currentId == Viewport.this.getDocumentId()) {
                                p.onLoadingDone();
                            }
                        }
                    }, 0L);
                }
                Object var8_8 = null;
                if (finishedSession.onloadParent != null) {
                    finishedSession.onloadParent.removeOnloadBlocker(finishedSession.parentSessionTag, this.loadLock);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (finishedSession.onloadParent != null) {
                    finishedSession.onloadParent.removeOnloadBlocker(finishedSession.parentSessionTag, this.loadLock);
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ChildrenEnumerator
    implements Enumeration {
        private Viewport cursor;

        ChildrenEnumerator(Viewport v) {
            this.cursor = v;
        }

        public boolean hasMoreElements() {
            return this.cursor != null;
        }

        public Object nextElement() {
            Viewport o = this.cursor;
            this.cursor = this.cursor.getNextSibling();
            return o;
        }
    }
}

