/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.LoadSession;
import ice.storm.Viewport;
import ice.util.alg.IThread;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;

final class LoadThread
extends IThread {
    private volatile boolean shouldStop;
    private Viewport view;
    LoadSession loadSession;

    LoadThread(Viewport view) {
        super("Loader for " + view.getId());
        this.view = view;
        this.setDaemon(true);
    }

    static LoadThread create(final Viewport view) {
        return (LoadThread)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                return new LoadThread(view);
            }
        });
    }

    boolean isStopRequested() {
        return this.shouldStop;
    }

    void shouldStop() {
        this.shouldStop = true;
    }

    public void run() {
        this.view.runAsynchronousLoad(this.loadSession);
    }
}

