/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.debug.Debug;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.FocusIndicator;
import ice.pilots.html4.swing.LaFConfig;
import ice.pilots.html4.swing.Movable;
import ice.util.Defs;
import ice.util.alg.HashArray;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;

class FormInputCheckbox
extends JCheckBox
implements ObjectPainter,
Movable {
    private static final String FOCUSIND_ENABLED = "ice.pilots.html4.swing.cbFocusIndEnabled";
    private static final String CUSTOM_FOCUSIND = "ice.pilots.html4.swing.cbFocusIndConfig";
    private static final boolean focusIndEnabled = Defs.sysPropertyBoolean("ice.pilots.html4.swing.cbFocusIndEnabled", true);
    private static HashArray customLafConfigs = new HashArray(4);
    private static LaFConfig currLaFConfig;
    private CSSAttribs css;
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private Border _originalBorder = this.getBorder();

    private static HashArray getLaFConfigs() {
        LaFConfig[] lfc = new LaFConfig[]{new LaFConfig(0, "1.6", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", 9, 9, -9, -9), new LaFConfig(0, "1.6", "javax.swing.plaf.metal.MetalLookAndFeel", 3, 3, -3, -3), new LaFConfig(0, "1.6", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 3, 5, -3, -5), new LaFConfig(0, "1.6", "apple.laf.AquaLookAndFeel", false), new LaFConfig(0, "1.6", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 4, 4, -4, -4), new LaFConfig(0, "1.6", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", 4, 4, -4, -4), new LaFConfig(0, "1.5", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", 6, 6, -6, -6), new LaFConfig(0, "1.5", "javax.swing.plaf.metal.MetalLookAndFeel", 3, 3, -3, -3), new LaFConfig(0, "1.5", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 5, 5, -1, -5), new LaFConfig(0, "1.5", "apple.laf.AquaLookAndFeel", false), new LaFConfig(0, "1.5", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 4, 4, -4, -4), new LaFConfig(0, "1.5", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", 4, 4, -4, -4), new LaFConfig(0, "1.4", "javax.swing.plaf.metal.MetalLookAndFeel", 3, 3, -4, -4), new LaFConfig(0, "1.4", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 5, 5, -1, -5), new LaFConfig(0, "1.4", "apple.laf.AquaLookAndFeel", false), new LaFConfig(0, "1.4.2", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 4, 4, -4, -4), new LaFConfig(0, "1.4.2", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", 4, 4, -4, -4), new LaFConfig(0, "1.4", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 4, 4, -4, -4), new LaFConfig(0, "1.3", "javax.swing.plaf.metal.MetalLookAndFeel", 0, 3, -8, -4), new LaFConfig(0, "1.3", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 1, 5, -5, -5), new LaFConfig(0, "1.3", "apple.laf.AquaLookAndFeel", false), new LaFConfig(0, "1.3", "com.apple.mrj.swing.MacLookAndFeel", false), new LaFConfig(0, "1.3", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 3, -8, -4), new LaFConfig(0, "1.2", "javax.swing.plaf.metal.MetalLookAndFeel", 0, 3, -8, -4), new LaFConfig(0, "1.2", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 1, 5, -5, -5), new LaFConfig(0, "1.2", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 3, -8, -4), new LaFConfig(0, "1.1", "javax.swing.plaf.metal.MetalLookAndFeel", 0, 3, -8, -4), new LaFConfig(0, "1.1", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 1, 5, -5, -5), new LaFConfig(0, "1.1", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 3, -8, -4)};
        HashArray configs = new HashArray(lfc.length);
        for (int i = 0; i < lfc.length; ++i) {
            configs.put(lfc[i].getKey(), (Object)lfc[i]);
        }
        Object[] c = customLafConfigs.getValues();
        for (int i = 0; i < c.length; ++i) {
            Object o = c[i];
            if (o == null) continue;
            LaFConfig config = (LaFConfig)o;
            configs.put(config.getKey(), (Object)config);
        }
        return configs;
    }

    FormInputCheckbox(DocView docView, DElement e) {
        this.docView = docView;
        this.element = (DInputElement)e;
        this.setSelected(this.element.getChecked());
        this.checkAttributes();
        this.setOpaque(false);
        this.setRolloverEnabled(true);
    }

    private void checkAttributes() {
        this.setEnabled(!this.element.getDisabled());
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
        if (this.element.getChecked() != this.isSelected()) {
            this.setSelected(this.element.getChecked());
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        e.consume();
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        if (this.box != null) {
            this.css = box.getCSSAttribs();
        }
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics g) {
        Color c = this.css.getBackgroundColor();
        if (c != null) {
            g.setColor(c);
            g.fillRect(0, 0, this.getPrefWidth(), this.getPrefHeight());
        }
    }

    public void paint(Graphics g) {
        if (this.hasFocus() && focusIndEnabled && FormInputCheckbox.currLaFConfig.enabled) {
            if (this.isFocusPainted()) {
                this.setFocusPainted(false);
            }
            super.paint(g);
            Dimension size = this.getSize();
            FocusIndicator.drawFocusRect(g, FormInputCheckbox.currLaFConfig.xOffset, FormInputCheckbox.currLaFConfig.yOffset, size.width + FormInputCheckbox.currLaFConfig.widthOffset, size.height + FormInputCheckbox.currLaFConfig.heightOffset);
            return;
        }
        if (!this.isFocusPainted()) {
            this.setFocusPainted(true);
        }
        super.paint(g);
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
        }
    }

    public void setBorderVisible(boolean aDrawBorder) {
        if (!aDrawBorder) {
            this._originalBorder = this.getBorder();
            this.setBorder(null);
        } else {
            this.setBorder(this._originalBorder);
        }
    }

    public void setFontHints(CSSAttribs css) {
    }

    public int getClientHeight() {
        return this.getHeight();
    }

    public int getClientWidth() {
        return this.getWidth();
    }

    static {
        if (focusIndEnabled) {
            String configArgs = Defs.sysProperty(CUSTOM_FOCUSIND);
            customLafConfigs = FocusIndicator.parseCustomConfigs(0, configArgs);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("lookAndFeel")) {
                        HashArray lafConfigs = FormInputCheckbox.getLaFConfigs();
                        currLaFConfig = FocusIndicator.findLaFConfig(lafConfigs, new LaFConfig(0, "DEFAULT", "DEFAULT", 3, 3, -4, -4));
                    }
                }
            });
            HashArray lafConfigs = FormInputCheckbox.getLaFConfigs();
            currLaFConfig = FocusIndicator.findLaFConfig(lafConfigs, new LaFConfig(0, "DEFAULT", "DEFAULT", 3, 3, -4, -4));
        } else if (Debug.trace) {
            Debug.trace("Checkbox focus indicators disabled via 'ice.pilots.html4.swing.cbFocusIndEnabled' system property.");
        }
    }
}

