/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

class FormInputCheckbox
extends Checkbox
implements ObjectPainter,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private Checkbox none;

    FormInputCheckbox(DocView docView, DElement e, Checkbox none) {
        this.docView = docView;
        this.element = (DInputElement)e;
        this.none = none;
        this.checkAttributes();
        this.enableEvents(28L);
    }

    public void setFont(Font f) {
    }

    private void checkAttributes() {
        this.setEnabled(!this.element.getDisabled());
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        if (this.getState() != this.element.getChecked()) {
            if (!this.element.getChecked() && this.none != null) {
                this.none.setState(true);
            } else {
                this.setState(this.element.getChecked());
            }
        }
        this.checkAttributes();
    }

    public void setState(boolean state) {
        if (state == this.element.getChecked()) {
            super.setState(state);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        e.consume();
        super.processMouseEvent(e);
    }

    protected void processKeyEvent(KeyEvent e) {
        e.consume();
        super.processKeyEvent(e);
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics g) {
        if (this.isVisible() && this.box != null) {
            Color c = this.box.getBackgroundColor();
            if (c != null) {
                this.setBackground(c);
            }
        } else {
            g.setColor(Color.lightGray);
            g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
        }
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
    }

    public int getClientHeight() {
        return this.getSize().height;
    }

    public int getClientWidth() {
        return this.getSize().width;
    }
}

